/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;

public class EGLSetStateProposalHandler
extends EGLAbstractProposalHandler {
    public static final int NONE_STATE = -1;
    public static final int ALL_STATE = 0;
    public static final int ITEM_STATE = 1;
    public static final int RECORD_ITEM_STATE = 2;
    public static final int RECORD_STATE = 3;
    public static final int INDEXED_STATE = 4;
    public static final int PRINT_FORM_STATE = 5;
    public static final int TEXT_FORM_STATE = 6;
    public static final int TEXT_FIELD_STATE = 7;
    public static final int RECORD_ARRAY_STATE = 8;
    public static final int DLI_RECORD_STATE = 9;
    public static final String[] NONE_STATE_STRINGS = new String[0];
    public static final String[] ITEM_STATE_STRINGS = new String[0];
    public static final String[] RECORD_ITEM_STATE_STRINGS = new String[0];
    public static final String[] RECORD_STATE_STRINGS = new String[]{"initial", "empty"};
    public static final String[] INDEXED_STATE_STRINGS = new String[]{"empty", "initial", "position"};
    public static final String[] DLI_RECORD_STATE_STRINGS = new String[]{"empty", "initial", "position"};
    public static final String[] PRINT_FORM_STATE_STRINGS = new String[]{"empty", "initial", "initialAttributes"};
    public static final String[] TEXT_FORM_STATE_STRINGS = new String[]{"alarm", "empty", "initial", "initialAttributes"};
    public static final String[] TEXT_FIELD_STATE_STRINGS = new String[]{"cursor", "empty", "full", "initial", "initialAttributes", "modified", "normal", "black", "blue", "cyan", "defaultColor", "green", "magenta", "red", "white", "yellow", "blink", "nohighlight", "reverse", "underline", "bold", "dim", "invisible", "masked", "normalIntensity", "protect", "skip", "unprotect"};
    public static final String[] RECORD_ARRAY_STATE_STRINGS = new String[]{"empty"};

    public EGLSetStateProposalHandler(ITextViewer viewer, int documentOffset, String prefix) {
        super(viewer, documentOffset, prefix);
    }

    public List getProposals(IDataBinding targetBinding, IPartBinding enclosingPart, List currentStates) {
        List availableStrings = new ArrayList();
        String additionalInfo = "";
        currentStates = this.toLowerCase(currentStates);
        switch (this.getType(targetBinding)) {
            case -1: {
                availableStrings = this.getAvailableStates(NONE_STATE_STRINGS, currentStates);
                additionalInfo = UINlsStrings.CAProposal_ItemState;
                break;
            }
            case 1: {
                availableStrings = this.getAvailableStates(ITEM_STATE_STRINGS, currentStates);
                additionalInfo = UINlsStrings.CAProposal_ItemState;
                break;
            }
            case 2: {
                availableStrings = 5 == targetBinding.getKind() && !((StructureItemBinding)targetBinding).getChildren().isEmpty() ? this.getAvailableStates(new String[]{"empty"}, currentStates) : this.getAvailableStates(RECORD_ITEM_STATE_STRINGS, currentStates);
                additionalInfo = UINlsStrings.CAProposal_RecordItemState;
                break;
            }
            case 3: {
                availableStrings = this.getAvailableStates(RECORD_STATE_STRINGS, currentStates);
                additionalInfo = UINlsStrings.CAProposal_RecordState;
                break;
            }
            case 4: {
                availableStrings = this.getAvailableStates(INDEXED_STATE_STRINGS, currentStates);
                additionalInfo = UINlsStrings.CAProposal_IndexedState;
                break;
            }
            case 5: {
                availableStrings = this.getAvailableStates(PRINT_FORM_STATE_STRINGS, currentStates);
                additionalInfo = UINlsStrings.CAProposal_PrintFormState;
                break;
            }
            case 6: {
                availableStrings = this.getAvailableStates(TEXT_FORM_STATE_STRINGS, currentStates);
                additionalInfo = UINlsStrings.CAProposal_TextFormState;
                break;
            }
            case 7: {
                availableStrings = this.getAvailableStates(TEXT_FIELD_STATE_STRINGS, currentStates);
                additionalInfo = UINlsStrings.CAProposal_TextFieldState;
                break;
            }
            case 8: {
                availableStrings = this.getAvailableStates(RECORD_ARRAY_STATE_STRINGS, currentStates);
                additionalInfo = UINlsStrings.CAProposal_RecordArrayState;
                break;
            }
            case 9: {
                availableStrings = this.getAvailableStates(DLI_RECORD_STATE_STRINGS, currentStates);
                additionalInfo = UINlsStrings.CAProposal_DLISegmentRecordState;
                break;
            }
            default: {
                String[] strings = this.getStrings(new String[]{"alarm", "cursor", "empty", "full", "initial", "initialAttributes", "modified", "position"}, currentStates);
                additionalInfo = UINlsStrings.CAProposal_SetState;
                List proposals = this.getProposals(strings, additionalInfo, 55, 0);
                strings = this.getStrings(new String[]{"black", "blue", "cyan", "defaultColor", "green", "magenta", "red", "white", "yellow"}, currentStates);
                additionalInfo = UINlsStrings.CAProposal_ColorState;
                proposals.addAll(this.getProposals(strings, additionalInfo, 55, 0));
                strings = this.getStrings(new String[]{"blink", "nohighlight", "reverse", "underline"}, currentStates);
                additionalInfo = UINlsStrings.CAProposal_HighlightingState;
                proposals.addAll(this.getProposals(strings, additionalInfo, 55, 0));
                strings = this.getStrings(new String[]{"bold", "invisible", "dim", "masked", "normalIntensity"}, currentStates);
                additionalInfo = UINlsStrings.CAProposal_IntensityState;
                proposals.addAll(this.getProposals(strings, additionalInfo, 55, 0));
                strings = this.getStrings(new String[]{"protect", "skip", "unprotect"}, currentStates);
                additionalInfo = UINlsStrings.CAProposal_ProtectionState;
                proposals.addAll(this.getProposals(strings, additionalInfo, 55, 0));
                return proposals;
            }
        }
        return this.getProposals(availableStrings.toArray(new String[availableStrings.size()]), additionalInfo);
    }

    private String[] getStrings(String[] strings, List currentStates) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < strings.length) {
            if (!currentStates.contains(strings[i].toLowerCase())) {
                result.add(strings[i]);
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    private List toLowerCase(List currentStates) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = currentStates.iterator();
        while (iter.hasNext()) {
            result.add(((String)iter.next()).toLowerCase());
        }
        return result;
    }

    private List getAvailableStates(String[] allStrings, List currentStates) {
        ArrayList<String> available = new ArrayList<String>();
        int i = 0;
        while (i < allStrings.length) {
            String string = allStrings[i];
            if (!currentStates.contains(string.toLowerCase())) {
                available.add(string);
            }
            ++i;
        }
        return available;
    }

    private int getType(IDataBinding targetBinding) {
        if (targetBinding == null || IBinding.NOT_FOUND_BINDING == targetBinding) {
            return 0;
        }
        switch (targetBinding.getKind()) {
            case 7: {
                return 7;
            }
            case 5: 
            case 14: {
                return 2;
            }
        }
        ITypeBinding typeBinding = targetBinding.getType();
        if (typeBinding == null || IBinding.NOT_FOUND_BINDING == typeBinding || typeBinding.isDynamic()) {
            return 0;
        }
        switch (typeBinding.getKind()) {
            case 6: 
            case 7: {
                return 3;
            }
            case 5: {
                return -1;
            }
            case 3: {
                return 1;
            }
            case 2: {
                int elementKind = ((ArrayTypeBinding)typeBinding).getElementType().getKind();
                if (6 == elementKind || 7 == elementKind) {
                    return 8;
                }
                return -1;
            }
        }
        return 0;
    }
}

