/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.internal.search.AllPartsCache;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.Strings;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNode;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNodeFile;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNodeFolder;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DeploymentUtilities {
    private static final String RUIHANDLER = InternUtil.intern((String)"RUIHandler");
    private static DeploymentUtilities instance = new DeploymentUtilities();

    private DeploymentUtilities() {
    }

    public static Map getAllRUIHandlersInProject(IEGLProject project) throws EGLModelException {
        return DeploymentUtilities.getAllRUIHandlersInProject(project, false);
    }

    public static Map getAllRUIHandlersInProject(IEGLProject project, boolean searchReferencedProjects) throws EGLModelException {
        ArrayList handlerList = new ArrayList();
        IEGLSearchScope projSearchScope = SearchEngine.createEGLSearchScope((IEGLElement[])new IEGLElement[]{project}, (boolean)searchReferencedProjects);
        AllPartsCache.getParts((IEGLSearchScope)projSearchScope, (int)512, (IProgressMonitor)new NullProgressMonitor(), handlerList);
        HashMap<String, String> ruiMap = new HashMap<String, String>();
        for (PartInfo partinfo : handlerList) {
            BinaryPart binaryPart;
            int idx;
            String htmlDefault;
            String impl;
            IPart part = partinfo.resolvePart(projSearchScope);
            if (part instanceof SourcePart) {
                SourcePart sourcePart = (SourcePart)partinfo.resolvePart(projSearchScope);
                if (!sourcePart.isHandler() || sourcePart.getSubTypeSignature() == null || RUIHANDLER != InternUtil.intern((String)Signature.toString((String)sourcePart.getSubTypeSignature()))) continue;
                impl = partinfo.getFullyQualifiedName();
                htmlDefault = impl;
                idx = htmlDefault.lastIndexOf(46);
                if (idx != -1) {
                    htmlDefault = htmlDefault.substring(idx + 1);
                }
                ruiMap.put(impl, htmlDefault);
                continue;
            }
            if (!(part instanceof BinaryPart) || !(binaryPart = (BinaryPart)partinfo.resolvePart(projSearchScope)).isHandler() || binaryPart.getSubTypeSignature() == null || RUIHANDLER != InternUtil.intern((String)Signature.toString((String)binaryPart.getSubTypeSignature()))) continue;
            impl = partinfo.getFullyQualifiedName();
            htmlDefault = impl;
            idx = htmlDefault.lastIndexOf(46);
            if (idx != -1) {
                htmlDefault = htmlDefault.substring(idx + 1);
            }
            ruiMap.put(impl, htmlDefault);
        }
        return ruiMap;
    }

    public static final void buildResourceTree(final TreeNode seed, final List results) throws CoreException {
        final IResource seedResource = seed.getResource();
        try {
            seedResource.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (!resource.equals((Object)seedResource)) {
                        switch (resource.getType()) {
                            case 1: {
                                if (this.validFile(resource)) {
                                    TreeNodeFile fileNode = new TreeNodeFile(seed, resource);
                                    results.add(fileNode);
                                }
                                return false;
                            }
                            case 2: {
                                if (this.validFolder(resource)) {
                                    TreeNodeFolder folderNode = new TreeNodeFolder(seed, resource);
                                    results.add(folderNode);
                                }
                                return false;
                            }
                        }
                        return false;
                    }
                    return true;
                }

                private boolean validFolder(IResource resource) {
                    return true;
                }

                private boolean validFile(IResource resource) {
                    String name = resource.getName();
                    return !name.startsWith(".");
                }
            }, 1, false);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static final void findFolder(IProject project, List<IResource> results, String[] targetFolders) throws CoreException {
        if (targetFolders == null) {
            return;
        }
        int i = 0;
        while (i < targetFolders.length) {
            DeploymentUtilities.findFolder(project, results, targetFolders[i]);
            ++i;
        }
    }

    public static final void findFolder(IProject project, final List<IResource> results, final String targetFolder) throws CoreException {
        if (targetFolder == null || targetFolder.length() == 0) {
            return;
        }
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    switch (resource.getType()) {
                        case 1: {
                            return false;
                        }
                        case 2: {
                            if (resource.getName().toLowerCase().equals(targetFolder.toLowerCase())) {
                                results.add(resource);
                            }
                            return false;
                        }
                        case 4: {
                            return true;
                        }
                    }
                    return false;
                }
            }, 1, false);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void getJavaSourceFolders(IProject sourceProject, List<IResource> resources) throws CoreException, JavaModelException {
        IClasspathEntry[] entries;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject javaProject = JavaCore.create((IProject)sourceProject);
        if ((PlatformUI.isWorkbenchRunning() && javaProject.exists() && javaProject.isOpen() || !PlatformUI.isWorkbenchRunning() && javaProject.exists()) && (entries = javaProject.getResolvedClasspath(true)) != null && entries.length > 0) {
            int idx = entries.length - 1;
            while (idx >= 0) {
                IResource element;
                if (entries[idx].getEntryKind() == 3 && (element = root.findMember(entries[idx].getPath())) != null && element.exists()) {
                    resources.add(element);
                }
                --idx;
            }
        }
    }

    public static void displayErrorDialog(String title, String message) {
        ErrorDialog.openError((Shell)DeploymentUtilities.getShell(), (String)title, (String)message, (IStatus)new Status(4, "org.eclipse.edt.ide.ui", 4, message, null));
    }

    public static final Shell getShell() {
        IWorkbenchWindow workbenchWindow;
        Shell shell = null;
        Display display = DeploymentUtilities.getDisplay();
        if (display != null) {
            shell = display.getActiveShell();
        }
        if (shell == null && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = workbenchWindow.getShell();
        }
        return shell;
    }

    public static final Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static List<PartDeclarationInfo> getSystemServices() {
        ArrayList<PartDeclarationInfo> services = new ArrayList<PartDeclarationInfo>();
        return services;
    }

    private static String convert(String[] pkg) {
        StringBuilder buff = new StringBuilder();
        if (pkg != null) {
            int i = 0;
            while (i < pkg.length) {
                buff.append(pkg[i]);
                ++i;
            }
        }
        return buff.toString();
    }

    private class SystemPartInfo
    extends PartDeclarationInfo {
        public SystemPartInfo(String[] pkg, String name, char partType) {
            super(Strings.concatenate(pkg, "."), name, new char[0][0], "SYSTEM", "SYSTEM", "SYSTEM", "", partType);
        }
    }
}

