/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.EditorUtility;
import org.eclipse.edt.ide.ui.internal.editor.IProblemChangedListener;
import org.eclipse.edt.ide.ui.internal.viewsupport.ElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class EditorErrorTickUpdater
implements IProblemChangedListener {
    private EGLEditor fEGLEditor;
    private ElementImageProvider fImageLabelProvider = new ElementImageProvider();

    public EditorErrorTickUpdater(EGLEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEGLEditor = editor;
        EDTUIPlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    @Override
    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (isMarkerChange) {
            return;
        }
        IEditorInput input = this.fEGLEditor.getEditorInput();
        if (input != null && input instanceof IFileEditorInput) {
            int i = 0;
            while (i < changedResources.length) {
                if (changedResources[i].equals((Object)((FileEditorInput)input).getFile())) {
                    this.updateEditorImage(input);
                }
                ++i;
            }
        }
    }

    public void updateEditorImage(IEditorInput input) {
        Image titleImage = this.fEGLEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        ImageDescriptor nodeIcon = PluginImages.DESC_OBJS_EGLFILE;
        int fImageFlags = EditorUtility.populateNodeErrorWarningHashMaps(this.fEGLEditor);
        Image newImage = this.fImageLabelProvider.getImageLabel(nodeIcon, fImageFlags);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.fEGLEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    EditorErrorTickUpdater.this.fEGLEditor.updatedTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        EDTUIPlugin.getDefault().getProblemMarkerManager().removeListener(this);
    }
}

