/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.core.internal.model.util.EGLModelUtil;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchMessages;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.ui.IWorkingSet;

public class SearchUtil
extends EGLModelUtil {
    public static int LRU_WORKINGSET_LIST_SIZE = 3;

    public static IEGLElement getEGLElement(IMarker marker) {
        IEGLElement egle;
        block9: {
            if (marker == null || !marker.exists()) {
                return null;
            }
            String handleId = (String)marker.getAttribute("org.eclipse.edt.ide.ui.search.handleID");
            egle = EGLCore.create((String)handleId);
            if (egle != null) break block9;
            return null;
        }
        try {
            if (!marker.getAttribute("org.eclipse.edt.ide.ui.search.isWorkingCopy", false) && egle != null && egle.exists()) {
                return egle;
            }
            IEGLFile cu = SearchUtil.findEGLFile(egle);
            if (cu == null || !cu.exists()) {
                cu = (IEGLFile)EGLCore.create((IResource)marker.getResource());
            }
            IWorkingCopy[] workingCopies = EGLUI.getSharedWorkingCopiesOnEGLPath();
            int i = 0;
            while (i < workingCopies.length) {
                if (workingCopies[i].getOriginalElement().equals(cu)) {
                    egle = SearchUtil.findInWorkingCopy(workingCopies[i], egle, true);
                    break;
                }
                ++i;
            }
            if (egle != null && !egle.exists()) {
                IEGLElement[] eglElements = cu.findElements(egle);
                egle = eglElements == null || eglElements.length == 0 ? cu.getElementAt(marker.getAttribute("charStart", 0)) : eglElements[0];
            }
            return egle;
        }
        catch (CoreException coreException) {
            EGLLogger.log((Object)EGLSearchMessages.SearchErrorCreateEGLElementTitle, EGLSearchMessages.SearchErrorCreateEGLElementMessage);
            return null;
        }
    }

    public static IEGLElement getEGLElement(Object entry) {
        if (entry != null && SearchUtil.isISearchResultViewEntry(entry)) {
            return SearchUtil.getEGLElement((ISearchResultViewEntry)entry);
        }
        return null;
    }

    public static IResource getResource(Object entry) {
        if (entry != null && SearchUtil.isISearchResultViewEntry(entry)) {
            return ((ISearchResultViewEntry)entry).getResource();
        }
        return null;
    }

    public static IEGLElement getEGLElement(ISearchResultViewEntry entry) {
        if (entry != null) {
            return SearchUtil.getEGLElement(entry.getSelectedMarker());
        }
        return null;
    }

    public static boolean isSearchPlugInActivated() {
        return Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.search").isPluginActivated();
    }

    public static boolean isISearchResultViewEntry(Object object) {
        return object != null && SearchUtil.isSearchPlugInActivated() && object instanceof ISearchResultViewEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IEGLElement findInWorkingCopy(IWorkingCopy workingCopy, IEGLElement element, boolean reconcile) throws EGLModelException {
        if (workingCopy != null) {
            if (reconcile) {
                IWorkingCopy iWorkingCopy = workingCopy;
                synchronized (iWorkingCopy) {
                    workingCopy.reconcile();
                    return SearchUtil.findInEGLFile((IEGLFile)((IEGLFile)workingCopy), (IEGLElement)element);
                }
            }
            return SearchUtil.findInEGLFile((IEGLFile)((IEGLFile)workingCopy), (IEGLElement)element);
        }
        return null;
    }

    static IEGLFile findEGLFile(IEGLElement element) {
        if (element == null) {
            return null;
        }
        if (element.getElementType() == 6) {
            return (IEGLFile)element;
        }
        if (element instanceof IMember) {
            return ((IMember)element).getEGLFile();
        }
        return SearchUtil.findEGLFile(element.getParent());
    }

    public static Object toString(IWorkingSet[] workingSets) {
        if (workingSets != null & workingSets.length > 0) {
            String string = new String();
            int i = 0;
            while (i < workingSets.length) {
                if (i > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + workingSets[i].getName();
                ++i;
            }
            return string;
        }
        return null;
    }
}

