/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.compiler.internal.EGLPropertyRule;

public class CapabilityFilterUtility {
    static final String[] EGLCORE = new String[]{"egl", "core"};
    static final String[] EGLJAVA = new String[]{"egl", "java"};
    static final String[] EGLUIJASPER = new String[]{"egl", "ui", "jasper"};
    static final String[] EGLUIJSF = new String[]{"egl", "ui", "jsf"};
    static final String[] EGLUITEXT = new String[]{"egl", "ui", "text"};
    static final String[] EGLUICONSOLE = new String[]{"egl", "ui", "console"};
    static final String[] EGLUIWEBTRANSACTION = new String[]{"egl", "ui", "webTransaction"};
    static final String[] EGLBIRT = new String[]{"egl", "report", "birt"};
    static final String[] EGLIOSQL = new String[]{"egl", "io", "sql"};
    static final String[] EGLIOFILE = new String[]{"egl", "io", "file"};
    static final String[] EGLIOMQ = new String[]{"egl", "io", "mq"};
    static final String[] EGLIODLI = new String[]{"egl", "io", "dli"};
    static final String[] EGLUIRUI = new String[]{"egl", "ui", "rui"};
    private static IPartBindingFilter[] defaultPartBindingFilters = new IPartBindingFilter[]{new PackageNameFilter(new String[][]{EGLJAVA, EGLUIJSF}){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isJSF();
        }
    }, new PackageNameFilter(EGLIODLI){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isDLI();
        }
    }, new PackageNameFilter(EGLUICONSOLE){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isCUI();
        }
    }, new PackageNameFilter(EGLUIJASPER){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isReports();
        }
    }, new PackageNameFilter(EGLUITEXT){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isTUI();
        }
    }, new PackageNameFilter(EGLUIWEBTRANSACTION){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isVGUI();
        }
    }, new PackageNameFilter(EGLBIRT){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isBIRT();
        }
    }, new PackageNameFilter(EGLIOMQ){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isMQ();
        }
    }, new PackageNameFilter(EGLUIRUI){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isRUI();
        }
    }};
    private static IPropertyRuleFilter[] defaultPropertyRuleFilters = new IPropertyRuleFilter[]{new PackageNameFilter(new String[][]{EGLJAVA, EGLUIJSF}){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isJSF();
        }
    }, new PackageNameFilter(EGLIODLI){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isDLI();
        }
    }, new PackageNameFilter(EGLUICONSOLE){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isCUI();
        }
    }, new PackageNameFilter(EGLUIJASPER){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isReports();
        }
    }, new PackageNameFilter(EGLUITEXT){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isTUI();
        }
    }, new PackageNameFilter(EGLUIWEBTRANSACTION){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isVGUI();
        }
    }, new PackageNameFilter(EGLBIRT){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isBIRT();
        }
    }, new PackageNameFilter(EGLIOMQ){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isMQ();
        }
    }, new PackageNameFilter(EGLUIRUI){

        @Override
        protected boolean isAllowed() {
            return EGLBasePlugin.isRUI();
        }
    }};

    public static Collection filterParts(Collection partBindings) {
        return CapabilityFilterUtility.filterParts(partBindings, new IPartBindingFilter[0]);
    }

    public static Collection filterParts(Collection partBindings, IPartBindingFilter[] additionalFilters) {
        ArrayList<IPartBinding> result = new ArrayList<IPartBinding>();
        for (IPartBinding next : partBindings) {
            boolean passes = true;
            int i = 0;
            while (i < defaultPartBindingFilters.length && passes) {
                passes = defaultPartBindingFilters[i].partBindingPasses(next);
                ++i;
            }
            i = 0;
            while (i < additionalFilters.length && passes) {
                passes = additionalFilters[i].partBindingPasses(next);
                ++i;
            }
            if (!passes) continue;
            result.add(next);
        }
        return result;
    }

    public static Collection filterPropertyRules(Collection propertyRules) {
        return CapabilityFilterUtility.filterPropertyRules(propertyRules, new IPropertyRuleFilter[0]);
    }

    public static Collection filterPropertyRules(Collection propertyRules, IPropertyRuleFilter[] additionalFilters) {
        ArrayList<EGLPropertyRule> result = new ArrayList<EGLPropertyRule>();
        if (propertyRules != null) {
            for (EGLPropertyRule next : propertyRules) {
                boolean passes = true;
                int i = 0;
                while (i < defaultPropertyRuleFilters.length && passes) {
                    passes = defaultPropertyRuleFilters[i].propertyRulePasses(next);
                    ++i;
                }
                i = 0;
                while (i < additionalFilters.length && passes) {
                    passes = additionalFilters[i].propertyRulePasses(next);
                    ++i;
                }
                if (!passes) continue;
                result.add(next);
            }
        }
        return result;
    }

    public static interface IPartBindingFilter {
        public boolean partBindingPasses(IPartBinding var1);
    }

    public static interface IPropertyRuleFilter {
        public boolean propertyRulePasses(EGLPropertyRule var1);
    }

    public static abstract class PackageNameFilter
    implements IPartBindingFilter,
    IPropertyRuleFilter {
        private String[][] packageNames;

        public PackageNameFilter(String[] packageName) {
            this(new String[][]{packageName});
        }

        public PackageNameFilter(String[][] packageNames) {
            this.packageNames = packageNames;
        }

        private boolean allowed(String[] packageName) {
            boolean passes = true;
            int i = 0;
            while (i < this.packageNames.length && passes) {
                if (this.equals(packageName, this.packageNames[i])) {
                    passes = this.isAllowed();
                }
                ++i;
            }
            return passes;
        }

        @Override
        public boolean partBindingPasses(IPartBinding partBinding) {
            return this.allowed(partBinding.getPackageName());
        }

        @Override
        public boolean propertyRulePasses(EGLPropertyRule propertyRule) {
            return this.allowed(propertyRule.getPackageName());
        }

        protected abstract boolean isAllowed();

        private boolean equals(String[] partPackageName, String[] packageName2) {
            if (partPackageName == null || partPackageName.length != packageName2.length) {
                return false;
            }
            int i = 0;
            while (i < partPackageName.length) {
                if (!partPackageName[i].equalsIgnoreCase(packageName2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

