/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.impl;

import java.util.ArrayList;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlOpenStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.impl.SqlIOStatementImpl;
import org.eclipse.edt.mof.eglx.persistence.sql.utils.SQL;

public class SqlOpenStatementImpl
extends SqlIOStatementImpl
implements SqlOpenStatement {
    @Override
    public Expression getResultSet() {
        return this.getTarget();
    }

    @Override
    public String getSqlString() {
        String sql = super.getSqlString();
        if (sql == null || "".equals(sql)) {
            sql = this.generateDefaultSqlString();
            this.setSqlString(sql);
        }
        return sql;
    }

    private String generateDefaultSqlString() {
        Expression target;
        EGLClass targetType;
        StringBuilder sql = new StringBuilder();
        if (this.getTargets().size() == 2 && !TypeUtils.isDynamicType((Type)(targetType = (EGLClass)(target = (Expression)this.getTargets().get(1)).getType().getClassifier()))) {
            sql.append("SELECT ");
            ArrayList<Field> idFields = new ArrayList<Field>();
            boolean doComma = false;
            for (Field f : targetType.getFields()) {
                if (SQL.isKeyField(f)) {
                    idFields.add(f);
                }
                if (!SQL.isReadable(f)) continue;
                if (doComma) {
                    sql.append(", ");
                }
                if (SQL.isTextType(f.getType().getClassifier())) {
                    sql.append("RTRIM(");
                    sql.append(SQL.getColumnName(f));
                    sql.append(")");
                } else {
                    sql.append(SQL.getColumnName(f));
                }
                if (doComma) continue;
                doComma = true;
            }
            sql.append(" FROM ");
            sql.append(SQL.getTableName(targetType));
            if (!idFields.isEmpty()) {
                sql.append(" WHERE ");
                boolean doAnd = false;
                for (Field f : idFields) {
                    if (doAnd) {
                        sql.append(" AND ");
                    }
                    sql.append(String.valueOf(SQL.getColumnName(f)) + " = ?");
                    if (doAnd) continue;
                    doAnd = true;
                }
            }
        }
        return sql.toString();
    }
}

