/*
 * Decompiled with CFR 0.152.
 */
package eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.InvalidArgumentException;
import eglx.lang.TypeCastException;
import java.util.Calendar;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.util.DateTimeUtil;

public class DateTimeLib
extends ExecutableBase {
    private static final long serialVersionUID = 10L;

    public static Calendar dateFromInt(int dateint) {
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.setTimeInMillis((long)dateint * 1000L * 86400L);
        return cal;
    }

    public static Calendar dateFromGregorian(int gregorianIntDate) throws AnyException {
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.set(1, gregorianIntDate / 10000);
        cal.set(2, gregorianIntDate % 10000 / 100 - 1);
        cal.set(5, gregorianIntDate % 100);
        try {
            cal.setTimeInMillis(cal.getTimeInMillis());
        }
        catch (IllegalArgumentException e) {
            TypeCastException tcx = new TypeCastException();
            tcx.castToName = "date";
            tcx.actualTypeName = "int";
            tcx.initCause(e);
            throw tcx.fillInMessage("EGL0007E", gregorianIntDate, tcx.actualTypeName, tcx.castToName);
        }
        return cal;
    }

    public static Calendar dateFromJulian(int julianIntDate) throws AnyException {
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.add(1, 1);
        cal.set(1, julianIntDate / 1000);
        cal.set(6, julianIntDate % 1000);
        try {
            cal.setTimeInMillis(cal.getTimeInMillis());
        }
        catch (IllegalArgumentException e) {
            TypeCastException tcx = new TypeCastException();
            tcx.castToName = "date";
            tcx.actualTypeName = "int";
            tcx.initCause(e);
            throw tcx.fillInMessage("EGL0007E", julianIntDate, tcx.actualTypeName, tcx.castToName);
        }
        return cal;
    }

    public static Calendar mdy(int month, int day, int year) throws AnyException {
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        try {
            cal.setTimeInMillis(cal.getTimeInMillis());
        }
        catch (IllegalArgumentException e) {
            InvalidArgumentException ex = new InvalidArgumentException();
            ex.initCause(e);
            throw ex.fillInMessage("EGL0006E", month, day, year);
        }
        return cal;
    }
}

