/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet;

import eglx.http.Request;
import eglx.http.Response;
import eglx.json.JsonLib;
import eglx.json.JsonUtilities;
import eglx.lang.AnyException;
import eglx.services.ServiceInvocationException;
import eglx.services.ServiceKind;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.json.ArrayNode;
import org.eclipse.edt.javart.json.JsonParser;
import org.eclipse.edt.javart.json.ObjectNode;
import org.eclipse.edt.javart.services.FunctionParameterKind;
import org.eclipse.edt.javart.services.FunctionSignature;
import org.eclipse.edt.javart.services.ServiceBase;
import org.eclipse.edt.javart.services.ServiceUtilities;
import org.eclipse.edt.javart.services.servlet.LocalServiceInvoker;
import org.eclipse.edt.runtime.java.eglx.lang.EDictionary;

public class JsonRpcInvoker
extends LocalServiceInvoker {
    private static String JSON_RPC_METHOD_ID = "method";
    private static String JSON_RPC_PARAMETER_ID = "params";
    private static String JSON_RPC_RESULT_ID = "result";

    public JsonRpcInvoker(String serviceClassName, ServiceKind serviceKind) {
        super(serviceClassName, serviceKind);
    }

    @Override
    public Response invoke(Request request) throws AnyException {
        if (this.trace()) {
            this.tracer().put("invoking " + this.getServiceClassName() + " using " + ServiceUtilities.convert(this.getServiceKind()));
        }
        Response response = new Response();
        this.traceElapsedTime(true);
        try {
            ObjectNode jsonRequest;
            ObjectNode objectNode = jsonRequest = request.body == null ? new ObjectNode() : JsonParser.parse(request.body);
            if (this.trace()) {
                this.tracer().put("  invoking function " + org.eclipse.edt.javart.json.JsonUtilities.getValueNode(jsonRequest, JSON_RPC_METHOD_ID).toJava());
            }
            String result = this.wrapperProxyReturn(this.invokeEglService(jsonRequest));
            this.traceElapsedTime(false);
            if (this.trace()) {
                this.tracer().put("return data from dedicated service:" + result == null ? "null" : result);
            }
            response.body = result;
            boolean failed = this.resultContainsError(result);
            response.status = failed ? 500 : 200;
            response.statusMessage = failed ? "FAILED" : "OK";
        }
        catch (ServiceInvocationException sie) {
            response.body = JsonUtilities.createJsonAnyException(sie);
            response.status = 500;
            response.statusMessage = "FAILED";
        }
        catch (Throwable t) {
            response.body = JsonUtilities.createJsonAnyException(ServiceUtilities.buildServiceInvocationException("EGL0023E", new String[]{request.body == null ? "null" : request.body, this.getServiceClassName()}, t, this.getServiceKind()));
            response.status = 500;
            response.statusMessage = "FAILED";
        }
        return response;
    }

    public String invokeEglService(ObjectNode jsonRequest) throws ServiceInvocationException {
        String returnVal = null;
        String methodName = org.eclipse.edt.javart.json.JsonUtilities.getValueNode(jsonRequest, JSON_RPC_METHOD_ID).toJava();
        try {
            Method method = this.getMethod(methodName);
            Object[] parameters = JsonUtilities.getParameters(method, (ArrayNode)org.eclipse.edt.javart.json.JsonUtilities.getValueNode(jsonRequest, JSON_RPC_PARAMETER_ID));
            ServiceBase service = this.getService();
            Runtime.getRunUnit().setActiveExecutable(service);
            Object ret = method.invoke((Object)service, parameters);
            returnVal = this.convertToJson(method, parameters, ret);
            Runtime.getRunUnit().endRunUnit(service);
        }
        catch (ServiceInvocationException sie) {
            throw sie;
        }
        catch (Throwable t) {
            throw ServiceUtilities.buildServiceInvocationException("EGL0024E", new String[]{this.getServiceClassName(), methodName}, t, this.getServiceKind());
        }
        return returnVal;
    }

    private String convertToJson(Method method, Object[] parameters, Object ret) {
        FunctionSignature signature = method.getAnnotation(FunctionSignature.class);
        ArrayList<Object> responseParameters = new ArrayList<Object>();
        int idx = 0;
        while (idx < method.getParameterTypes().length) {
            if (!FunctionParameterKind.IN.equals((Object)signature.parameters()[idx].kind())) {
                responseParameters.add(JsonUtilities.wrapCalendar(parameters[idx], signature.parameters()[idx].parameterType(), signature.parameters()[idx].asOptions()));
            }
            ++idx;
        }
        if (ret != null) {
            responseParameters.add(JsonUtilities.wrapCalendar(ret, signature.parameters()[signature.parameters().length - 1].parameterType(), signature.parameters()[signature.parameters().length - 1].asOptions()));
        }
        Object response = responseParameters.size() == 0 ? null : (responseParameters.size() == 1 ? responseParameters.get(0) : responseParameters);
        EDictionary responseObject = new EDictionary();
        responseObject.put(JSON_RPC_RESULT_ID, response);
        return JsonLib.convertToJSON(responseObject);
    }

    private String wrapperProxyReturn(Object returnVal) {
        return returnVal == null ? "{}" : returnVal.toString();
    }

    protected boolean resultContainsError(String result) {
        return result.indexOf("{\"error\" : {") != -1;
    }

    @Override
    public ServiceKind getServiceKind(Request innerRequest) {
        return this.getServiceKind();
    }
}

