/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.rest.rpc;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.edt.javart.services.servlet.rest.rpc.RestServiceProjectInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class RestRpcUtilities {
    private static final String EGL_FUNCTION_ATTR = "eglfunction";
    private static final String CONTEXT_ROOT_ELEM = "contextroot";
    private static final String CLASSPATH_ELEM = "classpath";
    private static final String URI_ELEM = "uri";
    private static final String CLASSNAME_ATTR = "classname";
    private static final String STATEFUL_SERVICE_ATTR = "stateful";
    private static final String HOST_PROGRAM_SERVICE_ATTR = "hostProgramService";
    private static final String SERVICE_MAPPING_ELEM = "servicemapping";
    private static final String HTTP_FUNCTION_ATTR = "httpmethod";
    private static final String IN_ENCODING_ATTR = "in-encoding";
    private static final String OUT_ENCODING_ATTR = "out-encoding";
    private static final String TRUE_VALUE = "true";
    private static final String SERVICE_SERVLET = "EGL REST Service servlet";
    private static final String URI_MAPPING_FILE_SUFFIX = "-uri.xml";
    private static String CUSTOM_EGLSOAP_RESPONSE_HEADER = "CUSTOMEGLSOAPRESPONSEHEADER";
    private static final int FORMAT_NONE = 0;
    private static final int FORMAT_XML = 1;
    private static final int FORMAT_JSON = 2;
    private static final int FORMAT_FORM = 3;

    private RestRpcUtilities() {
    }

    static RestServiceProjectInfo getRestServiceInfo(String resource) {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        RestServiceProjectInfo projectInfo = null;
        try {
            DocumentBuilder dom = domFactory.newDocumentBuilder();
            File file = new File(resource);
            InputStream is = file.exists() && file.isAbsolute() ? new FileInputStream(file) : RestRpcUtilities.class.getClassLoader().getResourceAsStream(resource);
            Document doc = dom.parse(is);
            projectInfo = RestRpcUtilities.processDoc(doc);
        }
        catch (Exception exception) {
            projectInfo = new RestServiceProjectInfo("RestServiceProjectInfo", new URL[0]);
        }
        return projectInfo;
    }

    private static RestServiceProjectInfo processDoc(Document doc) {
        Element serviceMappings = (Element)doc.getFirstChild();
        URL[] classpath = RestRpcUtilities.getClasspath(serviceMappings);
        String contextRoot = RestRpcUtilities.getContextRoot(serviceMappings);
        RestServiceProjectInfo projectInfo = new RestServiceProjectInfo(contextRoot, classpath);
        NodeList serviceMapping = serviceMappings.getElementsByTagName(SERVICE_MAPPING_ELEM);
        int nodesCnt2 = serviceMapping == null ? 0 : serviceMapping.getLength();
        int idx2 = 0;
        while (idx2 < nodesCnt2) {
            RestRpcUtilities.processServiceMapping((Element)serviceMapping.item(idx2), projectInfo);
            ++idx2;
        }
        return projectInfo;
    }

    private static String getContextRoot(Element serviceMappings) {
        String contextRoot = "";
        NodeList list = serviceMappings.getElementsByTagName(CONTEXT_ROOT_ELEM);
        if (list != null && list.getLength() > 0) {
            contextRoot = RestRpcUtilities.getNodeTextValue(list.item(0));
        }
        return contextRoot;
    }

    private static URL[] getClasspath(Element serviceMappings) {
        String classpath = "";
        NodeList list = serviceMappings.getElementsByTagName(CLASSPATH_ELEM);
        if (list != null && list.getLength() > 0) {
            classpath = RestRpcUtilities.getNodeTextValue(list.item(0));
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classpath != null) {
            StringTokenizer parser = new StringTokenizer(classpath, ";");
            int idx = 0;
            while (parser.hasMoreElements()) {
                File file = new File(parser.nextToken());
                if (file.exists()) {
                    try {
                        urls.add(new URI(file.getAbsolutePath()).toURL());
                    }
                    catch (Exception exception) {}
                }
                ++idx;
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void processServiceMapping(Element serviceMapping, RestServiceProjectInfo projectInfo) {
        boolean isHostProgramService;
        String className = serviceMapping.getAttribute(CLASSNAME_ATTR);
        String stateful = serviceMapping.getAttribute(STATEFUL_SERVICE_ATTR);
        boolean isStatefulService = stateful != null && stateful.equalsIgnoreCase(TRUE_VALUE);
        String hostProgramService = serviceMapping.getAttribute(HOST_PROGRAM_SERVICE_ATTR);
        boolean bl = isHostProgramService = hostProgramService != null && hostProgramService.equalsIgnoreCase(TRUE_VALUE);
        if (className != null && className.length() > 0) {
            NodeList urls = serviceMapping.getElementsByTagName(URI_ELEM);
            int urlNodesCnt = urls == null ? 0 : urls.getLength();
            int idx2 = 0;
            while (idx2 < urlNodesCnt) {
                String urlValue;
                Element url = (Element)urls.item(idx2);
                if (url != null && (urlValue = RestRpcUtilities.getNodeTextValue(url)) != null) {
                    urlValue = urlValue.trim();
                    String eglFunctionName = url.getAttribute(EGL_FUNCTION_ATTR);
                    String httpMethodName = url.getAttribute(HTTP_FUNCTION_ATTR);
                    String inEncoding = url.getAttribute(IN_ENCODING_ATTR);
                    String outEncoding = url.getAttribute(OUT_ENCODING_ATTR);
                    projectInfo.addURI(urlValue, httpMethodName, className, isStatefulService, isHostProgramService, eglFunctionName, inEncoding, outEncoding);
                }
                ++idx2;
            }
        }
    }

    private static String getNodeTextValue(Node node) {
        String value = "";
        NodeList nodes = node.getChildNodes();
        int idx = 0;
        while (idx < nodes.getLength()) {
            node = nodes.item(idx);
            if (node.getNodeType() == 3) {
                value = node.getNodeValue();
                break;
            }
            ++idx;
        }
        return value;
    }
}

