/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.java.JavaObjectException;
import eglx.lang.AnyException;
import eglx.lang.ENumber;
import eglx.lang.TypeCastException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EBigint;
import org.eclipse.edt.runtime.java.eglx.lang.EDecimal;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallfloat;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallint;
import org.eclipse.edt.runtime.java.eglx.lang.EString;

public class EFloat
extends AnyBoxedObject<Double>
implements ENumber {
    private static final long serialVersionUID = 10L;

    private EFloat(Double value) {
        super(value);
    }

    public static EFloat ezeBox(Double value) {
        return new EFloat(value);
    }

    public static Double ezeCast(Object value) throws AnyException {
        return (Double)EAny.ezeCast(value, "asFloat", EFloat.class, null, null);
    }

    public String toString() {
        return EString.asString((Double)this.object, new Integer[0]);
    }

    public static boolean ezeIsa(Object value) {
        return value instanceof EFloat || value instanceof Double;
    }

    public static Double asFloat(Short value) {
        if (value == null) {
            return null;
        }
        return (double)value;
    }

    public static Double asFloat(ESmallint value) {
        if (value == null) {
            return null;
        }
        return (double)((Short)value.ezeUnbox());
    }

    public static Double asFloat(Integer value) {
        if (value == null) {
            return null;
        }
        return (double)value;
    }

    public static Double asFloat(EInt value) {
        if (value == null) {
            return null;
        }
        return (double)((Integer)value.ezeUnbox());
    }

    public static Double asFloat(Long value) {
        if (value == null) {
            return null;
        }
        return (double)value;
    }

    public static Double asFloat(EBigint value) {
        if (value == null) {
            return null;
        }
        return (double)((Long)value.ezeUnbox());
    }

    public static Double asFloat(Float value) {
        if (value == null) {
            return null;
        }
        return value.floatValue();
    }

    public static Double asFloat(ESmallfloat value) {
        if (value == null) {
            return null;
        }
        return ((Float)value.ezeUnbox()).floatValue();
    }

    public static Double asFloat(Double value) {
        if (value == null) {
            return null;
        }
        return (double)value;
    }

    public static Double asFloat(EFloat value) {
        if (value == null) {
            return null;
        }
        return (double)((Double)value.ezeUnbox());
    }

    public static Double asFloat(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    public static Double asFloat(EDecimal value) {
        if (value == null) {
            return null;
        }
        return ((BigDecimal)value.ezeUnbox()).doubleValue();
    }

    public static Double asFloat(BigInteger value) {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    public static Double asFloat(Number value) {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    public static Double asFloat(ENumber value) {
        if (value == null) {
            return null;
        }
        return ((Number)value.ezeUnbox()).doubleValue();
    }

    public static Double asFloat(String value) throws AnyException {
        if (value == null) {
            return null;
        }
        try {
            return Double.valueOf(value);
        }
        catch (Exception exception) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "float";
            throw tcx.fillInMessage("EGL0007E", value, tcx.actualTypeName, tcx.castToName);
        }
    }

    public static Double asFloat(EString value) throws AnyException {
        if (value == null) {
            return null;
        }
        return EFloat.asFloat((String)value.ezeUnbox());
    }

    public static EFloat asNumber(Double value) throws AnyException {
        if (value == null) {
            return null;
        }
        return EFloat.ezeBox(value);
    }

    public static EFloat asNumber(EFloat value) throws AnyException {
        if (value == null) {
            return null;
        }
        return value;
    }

    public static double plus(double op1, double op2) throws AnyException {
        return op1 + op2;
    }

    public static double minus(double op1, double op2) throws AnyException {
        return op1 - op2;
    }

    public static double divide(double op1, double op2) throws AnyException {
        if (op2 == 0.0) {
            JavaObjectException jox = new JavaObjectException();
            jox.exceptionType = EFloat.class.getCanonicalName();
            throw jox;
        }
        return op1 / op2;
    }

    public static double multiply(double op1, double op2) throws AnyException {
        return op1 * op2;
    }

    public static double remainder(double op1, double op2) throws AnyException {
        return op1 % op2;
    }

    public static double power(double op1, double op2) throws AnyException {
        return StrictMath.pow(op1, op2);
    }

    public static int compareTo(Double op1, Double op2) throws AnyException {
        if (op1 == null && op2 == null) {
            return 0;
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(Double op1, Double op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.compareTo(op2) == 0;
    }

    public static boolean notEquals(Double op1, Double op2) {
        return !EFloat.equals(op1, op2);
    }
}

