/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.Properties;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertyKeyHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        int delta;
        String realKey;
        ITypedRegion partition;
        ITextEditor textEditor;
        block14: {
            IDocument document;
            block13: {
                int offset;
                block12: {
                    textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
                    if (region == null || textEditor == null) {
                        return null;
                    }
                    IEditorSite site = textEditor.getEditorSite();
                    if (site == null) {
                        return null;
                    }
                    offset = region.getOffset();
                    if (!this.checkEnabled(textEditor, offset)) {
                        return null;
                    }
                    partition = null;
                    IStorageEditorInput storageEditorInput = (IStorageEditorInput)textEditor.getEditorInput();
                    document = textEditor.getDocumentProvider().getDocument((Object)storageEditorInput);
                    if (document instanceof IDocumentExtension3) {
                        partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", offset, false);
                    }
                    if (partition != null && "__dftl_partition_content_type".equals(partition.getType())) break block12;
                    return null;
                }
                if (offset + region.getLength() <= partition.getOffset() + partition.getLength()) break block13;
                return null;
            }
            String key = document.get(partition.getOffset(), partition.getLength());
            realKey = key.trim();
            delta = key.indexOf(realKey);
            String unicodeKey = this.getUnicodeString(realKey);
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(document.get().getBytes()));
            if (properties.getProperty(unicodeKey) != null) break block14;
            return null;
        }
        try {
            return new PropertyKeyHyperlink[]{new PropertyKeyHyperlink((IRegion)new Region(partition.getOffset() + delta, realKey.length()), realKey, textEditor)};
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (BadPartitioningException badPartitioningException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            this.showErrorInStatusLine(ex.getLocalizedMessage(), textEditor);
            return null;
        }
    }

    private String getUnicodeString(String key) {
        StringCharacterIterator iter = new StringCharacterIterator(key);
        StringBuffer result = new StringBuffer();
        while (iter.getIndex() < iter.getEndIndex()) {
            char c = iter.current();
            if (c == '\\') {
                iter.next();
                c = iter.current();
                if (c == 'u') {
                    StringBuffer unicode = new StringBuffer();
                    unicode.append(iter.next());
                    unicode.append(iter.next());
                    unicode.append(iter.next());
                    unicode.append(iter.next());
                    c = (char)Integer.parseInt(unicode.toString(), 16);
                }
            }
            result.append(c);
            iter.next();
        }
        return result.toString();
    }

    private boolean checkEnabled(ITextEditor textEditor, int offset) {
        if (offset < 0) {
            return false;
        }
        return textEditor.getEditorInput() instanceof IFileEditorInput;
    }

    private void showErrorInStatusLine(final String message, ITextEditor textEditor) {
        Display display = textEditor.getEditorSite().getShell().getDisplay();
        display.beep();
        final IEditorStatusLine statusLine = (IEditorStatusLine)textEditor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    statusLine.setMessage(true, message, null);
                }
            });
        }
    }
}

