/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.listeners;

import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.swt.widgets.Display;

public class SWTPropertyChangeListenerWrapper
implements PropertyChangeListener {
    private final PropertyChangeListener listener;

    public SWTPropertyChangeListenerWrapper(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void propertyChanged(PropertyChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.propertyChanged_(event);
        } else {
            this.executeOnUIThread(this.buildPropertyChangedRunnable(event));
        }
    }

    private Runnable buildPropertyChangedRunnable(final PropertyChangeEvent event) {
        return new Runnable(){

            public void run() {
                SWTPropertyChangeListenerWrapper.this.propertyChanged_(event);
            }

            public String toString() {
                return "property changed runnable";
            }
        };
    }

    private boolean isExecutingOnUIThread() {
        return Display.getCurrent() != null;
    }

    private void executeOnUIThread(Runnable r) {
        Display.getDefault().asyncExec(r);
    }

    void propertyChanged_(PropertyChangeEvent event) {
        this.listener.propertyChanged(event);
    }

    public String toString() {
        return "SWT(" + this.listener.toString() + ')';
    }
}

