/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterables;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.CloneIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CloneIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotCloneIterable<E>
extends CloneIterable<E> {
    private final Object[] array;

    public SnapshotCloneIterable(Iterator<? extends E> iterator) {
        this.array = ArrayTools.array(iterator);
    }

    public SnapshotCloneIterable(Iterator<? extends E> iterator, CloneIterator.Remover<E> remover) {
        super(remover);
        this.array = ArrayTools.array(iterator);
    }

    public SnapshotCloneIterable(Collection<? extends E> collection) {
        this.array = collection.toArray();
    }

    public SnapshotCloneIterable(Collection<? extends E> collection, CloneIterator.Remover<E> remover) {
        super(remover);
        this.array = collection.toArray();
    }

    @Override
    public Iterator<E> iterator() {
        return new LocalCloneIterator(this.remover, this.array);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, Arrays.toString(this.array));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LocalCloneIterator<E>
    extends CloneIterator<E> {
        protected LocalCloneIterator(CloneIterator.Remover<E> remover, Object[] array) {
            super(remover, array);
        }
    }
}

