/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.AttributeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmTypeMappingTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.GenericTypeMappingValidator;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmTypeMapping<X extends XmlTypeMapping>
extends AbstractOrmXmlContextNode
implements OrmTypeMapping {
    protected final X xmlTypeMapping;
    protected String class_;
    protected Boolean specifiedMetadataComplete;
    protected boolean overrideMetadataComplete;

    protected AbstractOrmTypeMapping(OrmPersistentType parent, X xmlTypeMapping) {
        super(parent);
        this.xmlTypeMapping = xmlTypeMapping;
        this.class_ = xmlTypeMapping.getClassName();
        this.specifiedMetadataComplete = xmlTypeMapping.getMetadataComplete();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setClass_(this.xmlTypeMapping.getClassName());
        this.setSpecifiedMetadataComplete_(this.xmlTypeMapping.getMetadataComplete());
    }

    @Override
    public void update() {
        super.update();
        this.setOverrideMetadataComplete(this.buildOverrideMetadataComplete());
    }

    @Override
    public String getClass_() {
        return this.class_;
    }

    @Override
    public void setClass(String class_) {
        this.setClass_(class_);
        this.xmlTypeMapping.setClassName(class_);
    }

    protected void setClass_(String class_) {
        String old = this.class_;
        this.class_ = class_;
        if (this.firePropertyChanged("class", old, class_)) {
            this.getPersistentType().mappingClassChanged(old, class_);
        }
    }

    @Override
    public boolean isMetadataComplete() {
        if (this.overrideMetadataComplete) {
            return true;
        }
        return this.specifiedMetadataComplete != null ? this.specifiedMetadataComplete : false;
    }

    @Override
    public Boolean getSpecifiedMetadataComplete() {
        return this.specifiedMetadataComplete;
    }

    @Override
    public void setSpecifiedMetadataComplete(Boolean metadataComplete) {
        this.setSpecifiedMetadataComplete_(metadataComplete);
        this.xmlTypeMapping.setMetadataComplete(metadataComplete);
    }

    protected void setSpecifiedMetadataComplete_(Boolean metadataComplete) {
        Boolean old = this.specifiedMetadataComplete;
        this.specifiedMetadataComplete = metadataComplete;
        this.firePropertyChanged("specifiedMetadataComplete", old, metadataComplete);
    }

    @Override
    public boolean isOverrideMetadataComplete() {
        return this.overrideMetadataComplete;
    }

    protected void setOverrideMetadataComplete(boolean metadataComplete) {
        boolean old = this.overrideMetadataComplete;
        this.overrideMetadataComplete = metadataComplete;
        this.firePropertyChanged("overrideMetadataComplete", old, metadataComplete);
    }

    protected boolean buildOverrideMetadataComplete() {
        return this.getPersistenceUnit().isXmlMappingMetadataComplete();
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        JavaPersistentType javaType = this.getJavaPersistentType();
        if (javaType == null) {
            return null;
        }
        return javaType.getMappingKey() == this.getKey() ? javaType.getMapping() : null;
    }

    @Override
    public JavaTypeMapping getJavaTypeMappingForDefaults() {
        return this.isMetadataComplete() ? null : this.getJavaTypeMapping();
    }

    @Override
    public OrmPersistentType getParent() {
        return (OrmPersistentType)super.getParent();
    }

    @Override
    public OrmPersistentType getPersistentType() {
        return this.getParent();
    }

    @Override
    public String getName() {
        return this.getPersistentType().getName();
    }

    protected JavaPersistentType getJavaPersistentType() {
        return this.getPersistentType().getJavaPersistentType();
    }

    protected JavaResourcePersistentType getJavaResourcePersistentType() {
        JavaPersistentType javaType = this.getJavaPersistentType();
        return javaType == null ? null : javaType.getResourcePersistentType();
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public void initializeFrom(OrmTypeMapping oldMapping) {
        this.setClass(oldMapping.getClass_());
        this.setSpecifiedMetadataComplete(oldMapping.getSpecifiedMetadataComplete());
        this.setOverrideMetadataComplete(oldMapping.isOverrideMetadataComplete());
    }

    @Override
    public String getPrimaryTableName() {
        return null;
    }

    @Override
    public Table getPrimaryDbTable() {
        return null;
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return null;
    }

    @Override
    public boolean attributeMappingKeyAllowed(String attributeMappingKey) {
        return true;
    }

    public Iterator<AttributeMapping> attributeMappings() {
        return new TransformationIterator<OrmReadOnlyPersistentAttribute, AttributeMapping>(this.getPersistentType().attributes()){

            protected AttributeMapping transform(OrmReadOnlyPersistentAttribute attribute) {
                return attribute.getMapping();
            }
        };
    }

    @Override
    public Iterator<AttributeMapping> allAttributeMappings() {
        return new CompositeIterator(this.allAttributeMappingsLists());
    }

    protected Iterator<Iterator<AttributeMapping>> allAttributeMappingsLists() {
        return new TransformationIterator(this.inheritanceHierarchy(), TypeMappingTools.ATTRIBUTE_MAPPINGS_TRANSFORMER);
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        return new CompositeIterator(this.overridableAttributeNamesLists());
    }

    protected Iterator<Iterator<String>> overridableAttributeNamesLists() {
        return new TransformationIterator(this.attributeMappings(), AttributeMappingTools.ALL_OVERRIDABLE_ATTRIBUTE_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return new CompositeIterator(this.allOverridableAttributeNamesLists());
    }

    protected Iterator<Iterator<String>> allOverridableAttributeNamesLists() {
        return new TransformationIterator(this.inheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ATTRIBUTE_NAMES_TRANSFORMER);
    }

    public Iterable<AttributeMapping> getAttributeMappings(final String mappingKey) {
        return new FilteringIterable<AttributeMapping>((Iterable)CollectionTools.collection(this.attributeMappings())){

            protected boolean accept(AttributeMapping o) {
                return Tools.valuesAreEqual((Object)o.getKey(), (Object)mappingKey);
            }
        };
    }

    public Iterable<AttributeMapping> getAllAttributeMappings(final String mappingKey) {
        return new FilteringIterable<AttributeMapping>((Iterable)CollectionTools.collection(this.allAttributeMappings())){

            protected boolean accept(AttributeMapping o) {
                return Tools.valuesAreEqual((Object)o.getKey(), (Object)mappingKey);
            }
        };
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        JavaPersistentType javaPersistentType;
        for (AttributeMapping attributeMapping : CollectionTools.iterable(this.attributeMappings())) {
            Column column = attributeMapping.resolveOverriddenColumn(attributeName);
            if (column == null) continue;
            return column;
        }
        if (!this.isMetadataComplete() && (javaPersistentType = this.getJavaPersistentType()) != null) {
            return javaPersistentType.getMapping().resolveOverriddenColumn(attributeName);
        }
        return null;
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        return new CompositeIterator(this.overridableAssociationNamesLists());
    }

    protected Iterator<Iterator<String>> overridableAssociationNamesLists() {
        return new TransformationIterator(this.attributeMappings(), AttributeMappingTools.ALL_OVERRIDABLE_ASSOCIATION_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterator<String> allOverridableAssociationNames() {
        return new CompositeIterator(this.allOverridableAssociationNamesLists());
    }

    protected Iterator<Iterator<String>> allOverridableAssociationNamesLists() {
        return new TransformationIterator(this.inheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ASSOCIATION_NAMES_TRANSFORMER);
    }

    @Override
    public Relationship resolveOverriddenRelationship(String attributeName) {
        JavaPersistentType javaPersistentType;
        for (AttributeMapping attributeMapping : CollectionTools.iterable(this.attributeMappings())) {
            Relationship relationship = attributeMapping.resolveOverriddenRelationship(attributeName);
            if (relationship == null) continue;
            return relationship;
        }
        if (!this.isMetadataComplete() && (javaPersistentType = this.getJavaPersistentType()) != null) {
            return javaPersistentType.getMapping().resolveOverriddenRelationship(attributeName);
        }
        return null;
    }

    @Override
    public TypeMapping getSuperTypeMapping() {
        PersistentType superPersistentType = this.getPersistentType().getSuperPersistentType();
        return superPersistentType == null ? null : superPersistentType.getMapping();
    }

    @Override
    public Iterator<TypeMapping> inheritanceHierarchy() {
        return this.convertToMappings(this.getPersistentType().inheritanceHierarchy());
    }

    protected Iterable<TypeMapping> getInheritanceHierarchy() {
        return CollectionTools.iterable(this.inheritanceHierarchy());
    }

    protected Iterator<TypeMapping> ancestors() {
        return this.convertToMappings(this.getPersistentType().ancestors());
    }

    protected Iterable<TypeMapping> getAncestors() {
        return CollectionTools.iterable(this.ancestors());
    }

    protected Iterator<TypeMapping> convertToMappings(Iterator<PersistentType> types) {
        return new TransformationIterator<PersistentType, TypeMapping>(types){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    public X getXmlTypeMapping() {
        return this.xmlTypeMapping;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getPersistentType().getName());
    }

    public JpaStructureNode getStructureNode(int offset) {
        return this.xmlTypeMapping.containsOffset(offset) ? this.getPersistentType() : null;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlTypeMapping.getSelectionTextRange();
    }

    @Override
    public TextRange getClassTextRange() {
        return this.getValidationTextRange(this.xmlTypeMapping.getClassTextRange());
    }

    @Override
    public TextRange getAttributesTextRange() {
        return this.getValidationTextRange(this.xmlTypeMapping.getAttributesTextRange());
    }

    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.xmlTypeMapping.getNameTextRange());
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlTypeMapping.containsOffset(textOffset);
    }

    @Override
    public DeleteEdit createDeleteEdit() {
        return this.xmlTypeMapping.createDeleteEdit();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.getPersistentType().isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenameTypeEdit(originalType, newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenameTypeEdit(IType originalType, String newName) {
        return this.xmlTypeMapping.createRenameTypeEdit(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.getPersistentType().isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.getPersistentType().isIn(originalPackage) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenamePackageEdit(String newName) {
        return this.xmlTypeMapping.createRenamePackageEdit(newName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateClass(messages, reporter);
    }

    protected void validateClass(List<IMessage> messages, IReporter reporter) {
        if (!StringTools.stringIsEmpty((String)this.class_)) {
            HashBag ormMappedClassNames = new HashBag();
            CollectionTools.addAll((Collection)ormMappedClassNames, this.getPersistenceUnit().getOrmMappedClassNames());
            if (ormMappedClassNames.count((Object)this.class_) > 1) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "PERSISTENT_TYPE_DUPLICATE_CLASS", new String[]{this.class_}, this, this.getClassTextRange()));
            }
            return;
        }
        messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNSPECIFIED_CLASS", this, this.getClassTextRange()));
        this.buildTypeMappingValidator().validate(messages, reporter);
    }

    protected JptValidator buildTypeMappingValidator() {
        return new GenericTypeMappingValidator(this, this.getJavaResourcePersistentType(), this.buildTextRangeResolver());
    }

    protected TypeMappingTextRangeResolver buildTextRangeResolver() {
        return new OrmTypeMappingTextRangeResolver(this);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getPersistenceUnit().validatesAgainstDatabase();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlTypeMapping.getValidationTextRange();
        return textRange != null ? textRange : this.getPersistentType().getValidationTextRange();
    }
}

