/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConversionValueAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkObjectTypeConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkObjectTypeConverter
extends JavaEclipseLinkConverter<EclipseLinkObjectTypeConverterAnnotation>
implements EclipseLinkObjectTypeConverter {
    private String dataType;
    private String fullyQualifiedDataType;
    public static final String FULLY_QUALIFIED_DATA_TYPE_PROPERTY = "fullyQualifiedDataType";
    private String objectType;
    private String fullyQualifiedObjectType;
    public static final String FULLY_QUALIFIED_OBJECT_TYPE_PROPERTY = "fullyQualifiedObjectType";
    private final Vector<JavaEclipseLinkConversionValue> conversionValues = new Vector();
    private final ConversionValueContainerAdapter conversionValueContainerAdapter = new ConversionValueContainerAdapter();
    private String defaultObjectValue;

    public JavaEclipseLinkObjectTypeConverter(JavaJpaContextNode parent, EclipseLinkObjectTypeConverterAnnotation converterAnnotation) {
        super(parent, converterAnnotation);
        this.dataType = converterAnnotation.getDataType();
        this.objectType = converterAnnotation.getObjectType();
        this.initializeConversionValues();
        this.defaultObjectValue = converterAnnotation.getDefaultObjectValue();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDataType_(((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).getDataType());
        this.setObjectType_(((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).getObjectType());
        this.syncConversionValues();
        this.setDefaultObjectValue_(((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).getDefaultObjectValue());
    }

    @Override
    public void update() {
        super.update();
        this.setFullyQualifiedDataType(((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).getFullyQualifiedDataType());
        this.setFullyQualifiedObjectType(((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).getFullyQualifiedObjectType());
        this.updateNodes((Iterable)this.getConversionValues());
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String dataType) {
        ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).setDataType(dataType);
        this.setDataType_(dataType);
    }

    protected void setDataType_(String dataType) {
        String old = this.dataType;
        this.dataType = dataType;
        this.firePropertyChanged("dataType", old, dataType);
    }

    public String getFullyQualifiedDataType() {
        return this.fullyQualifiedDataType;
    }

    protected void setFullyQualifiedDataType(String dataType) {
        String old = this.fullyQualifiedDataType;
        this.fullyQualifiedDataType = dataType;
        this.firePropertyChanged(FULLY_QUALIFIED_DATA_TYPE_PROPERTY, old, dataType);
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String objectType) {
        ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).setObjectType(objectType);
        this.setObjectType_(objectType);
    }

    protected void setObjectType_(String objectType) {
        String old = this.objectType;
        this.objectType = objectType;
        this.firePropertyChanged("objectType", old, objectType);
    }

    public String getFullyQualifiedObjectType() {
        return this.fullyQualifiedObjectType;
    }

    protected void setFullyQualifiedObjectType(String objectType) {
        String old = this.fullyQualifiedObjectType;
        this.fullyQualifiedObjectType = objectType;
        this.firePropertyChanged(FULLY_QUALIFIED_OBJECT_TYPE_PROPERTY, old, objectType);
    }

    public ListIterator<JavaEclipseLinkConversionValue> conversionValues() {
        return this.getConversionValues().iterator();
    }

    public ListIterable<JavaEclipseLinkConversionValue> getConversionValues() {
        return new LiveCloneListIterable(this.conversionValues);
    }

    @Override
    public int conversionValuesSize() {
        return this.conversionValues.size();
    }

    @Override
    public JavaEclipseLinkConversionValue addConversionValue() {
        return this.addConversionValue(this.conversionValues.size());
    }

    @Override
    public JavaEclipseLinkConversionValue addConversionValue(int index) {
        EclipseLinkConversionValueAnnotation annotation = ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).addConversionValue(index);
        return this.addConversionValue_(index, annotation);
    }

    @Override
    public void removeConversionValue(EclipseLinkConversionValue conversionValue) {
        this.removeConversionValue(this.conversionValues.indexOf(conversionValue));
    }

    @Override
    public void removeConversionValue(int index) {
        ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).removeConversionValue(index);
        this.removeConversionValue_(index);
    }

    protected void removeConversionValue_(int index) {
        this.removeItemFromList(index, this.conversionValues, "conversionValues");
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).moveConversionValue(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.conversionValues, "conversionValues");
    }

    protected void initializeConversionValues() {
        ListIterator<EclipseLinkConversionValueAnnotation> stream = ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).conversionValues();
        while (stream.hasNext()) {
            this.conversionValues.add(this.buildConversionValue((EclipseLinkConversionValueAnnotation)stream.next()));
        }
    }

    protected JavaEclipseLinkConversionValue buildConversionValue(EclipseLinkConversionValueAnnotation conversionValueAnnotation) {
        return new JavaEclipseLinkConversionValue(this, conversionValueAnnotation);
    }

    protected void syncConversionValues() {
        ContextContainerTools.synchronizeWithResourceModel((ContextContainerTools.Adapter)this.conversionValueContainerAdapter);
    }

    protected Iterable<EclipseLinkConversionValueAnnotation> getConversionValueAnnotations() {
        return CollectionTools.iterable(((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).conversionValues());
    }

    protected void moveConversionValue_(int index, JavaEclipseLinkConversionValue conversionValue) {
        this.moveItemInList(index, conversionValue, this.conversionValues, "conversionValues");
    }

    protected JavaEclipseLinkConversionValue addConversionValue_(int index, EclipseLinkConversionValueAnnotation conversionValueAnnotation) {
        JavaEclipseLinkConversionValue conversionValue = this.buildConversionValue(conversionValueAnnotation);
        this.addItemToList(index, conversionValue, this.conversionValues, "conversionValues");
        return conversionValue;
    }

    protected void removeConversionValue_(JavaEclipseLinkConversionValue conversionValue) {
        this.removeConversionValue_(this.conversionValues.indexOf(conversionValue));
    }

    @Override
    public Iterable<String> getDataValues() {
        return new TransformationIterable<JavaEclipseLinkConversionValue, String>(this.getConversionValues()){

            protected String transform(JavaEclipseLinkConversionValue conversionValue) {
                return conversionValue.getDataValue();
            }
        };
    }

    @Override
    public int getDataValuesSize() {
        return this.conversionValuesSize();
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String value) {
        ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).setDefaultObjectValue(value);
        this.setDefaultObjectValue_(value);
    }

    protected void setDefaultObjectValue_(String value) {
        String old = this.defaultObjectValue;
        this.defaultObjectValue = value;
        this.firePropertyChanged("defaultObjectValue", old, value);
    }

    public Class<EclipseLinkObjectTypeConverter> getType() {
        return EclipseLinkObjectTypeConverter.class;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        for (JavaEclipseLinkConversionValue conversionValue : this.getConversionValues()) {
            conversionValue.validate(messages, reporter, astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends JavaEclipseLinkConverter.AbstractAdapter {
        private static final Adapter INSTANCE = new Adapter();

        public static Adapter instance() {
            return INSTANCE;
        }

        private Adapter() {
        }

        public Class<EclipseLinkObjectTypeConverter> getConverterType() {
            return EclipseLinkObjectTypeConverter.class;
        }

        @Override
        protected String getAnnotationName() {
            return "org.eclipse.persistence.annotations.ObjectTypeConverter";
        }

        @Override
        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildConverter(EclipseLinkNamedConverterAnnotation converterAnnotation, JavaJpaContextNode parent) {
            return new JavaEclipseLinkObjectTypeConverter(parent, (EclipseLinkObjectTypeConverterAnnotation)converterAnnotation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConversionValueContainerAdapter
    implements ContextContainerTools.Adapter<JavaEclipseLinkConversionValue, EclipseLinkConversionValueAnnotation> {
        protected ConversionValueContainerAdapter() {
        }

        public Iterable<JavaEclipseLinkConversionValue> getContextElements() {
            return JavaEclipseLinkObjectTypeConverter.this.getConversionValues();
        }

        public Iterable<EclipseLinkConversionValueAnnotation> getResourceElements() {
            return JavaEclipseLinkObjectTypeConverter.this.getConversionValueAnnotations();
        }

        public EclipseLinkConversionValueAnnotation getResourceElement(JavaEclipseLinkConversionValue contextElement) {
            return contextElement.getConversionValueAnnotation();
        }

        public void moveContextElement(int index, JavaEclipseLinkConversionValue element) {
            JavaEclipseLinkObjectTypeConverter.this.moveConversionValue_(index, element);
        }

        public void addContextElement(int index, EclipseLinkConversionValueAnnotation resourceElement) {
            JavaEclipseLinkObjectTypeConverter.this.addConversionValue_(index, resourceElement);
        }

        public void removeContextElement(JavaEclipseLinkConversionValue element) {
            JavaEclipseLinkObjectTypeConverter.this.removeConversionValue_(element);
        }
    }
}

