/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.taglib;

import java.io.File;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITagDirRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexDelta;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.ProjectDescription;
import org.eclipse.jst.jsp.core.taglib.TaglibIndexDelta;
import org.eclipse.wst.sse.core.internal.util.AbstractMemoryListener;
import org.osgi.service.event.Event;

public final class TaglibIndex {
    static final boolean _debugChangeListener = false;
    static boolean _debugEvents = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/events"));
    static boolean _debugIndexCreation = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indexcreation"));
    static final boolean _debugResolution = "true".equals(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/resolve"));
    static TaglibIndex _instance = new TaglibIndex();
    private boolean initialized;
    private static final CRC32 checksumCalculator = new CRC32();
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    static boolean ENABLED = false;
    static final ILock LOCK = Job.getJobManager().newLock();
    private ClasspathChangeListener fClasspathChangeListener = null;
    private TaglibIndexDelta fCurrentTopLevelDelta = null;
    Map fProjectDescriptions = null;
    private ResourceChangeListener fResourceChangeListener;
    private ITaglibIndexListener[] fTaglibIndexListeners = null;
    private MemoryListener fMemoryListener;
    private static final String OSGI_FRAMEWORK_ID = "org.eclipse.osgi";
    static /* synthetic */ Class class$0;

    public static void addTaglibIndexListener(ITaglibIndexListener listener) {
        if (TaglibIndex.getInstance().isInitialized()) {
            TaglibIndex.getInstance().internalAddTaglibIndexListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireTaglibDelta(ITaglibIndexDelta delta) {
        ITaglibIndexListener[] listeners;
        if (_debugEvents) {
            Logger.log(1, "TaglibIndex fired delta:" + delta + " [" + delta.getAffectedChildren().length + "]\n" + ((TaglibIndexDelta)delta).trigger);
        }
        ITaglibIndexDelta[] deltas = delta.getAffectedChildren();
        int i22 = 0;
        while (i22 < deltas.length) {
            ITaglibRecord taglibRecord = deltas[i22].getTaglibRecord();
            if (taglibRecord != null) {
                Object uniqueIdentifier = TLDCMDocumentManager.getUniqueIdentifier(taglibRecord);
                if (uniqueIdentifier != null) {
                    TLDCMDocumentManager.getSharedDocumentCache().remove(uniqueIdentifier);
                } else {
                    Logger.log(4, "identifier for " + taglibRecord + " was null");
                }
            }
            ++i22;
        }
        Hashtable i22 = TLDCMDocumentManager.getSharedDocumentCache();
        synchronized (i22) {
            Iterator values = TLDCMDocumentManager.getSharedDocumentCache().values().iterator();
            while (values.hasNext()) {
                Object o = values.next();
                if (!(o instanceof Reference)) continue;
                values.remove();
            }
        }
        if (_instance.isInitialized() && (listeners = TaglibIndex._instance.fTaglibIndexListeners) != null) {
            int j = 0;
            while (j < listeners.length) {
                try {
                    listeners[j].indexChanged(delta);
                }
                catch (Exception e) {
                    Logger.log(2, e.getMessage());
                }
                ++j;
            }
        }
    }

    public static ITaglibRecord[] getAvailableTaglibRecords(IPath fullPath) {
        if (!_instance.isInitialized()) {
            return new ITaglibRecord[0];
        }
        ITaglibRecord[] records = null;
        records = TaglibIndex.getInstance().isInitialized() ? TaglibIndex.getInstance().internalGetAvailableTaglibRecords(fullPath) : new ITaglibRecord[]{};
        TaglibIndex.getInstance().fireCurrentDelta("enumerate: " + fullPath);
        return records;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IPath getContextRoot(IPath path) {
        block3: {
            IPath iPath;
            try {
                LOCK.acquire();
                if (!TaglibIndex.getInstance().isInitialized()) break block3;
                iPath = TaglibIndex.getInstance().internalGetContextRoot(path);
                Object var1_2 = null;
            }
            catch (Throwable throwable) {
                Object var1_3 = null;
                LOCK.release();
                throw throwable;
            }
            LOCK.release();
            return iPath;
        }
        Object var1_4 = null;
        LOCK.release();
        return null;
    }

    public static TaglibIndex getInstance() {
        return _instance;
    }

    public static void removeTaglibIndexListener(ITaglibIndexListener listener) {
        if (!TaglibIndex.getInstance().isInitialized()) {
            return;
        }
        if (TaglibIndex.getInstance().isInitialized()) {
            TaglibIndex.getInstance().internalRemoveTaglibIndexListener(listener);
        }
    }

    public static ITaglibRecord resolve(String basePath, String reference, boolean crossProjects) {
        ITaglibRecord result = null;
        if (TaglibIndex.getInstance().isInitialized()) {
            result = TaglibIndex.getInstance().internalResolve(basePath, reference, crossProjects);
        }
        TaglibIndex.getInstance().fireCurrentDelta("resolve: " + reference);
        if (_debugResolution) {
            if (result == null) {
                Logger.log(1, "TaglibIndex could not resolve \"" + reference + "\" from " + basePath);
            } else {
                switch (result.getRecordType()) {
                    case 1: {
                        ITLDRecord record = (ITLDRecord)result;
                        Logger.log(1, "TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getPath());
                        break;
                    }
                    case 2: {
                        IJarRecord record = (IJarRecord)result;
                        Logger.log(1, "TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getLocation());
                        break;
                    }
                    case 8: {
                        ITagDirRecord record = (ITagDirRecord)result;
                        Logger.log(1, "TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getPath());
                        break;
                    }
                    case 4: {
                        IURLRecord record = (IURLRecord)result;
                        Logger.log(1, "TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getURL());
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void shutdown() {
        try {
            LOCK.acquire();
            if (TaglibIndex.getInstance().isInitialized()) {
                TaglibIndex.getInstance().stop();
            }
        }
        catch (Throwable throwable) {
            Object var0_1 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var0_2 = null;
        }
        LOCK.release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void startup() {
        boolean shuttingDown = !Platform.isRunning() || Platform.getBundle((String)OSGI_FRAMEWORK_ID).getState() == 16;
        if (shuttingDown) return;
        try {
            LOCK.acquire();
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.jst.jsp.core.taglib.TaglibIndex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            ENABLED = !"false".equalsIgnoreCase(System.getProperty(clazz.getName()));
            TaglibIndex.getInstance().initializeInstance();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        LOCK.release();
    }

    private TaglibIndex() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeInstance() {
        if (this.isInitialized()) {
            return;
        }
        try {
            LOCK.acquire();
            if (!this.isInitialized()) {
                this.getWorkingLocation();
                if (DIRTY.equalsIgnoreCase(this.getState())) {
                    Logger.log(4, "A workspace crash was detected. The previous session did not exit normally. Not using saved taglib indexes.");
                    this.removeIndexes(false);
                }
                this.fProjectDescriptions = new Hashtable();
                this.fResourceChangeListener = new ResourceChangeListener();
                this.fClasspathChangeListener = new ClasspathChangeListener();
                this.fMemoryListener = new MemoryListener();
                if (ENABLED) {
                    ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener, 1);
                    JavaCore.addElementChangedListener((IElementChangedListener)this.fClasspathChangeListener);
                    this.fMemoryListener.connect();
                }
                this.setIntialized(true);
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        LOCK.release();
    }

    synchronized void addDelta(ITaglibIndexDelta delta) {
        this.ensureDelta(delta.getProject()).addChildDelta(delta);
    }

    String computeIndexLocation(IPath containerPath) {
        String fileName = this.computeIndexName(containerPath);
        if (_debugIndexCreation) {
            Logger.log(1, "-> index name for " + containerPath + " is " + fileName);
        }
        String indexLocation = this.getTaglibIndexStateLocation().append(fileName).toOSString();
        return indexLocation;
    }

    String computeIndexName(IPath containerPath) {
        checksumCalculator.reset();
        checksumCalculator.update(containerPath.toOSString().getBytes());
        String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".dat";
        return fileName;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ProjectDescription createDescription(IProject project) {
        if (this.fProjectDescriptions == null) {
            return null;
        }
        ProjectDescription description = null;
        try {
            LOCK.acquire();
            description = (ProjectDescription)this.fProjectDescriptions.get(project);
            if (description == null) {
                if (this.fProjectDescriptions.isEmpty()) {
                    this.setState(DIRTY);
                }
                description = new ProjectDescription(project, this.computeIndexLocation(project.getFullPath()));
                this.fProjectDescriptions.put(project, description);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        LOCK.release();
        return description;
    }

    private TaglibIndexDelta ensureDelta(IProject project) {
        if (this.fCurrentTopLevelDelta == null) {
            this.fCurrentTopLevelDelta = new TaglibIndexDelta(project, null, 4);
        }
        return this.fCurrentTopLevelDelta;
    }

    void fireCurrentDelta(Object trigger) {
        if (this.fCurrentTopLevelDelta != null) {
            this.fCurrentTopLevelDelta.trigger = trigger;
            TaglibIndexDelta delta = this.fCurrentTopLevelDelta;
            this.fCurrentTopLevelDelta = null;
            TaglibIndex.fireTaglibDelta(delta);
        }
    }

    boolean frameworkIsShuttingDown() {
        boolean shuttingDown = !Platform.isRunning() || Platform.getBundle((String)OSGI_FRAMEWORK_ID).getState() == 16;
        return shuttingDown;
    }

    ProjectDescription getDescription(IProject project) {
        ProjectDescription description = null;
        if (this.isInitialized()) {
            description = (ProjectDescription)this.fProjectDescriptions.get(project);
        }
        return description;
    }

    private String getState() {
        Preferences preferences = JSPCorePlugin.getDefault().getPluginPreferences();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.taglib.TaglibIndex");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String state = preferences.getString(clazz.getName());
        return state;
    }

    private IPath getTaglibIndexStateLocation() {
        return JSPCorePlugin.getDefault().getStateLocation().append("taglibindex/");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalAddTaglibIndexListener(ITaglibIndexListener listener) {
        try {
            LOCK.acquire();
            if (this.fTaglibIndexListeners == null) {
                this.fTaglibIndexListeners = new ITaglibIndexListener[]{listener};
            } else {
                ArrayList<ITaglibIndexListener> listeners = new ArrayList<ITaglibIndexListener>(Arrays.asList(this.fTaglibIndexListeners));
                if (!listeners.contains(listener)) {
                    listeners.add(listener);
                }
                this.fTaglibIndexListeners = listeners.toArray(new ITaglibIndexListener[0]);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        LOCK.release();
    }

    private ITaglibRecord[] internalGetAvailableTaglibRecords(IPath path) {
        IProject project;
        ITaglibRecord[] records = new ITaglibRecord[]{};
        if (path.segmentCount() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))).isAccessible()) {
            ProjectDescription description = this.createDescription(project);
            List availableRecords = description.getAvailableTaglibRecords(path);
            records = availableRecords.toArray(records);
        }
        return records;
    }

    private IPath internalGetContextRoot(IPath path) {
        IFile baseResource = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
        if (baseResource != null && baseResource.getProject().isAccessible()) {
            IProject project = baseResource.getProject();
            ProjectDescription description = TaglibIndex.getInstance().createDescription(project);
            IPath rootPath = description.getLocalRoot(baseResource.getFullPath());
            return rootPath;
        }
        IPath root = path.makeAbsolute();
        while (root.segmentCount() > 0 && !root.isRoot()) {
            root = root.removeLastSegments(1);
        }
        return root;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalRemoveTaglibIndexListener(ITaglibIndexListener listener) {
        try {
            LOCK.acquire();
            if (this.fTaglibIndexListeners != null) {
                ArrayList<ITaglibIndexListener> listeners = new ArrayList<ITaglibIndexListener>(Arrays.asList(this.fTaglibIndexListeners));
                listeners.remove(listener);
                this.fTaglibIndexListeners = listeners.toArray(new ITaglibIndexListener[0]);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        LOCK.release();
    }

    private ITaglibRecord internalResolve(String basePath, String reference, boolean crossProjects) {
        IFile[] files;
        IProject project = null;
        ITaglibRecord resolved = null;
        Path baseIPath = new Path(basePath);
        IFile baseResource = FileBuffers.getWorkspaceFileAtLocation((IPath)baseIPath);
        if (baseResource == null) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (baseIPath.segmentCount() > 1) {
                baseResource = workspaceRoot.getFolder((IPath)baseIPath);
            }
            if (baseResource != null && !baseResource.exists() && baseIPath.segmentCount() > 1) {
                baseResource = workspaceRoot.getFile((IPath)baseIPath);
            }
            if (baseResource == null && baseIPath.segmentCount() == 1) {
                baseResource = workspaceRoot.getProject(baseIPath.segment(0));
            }
        }
        if (baseResource == null && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)baseIPath)).length > 0) {
            baseResource = files[0];
        }
        if (baseResource != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(baseIPath.segment(0))).isAccessible()) {
            ProjectDescription description = this.createDescription(project);
            resolved = description.resolve(basePath, reference);
        }
        return resolved;
    }

    boolean isIndexAvailable() {
        return _instance.isInitialized() && ENABLED;
    }

    void removeIndexFile(IProject project) {
        File indexFile = new File(this.computeIndexLocation(project.getFullPath()));
        if (indexFile.exists()) {
            indexFile.delete();
        }
    }

    private void removeIndexes(boolean staleOnly) {
        File folder = this.getWorkingLocation();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> indexNames = new ArrayList<String>(projects.length);
        if (staleOnly) {
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isAccessible()) {
                    indexNames.add(this.computeIndexName(projects[i].getFullPath()));
                }
                ++i;
            }
        }
        if (folder.isDirectory()) {
            File[] files = folder.listFiles();
            int i = 0;
            while (files != null && i < files.length) {
                if (!indexNames.contains(files[i].getName())) {
                    files[i].delete();
                }
                ++i;
            }
        }
    }

    private void setState(String state) {
        if (!state.equals(this.getState())) {
            Preferences preferences = JSPCorePlugin.getDefault().getPluginPreferences();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.taglib.TaglibIndex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            preferences.setValue(clazz.getName(), state);
            JSPCorePlugin.getDefault().savePluginPreferences();
        }
    }

    private void stop() {
        if (this.isInitialized()) {
            this.setIntialized(false);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener);
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fClasspathChangeListener);
            this.fMemoryListener.disconnect();
            this.removeIndexes(true);
            this.clearProjectDescriptions();
            this.setState(CLEAN);
            this.fProjectDescriptions = null;
            this.fResourceChangeListener = null;
            this.fClasspathChangeListener = null;
            this.fMemoryListener = null;
        }
    }

    private File getWorkingLocation() {
        File folder = new File(this.getTaglibIndexStateLocation().toOSString());
        if (!folder.isDirectory()) {
            try {
                folder.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        return folder;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void clearProjectDescriptions() {
        try {
            LOCK.acquire();
            Iterator i = this.fProjectDescriptions.values().iterator();
            while (true) {
                block4: {
                    if (i.hasNext()) break block4;
                    this.fProjectDescriptions.clear();
                    break;
                }
                ProjectDescription description = (ProjectDescription)i.next();
                description.saveReferences();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        LOCK.release();
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void setIntialized(boolean intialized) {
        this.initialized = intialized;
    }

    class ClasspathChangeListener
    implements IElementChangedListener {
        List projectsIndexed = new ArrayList(1);

        ClasspathChangeListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void elementChanged(ElementChangedEvent event) {
            if (!TaglibIndex.this.isIndexAvailable()) {
                return;
            }
            try {
                LOCK.acquire();
                if (_debugEvents) {
                    Logger.log(1, "TaglibIndex responding to:" + event);
                }
                this.projectsIndexed.clear();
                this.elementChanged(event.getDelta(), true);
                TaglibIndex.this.fireCurrentDelta(event);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                LOCK.release();
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            LOCK.release();
        }

        private void elementChanged(IJavaElementDelta delta, boolean forceUpdate) {
            IJavaProject affectedProject;
            if (TaglibIndex.this.frameworkIsShuttingDown()) {
                return;
            }
            IJavaElement element = delta.getElement();
            if (element.getElementType() == 1) {
                IJavaElementDelta[] changed = delta.getAffectedChildren();
                int i = 0;
                while (i < changed.length) {
                    this.elementChanged(changed[i], forceUpdate);
                    ++i;
                }
            } else if (element.getElementType() == 2) {
                if ((delta.getFlags() & 0x20000) != 0) {
                    IJavaElement proj = element;
                    this.handleClasspathChange((IJavaProject)proj, delta, forceUpdate);
                } else {
                    IJavaElementDelta[] deltas = delta.getAffectedChildren();
                    if (deltas.length == 0) {
                        IJavaProject proj;
                        ProjectDescription description;
                        if ((delta.getKind() == 2 || (delta.getFlags() & 0x400) != 0) && (description = (ProjectDescription)TaglibIndex.this.fProjectDescriptions.remove((proj = (IJavaProject)element).getProject())) != null) {
                            if (_debugIndexCreation) {
                                Logger.log(1, "removing index of " + description.fProject.getName());
                            }
                            TaglibIndex.this.removeIndexFile(proj.getProject());
                        }
                    } else {
                        int i = 0;
                        while (i < deltas.length) {
                            this.elementChanged(deltas[i], false);
                            ++i;
                        }
                    }
                }
            } else if (((delta.getFlags() & 0x40) != 0 || (delta.getFlags() & 0x80) != 0) && (affectedProject = element.getJavaProject()) != null) {
                ProjectDescription affectedDescription;
                File indexFile = new File(TaglibIndex.this.computeIndexLocation(affectedProject.getProject().getFullPath()));
                if (indexFile.exists() && (affectedDescription = TaglibIndex.this.createDescription(affectedProject.getProject())) != null) {
                    affectedDescription.handleElementChanged(delta);
                }
                this.projectsIndexed.add(affectedProject.getProject());
            }
        }

        private void handleClasspathChange(IJavaProject project, IJavaElementDelta delta, boolean forceUpdate) {
            if (TaglibIndex.this.frameworkIsShuttingDown()) {
                return;
            }
            try {
                IResource resource = project.getCorrespondingResource();
                if (resource.getType() == 4 && !this.projectsIndexed.contains(resource)) {
                    ProjectDescription description = null;
                    description = forceUpdate ? TaglibIndex.this.createDescription((IProject)resource) : TaglibIndex.this.getDescription((IProject)resource);
                    if (description != null && !TaglibIndex.this.frameworkIsShuttingDown()) {
                        this.projectsIndexed.add(resource);
                        description.queueElementChanged(delta);
                    }
                }
            }
            catch (JavaModelException e) {
                Logger.logException(e);
            }
        }
    }

    private class MemoryListener
    extends AbstractMemoryListener {
        MemoryListener() {
            super(new String[]{"org/eclipse/equinox/events/MemoryEvent/SERIOUS", "org/eclipse/equinox/events/MemoryEvent/CRITICAL"});
        }

        protected void handleMemoryEvent(Event event) {
            TaglibIndex.this.clearProjectDescriptions();
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Handled duff style switch with additional control
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void resourceChanged(IResourceChangeEvent event) {
            if (!TaglibIndex.this.isIndexAvailable()) {
                return;
            }
            try {
                block32: {
                    TaglibIndex.LOCK.acquire();
                    if (TaglibIndex._debugEvents) {
                        Logger.log(1, "TaglibIndex responding to:" + event + "\n" + event.getDelta());
                    }
                    cfr_temp_0 = 0;
                    block13: do {
                        switch (cfr_temp_0 == 0 ? event.getType() : cfr_temp_0) {
                            case 2: 
                            case 4: {
                                try {
                                    deltas = new IResourceDelta[]{event.getDelta()};
                                    projects = null;
                                    cfr_temp_0 = 1;
                                    if (deltas.length <= 0) continue block13;
                                    resource = null;
                                    resource = deltas[0] != null ? deltas[0].getResource() : event.getResource();
                                    if (resource == null) ** GOTO lbl25
                                    if (resource.getType() != 8) ** GOTO lbl24
                                    deltas = deltas[0].getAffectedChildren();
                                    projects = new IProject[deltas.length];
                                    i = 0;
                                    if (true) ** GOTO lbl51
lbl24:
                                    // 1 sources

                                    projects = new IProject[]{resource.getType() != 4 ? resource.getProject() : (IProject)resource};
lbl25:
                                    // 3 sources

                                    while (true) {
                                        cfr_temp_0 = 1;
                                        if (projects == null) continue block13;
                                        i = 0;
                                        while (true) {
                                            if (i >= projects.length) {
                                                cfr_temp_0 = 1;
                                                continue block13;
                                            }
                                            if (TaglibIndex._debugIndexCreation) {
                                                Logger.log(1, "TaglibIndex noticed " + projects[i].getName() + " is about to be deleted/closed");
                                            }
                                            if ((description = (ProjectDescription)TaglibIndex.this.fProjectDescriptions.remove(projects[i])) != null) {
                                                if (TaglibIndex._debugIndexCreation) {
                                                    Logger.log(1, "removing index of " + description.fProject.getName());
                                                }
                                                description.clear();
                                            }
                                            ++i;
                                        }
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    Logger.logException("Exception while processing resource deletion", e);
                                    cfr_temp_0 = 1;
                                    continue block13;
                                }
                            }
                            default: {
                                break block32;
                            }
                            do {
                                if (deltas[i].getResource().getType() == 4) {
                                    projects[i] = (IProject)deltas[i].getResource();
                                }
                                ++i;
lbl51:
                                // 2 sources

                            } while (i < deltas.length);
                            ** continue;
                            case 1: 
                        }
                        break;
                    } while (true);
                    try {
                        block34: {
                            block35: {
                                deltas = new IResourceDelta[]{event.getDelta()};
                                projects = null;
                                if (deltas.length <= 0) break block32;
                                resource = null;
                                resource = deltas[0] != null ? deltas[0].getResource() : event.getResource();
                                if (resource == null) break block34;
                                if (resource.getType() != 8) break block35;
                                deltas = deltas[0].getAffectedChildren();
                                projects = new IProject[deltas.length];
                                i = 0;
                                if (true) ** GOTO lbl99
                            }
                            projects = new IProject[]{resource.getType() != 4 ? resource.getProject() : (IProject)resource};
                        }
lbl71:
                        // 2 sources

                        while (projects != null) {
                            i = 0;
                            while (i < projects.length) {
                                block33: {
                                    try {
                                        if (deltas[i] != null && deltas[i].getKind() != 2 && projects[i].isAccessible() && (description = TaglibIndex.this.getDescription(projects[i])) != null && !TaglibIndex.this.frameworkIsShuttingDown()) {
                                            deltas[i].accept(description.getVisitor());
                                        }
                                        if (projects[i].isAccessible() && (deltas[i] == null || deltas[i].getKind() != 2)) break block33;
                                        if (TaglibIndex._debugIndexCreation) {
                                            Logger.log(1, "TaglibIndex noticed " + projects[i].getName() + " was removed or is no longer accessible");
                                        }
                                        if ((description = (ProjectDescription)TaglibIndex.this.fProjectDescriptions.remove(projects[i])) != null) {
                                            if (TaglibIndex._debugIndexCreation) {
                                                Logger.log(1, "removing index of " + description.fProject.getName());
                                            }
                                            description.clear();
                                        }
                                    }
                                    catch (CoreException e) {
                                        Logger.logException(e);
                                    }
                                }
                                ++i;
                            }
                            break block32;
                        }
                        break block32;
                    }
                    catch (Exception e) {
                        Logger.logException("Exception while processing resource change", e);
                        break block32;
                    }
                    do {
                        if (deltas[i].getResource().getType() == 4) {
                            projects[i] = (IProject)deltas[i].getResource();
                        }
                        ++i;
lbl99:
                        // 2 sources

                    } while (i < deltas.length);
                    ** GOTO lbl71
                }
                TaglibIndex.this.fireCurrentDelta(event);
            }
            catch (Throwable var8_10) {
                var7_11 = null;
                TaglibIndex.LOCK.release();
                throw var8_10;
            }
            {
                var7_12 = null;
            }
            TaglibIndex.LOCK.release();
        }
    }
}

