/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.rmi.server.ObjID;
import java.util.Map;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.BatchValueHolder;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.indirection.TransformerBasedValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.indirection.WrappingValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class BasicIndirectionPolicy
extends IndirectionPolicy {
    public Object backupCloneAttribute(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        ValueHolderInterface valueHolder = (ValueHolderInterface)attributeValue;
        ValueHolder result = new ValueHolder();
        if (!(valueHolder instanceof UnitOfWorkValueHolder) || valueHolder.isInstantiated()) {
            result.setValue(super.backupCloneAttribute(valueHolder.getValue(), clone, backup, unitOfWork));
        } else {
            ((UnitOfWorkValueHolder)valueHolder).setBackupValueHolder(result);
        }
        return result;
    }

    public Object buildIndirectObject(ValueHolderInterface valueHolder) {
        return valueHolder;
    }

    public Object cloneAttribute(Object attributeValue, Object original, CacheKey cacheKey, Object clone, AbstractSession cloningSession, boolean buildDirectlyFromRow) {
        WeavedAttributeValueHolderInterface result;
        ValueHolderInterface valueHolder = (ValueHolderInterface)attributeValue;
        if (!buildDirectlyFromRow && cloningSession.isUnitOfWork() && ((UnitOfWorkImpl)cloningSession).isOriginalNewObject(original)) {
            if (valueHolder instanceof DatabaseValueHolder && !((DatabaseValueHolder)valueHolder).isInstantiated() && ((DatabaseValueHolder)valueHolder).getSession() == null && !((DatabaseValueHolder)valueHolder).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(original, this.mapping);
            }
            if (this.mapping.getRelationshipPartner() == null) {
                result = new ValueHolder();
                result.setValue(this.mapping.buildCloneForPartObject(valueHolder.getValue(), original, null, clone, cloningSession, false));
            } else {
                AbstractRecord row = null;
                if (valueHolder instanceof DatabaseValueHolder) {
                    row = ((DatabaseValueHolder)valueHolder).getRow();
                }
                result = this.mapping.createCloneValueHolder(valueHolder, original, clone, row, cloningSession, buildDirectlyFromRow);
                Object newObject = this.mapping.buildCloneForPartObject(valueHolder.getValue(), original, cacheKey, clone, cloningSession, false);
                ((UnitOfWorkValueHolder)result).privilegedSetValue(newObject);
                ((UnitOfWorkValueHolder)result).setInstantiated();
            }
        } else {
            AbstractRecord row = null;
            if (valueHolder instanceof DatabaseValueHolder) {
                row = ((DatabaseValueHolder)valueHolder).getRow();
            }
            result = this.mapping.createCloneValueHolder(valueHolder, original, clone, row, cloningSession, buildDirectlyFromRow);
        }
        return result;
    }

    public Object extractPrimaryKeyForReferenceObject(Object referenceObject, AbstractSession session) {
        if (this.objectIsInstantiated(referenceObject)) {
            return super.extractPrimaryKeyForReferenceObject(((ValueHolderInterface)referenceObject).getValue(), session);
        }
        return this.getOneToOneMapping().extractPrimaryKeysForReferenceObjectFromRow(this.extractReferenceRow(referenceObject));
    }

    public AbstractRecord extractReferenceRow(Object referenceObject) {
        if (this.objectIsInstantiated(referenceObject)) {
            return null;
        }
        return ((DatabaseValueHolder)referenceObject).getRow();
    }

    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        Object attributeValue = this.mapping.getAttributeValueFromObject(object);
        if (attributeValue instanceof RemoteValueHolder) {
            RemoteValueHolder rvh = (RemoteValueHolder)this.mapping.getAttributeValueFromObject(object);
            rvh.setSession(session);
            rvh.setMapping(this.mapping);
            if (!query.shouldMaintainCache() && (!query.shouldCascadeParts() || query.shouldCascadePrivateParts() && !this.mapping.isPrivateOwned())) {
                rvh.setQuery(null);
            } else {
                rvh.setQuery(query);
            }
            rvh.setUninstantiated();
        } else {
            this.mapping.fixRealObjectReferences(object, objectDescriptors, processedObjects, query, session);
        }
    }

    public Object getOriginalIndirectionObject(Object unitOfWorkIndirectionObject, AbstractSession session) {
        return this.getOriginalValueHolder(unitOfWorkIndirectionObject, session);
    }

    public Object getOriginalIndirectionObjectForMerge(Object unitOfWorkIndirectionObject, AbstractSession session) {
        DatabaseValueHolder holder = (DatabaseValueHolder)this.getOriginalIndirectionObject(unitOfWorkIndirectionObject, session);
        if (holder != null && holder.getSession() != null) {
            holder.setSession(session);
        }
        return holder;
    }

    public Object getOriginalValueHolder(Object unitOfWorkIndirectionObject, AbstractSession session) {
        ValueHolderInterface valueHolder;
        if (session.isRemoteUnitOfWork() && unitOfWorkIndirectionObject instanceof UnitOfWorkValueHolder && (valueHolder = ((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getWrappedValueHolder()) == null) {
            RemoteSessionController controller = ((RemoteUnitOfWork)session).getParentSessionController();
            ObjID id = ((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getWrappedValueHolderRemoteID();
            if (id == null) {
                Object object = ((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getSourceObject();
                AbstractRecord row = this.mapping.getDescriptor().getObjectBuilder().buildRow(object, session, DatabaseMapping.WriteType.UNDEFINED);
                ReadObjectQuery query = new ReadObjectQuery();
                query.setSession(((RemoteUnitOfWork)session).getParent());
                valueHolder = (ValueHolderInterface)this.mapping.valueFromRow(row, null, query, true);
            } else {
                valueHolder = (ValueHolderInterface)controller.getRemoteValueHolders().get(id);
            }
        }
        if (unitOfWorkIndirectionObject instanceof WrappingValueHolder) {
            valueHolder = null;
            if (session.isIsolatedClientSession()) {
                valueHolder = ((WrappingValueHolder)unitOfWorkIndirectionObject).getWrappedValueHolder();
            }
            if (!session.isProtectedSession()) {
                valueHolder = ((WrappingValueHolder)unitOfWorkIndirectionObject).getWrappedValueHolder();
                while (valueHolder instanceof WrappingValueHolder && ((WrappingValueHolder)((Object)valueHolder)).getWrappedValueHolder() != null) {
                    valueHolder = ((WrappingValueHolder)((Object)valueHolder)).getWrappedValueHolder();
                }
            }
            if (valueHolder != null && valueHolder instanceof DatabaseValueHolder) {
                ((DatabaseValueHolder)valueHolder).releaseWrappedValueHolder(session);
            }
            return valueHolder;
        }
        return unitOfWorkIndirectionObject;
    }

    public void reset(Object target) {
        this.mapping.setAttributeValueInObject(target, new ValueHolder());
    }

    public Object getRealAttributeValueFromObject(Object object, Object attribute) {
        if (attribute instanceof ValueHolderInterface) {
            return ((ValueHolderInterface)attribute).getValue();
        }
        return attribute;
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return remoteValueHolder.getValue();
    }

    public boolean isAttributeValueFullyBuilt(Object attributeValue) {
        return attributeValue != null;
    }

    public void iterateOnAttributeValue(DescriptorIterator iterator, Object attributeValue) {
        iterator.iterateValueHolderForMapping((ValueHolderInterface)attributeValue, this.mapping);
    }

    public void mergeRemoteValueHolder(Object clientSideDomainObject, Object serverSideDomainObject, MergeManager mergeManager) {
        RemoteValueHolder serverValueHolder = (RemoteValueHolder)this.mapping.getAttributeValueFromObject(serverSideDomainObject);
        this.mergeClientIntoServerValueHolder(serverValueHolder, mergeManager);
        this.mapping.setAttributeValueInObject(clientSideDomainObject, serverValueHolder);
    }

    public Object nullValueFromRow() {
        return new ValueHolder();
    }

    public boolean objectIsInstantiated(Object object) {
        return ((ValueHolderInterface)object).isInstantiated();
    }

    public boolean objectIsEasilyInstantiated(Object object) {
        if (object instanceof DatabaseValueHolder) {
            return ((DatabaseValueHolder)object).isEasilyInstantiated();
        }
        return true;
    }

    public void setRealAttributeValueInObject(Object target, Object attributeValue) {
        ValueHolderInterface holder = (ValueHolderInterface)this.mapping.getAttributeValueFromObject(target);
        if (holder == null) {
            holder = new ValueHolder(attributeValue);
        } else {
            holder.setValue(attributeValue);
        }
        super.setRealAttributeValueInObject(target, holder);
    }

    protected boolean typeIsValid(Class attributeType) {
        return attributeType == ClassConstants.ValueHolderInterface_Class || attributeType == ClassConstants.WeavedAttributeValueHolderInterface_Class;
    }

    public Object validateAttributeOfInstantiatedObject(Object attributeValue) {
        if (attributeValue == null) {
            return new ValueHolder();
        }
        if (!(attributeValue instanceof ValueHolderInterface)) {
            throw DescriptorException.valueHolderInstantiationMismatch(attributeValue, this.mapping);
        }
        return attributeValue;
    }

    public void validateDeclaredAttributeType(Class attributeType, IntegrityChecker checker) throws DescriptorException {
        super.validateDeclaredAttributeType(attributeType, checker);
        if (!this.typeIsValid(attributeType)) {
            checker.handleError(DescriptorException.attributeAndMappingWithIndirectionMismatch(this.mapping));
        }
    }

    public void validateGetMethodReturnType(Class returnType, IntegrityChecker checker) throws DescriptorException {
        super.validateGetMethodReturnType(returnType, checker);
        if (!this.typeIsValid(returnType)) {
            checker.handleError(DescriptorException.returnAndMappingWithIndirectionMismatch(this.mapping));
        }
    }

    public void validateSetMethodParameterType(Class parameterType, IntegrityChecker checker) throws DescriptorException {
        super.validateSetMethodParameterType(parameterType, checker);
        if (!this.typeIsValid(parameterType)) {
            checker.handleError(DescriptorException.parameterAndMappingWithIndirectionMismatch(this.mapping));
        }
    }

    public Object valueFromBatchQuery(ReadQuery batchQuery, AbstractRecord row, ObjectLevelReadQuery originalQuery, CacheKey parentCacheKey) {
        return new BatchValueHolder(batchQuery, row, this.getForeignReferenceMapping(), originalQuery, parentCacheKey);
    }

    public Object valueFromMethod(Object object, AbstractRecord row, AbstractSession session) {
        return new TransformerBasedValueHolder(this.getTransformationMapping().getAttributeTransformer(), object, row, session);
    }

    public Object valueFromQuery(ReadQuery query, AbstractRecord row, Object sourceObject, AbstractSession session) {
        return new QueryBasedValueHolder(query, sourceObject, row, session);
    }

    public Object valueFromQuery(ReadQuery query, AbstractRecord row, AbstractSession session) {
        return new QueryBasedValueHolder(query, row, session);
    }

    public Object valueFromRow(Object object) {
        return new ValueHolder(object);
    }
}

