/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AbstractViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllCollTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllMethodParams;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllMethodResults;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllObjects;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllQueueTables;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllSynonyms;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypeAttrs;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypeMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.SingleColumnViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRow;

public class ViewRowFactory
extends AbstractViewRow
implements ViewRow {
    private transient Map<String, Field> m_fieldCache = new HashMap<String, Field>();

    public static ViewRow createViewRow(String view, String[] columns, ResultSet rs) throws SQLException {
        AbstractViewRow vr = null;
        if (columns.length == 1) {
            vr = new SingleColumnViewRow(rs);
        } else if (view.equalsIgnoreCase("ALL_ARGUMENTS")) {
            vr = new AllArguments(rs);
        } else if (view.equalsIgnoreCase("USER_ARGUMENTS")) {
            vr = new UserArguments(rs);
        } else if (view.equalsIgnoreCase("ALL_COLL_TYPES")) {
            vr = new AllCollTypes(rs);
        } else if (view.equalsIgnoreCase("ALL_TYPES")) {
            vr = new AllTypes(rs);
        } else if (view.equalsIgnoreCase("ALL_TYPE_METHODS")) {
            vr = new AllTypeMethods(rs);
        } else if (view.equalsIgnoreCase("ALL_TYPE_ATTRS")) {
            vr = new AllTypeAttrs(rs);
        } else if (view.equalsIgnoreCase("ALL_METHOD_RESULTS")) {
            vr = new AllMethodResults(rs);
        } else if (view.equalsIgnoreCase("ALL_METHOD_PARAMS")) {
            vr = new AllMethodParams(rs);
        } else if (view.equalsIgnoreCase("ALL_OBJECTS")) {
            vr = new AllObjects(rs);
        } else if (view.equalsIgnoreCase("ALL_QUEUE_TABLES")) {
            vr = new AllQueueTables(rs);
        } else if (view.equalsIgnoreCase("ALL_SYNONYMS")) {
            vr = new AllSynonyms(rs);
        } else {
            throw new SQLException("View cache does not support " + view);
        }
        return vr;
    }

    public static String getProject(String view, String[] columns) {
        String[] projectList = null;
        if (columns.length > 0) {
            projectList = columns;
        } else if (view.equalsIgnoreCase("ALL_ARGUMENTS")) {
            projectList = AllArguments.getProjectList();
        } else if (view.equalsIgnoreCase("USER_ARGUMENTS")) {
            projectList = UserArguments.getProjectList();
        }
        if (projectList == null) {
            return "*";
        }
        String project = "";
        for (int i = 0; i < projectList.length; ++i) {
            project = project + projectList[i];
            if (i >= projectList.length - 1) continue;
            project = project + ", ";
        }
        return project;
    }

    public static boolean hasSequence(String view) {
        return view.equalsIgnoreCase("USER_ARGUMENTS") || view.equalsIgnoreCase("ALL_ARGUMENTS");
    }

    public static boolean hasPosition(String view) {
        return view.equalsIgnoreCase("USER_ARGUMENTS") || view.equalsIgnoreCase("ALL_ARGUMENTS");
    }

    @Override
    public boolean equals(String key, Object value) {
        boolean eq = false;
        try {
            Field field;
            if (this.m_fieldCache == null) {
                this.m_fieldCache = new HashMap<String, Field>();
            }
            if ((field = this.m_fieldCache.get(key)) == null) {
                Class<?> cls = this.getClass();
                Field[] fields = cls.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].getName().equalsIgnoreCase(key)) continue;
                    field = fields[i];
                    this.m_fieldCache.put(key, field);
                }
            }
            if (field == null) {
                System.err.println("ERROR: " + this.getClass().getName() + " does not have field " + key);
            }
            Object fieldValue = field.get(this);
            if (key.equals("OWNER")) {
                eq = fieldValue == null || fieldValue.equals(value);
            } else if (value == null) {
                eq = fieldValue == null || fieldValue.equals("");
            } else if (value.equals("NOT NULL")) {
                eq = fieldValue != null && !fieldValue.equals("");
            } else if (fieldValue == null) {
                eq = false;
            } else {
                eq = value.equals(fieldValue);
                if (!eq && !(value instanceof String)) {
                    eq = value.toString().equals(fieldValue.toString());
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return eq;
    }
}

