/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.util.Collection;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FuncResolver
extends Resolver {
    private final Collection<Resolver> resolvers;

    FuncResolver(Resolver parent, Collection<Resolver> resolvers) {
        super(parent);
        this.resolvers = resolvers;
    }

    @Override
    public void accept(ResolverVisitor visitor) {
    }

    @Override
    IType buildType() {
        IType stringType = null;
        IType numericType = null;
        IType dateTimeType = null;
        IType numericClass = this.getTypeHelper().numberType();
        IType dateClass = this.getTypeHelper().dateType();
        for (Resolver resolver : this.resolvers) {
            IType parameterType = resolver.getType();
            if (this.getTypeHelper().isStringType(parameterType)) {
                stringType = parameterType;
                continue;
            }
            if (parameterType.isAssignableTo(numericClass)) {
                numericType = numericClass;
                continue;
            }
            if (!parameterType.isAssignableTo(dateClass)) continue;
            dateTimeType = dateClass;
        }
        if (stringType != null && numericType == null && dateTimeType == null) {
            return stringType;
        }
        if (stringType == null && numericType != null && dateTimeType == null) {
            return numericType;
        }
        if (stringType == null && numericType == null && dateTimeType != null) {
            return dateTimeType;
        }
        return this.getTypeHelper().objectType();
    }

    @Override
    ITypeDeclaration buildTypeDeclaration() {
        return this.getType().getTypeDeclaration();
    }
}

