/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.attrgroup;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogFieldGroup;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogFieldGroupPage;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ISupportTextValue;
import org.eclipse.jst.jsf.common.ui.internal.dialogs.CommonWizardDialog;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.single.AddSubNodeCommand;
import org.eclipse.jst.pagedesigner.editors.properties.IPropertyPageDescriptor;
import org.eclipse.jst.pagedesigner.properties.attrgroup.AttributeGroupMessages;
import org.eclipse.jst.pagedesigner.properties.internal.AttributeGroup;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class DialogUtil {
    public static boolean createSubElement(Shell shell, final IDOMElement parent, final AttributeGroup group) {
        group.setElementContext((IDOMNode)parent, parent);
        if (group.getDialogFields().length == 0) {
            DialogUtil.createSubNode(group, parent, Collections.EMPTY_MAP);
            return true;
        }
        final DialogFieldGroupPage page = new DialogFieldGroupPage("", (DialogFieldGroup)group);
        page.setTitle(AttributeGroupMessages.getString("DialogUtil.createTitle", group.getTagName()));
        page.setDescription(AttributeGroupMessages.getString("DialogUtil.createDescription", group.getTagName(), parent.getTagName()));
        Wizard wizard = new Wizard(){

            public void addPages() {
                super.addPage((IWizardPage)page);
            }

            public boolean performFinish() {
                DialogField[] fields = group.getDialogFields();
                HashMap<String, String> map = new HashMap<String, String>();
                int i = 0;
                while (i < fields.length) {
                    String value;
                    IPropertyPageDescriptor desc = group.getPropertyDescriptor(fields[i]);
                    if (desc != null && fields[i] instanceof ISupportTextValue && (value = ((ISupportTextValue)fields[i]).getText()) != null && value.length() > 0) {
                        map.put(desc.getAttributeName(), value);
                    }
                    ++i;
                }
                DialogUtil.createSubNode(group, parent, map);
                return true;
            }
        };
        wizard.setWindowTitle(AttributeGroupMessages.getString("DialogUtil.createTitle", group.getTagName()));
        wizard.setDefaultPageImageDescriptor(PDPlugin.getDefault().getImageDescriptor("newsuade_wiz.gif"));
        CommonWizardDialog dialog = new CommonWizardDialog(shell, (IWizard)wizard);
        return dialog.open() == 0;
    }

    private static void createSubNode(AttributeGroup group, IDOMElement parent, Map mapOfAttributeValues) {
        AddSubNodeCommand addSubCommand = new AddSubNodeCommand(AttributeGroupMessages.getString("DialogUtil.createCommandLabel", group.getTagName()), parent, group.getTagName(), group.getURI(), mapOfAttributeValues);
        addSubCommand.execute();
    }

    public static boolean createSubElement(Shell shell, IDOMElement parent, String uri, String tagName, String[] attributes) {
        AttributeGroup group = new AttributeGroup(uri, tagName, attributes);
        return DialogUtil.createSubElement(shell, parent, group);
    }
}

