/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.lookup.EglLookupDelegate;
import org.eclipse.edt.mof.egl.lookup.ProxyPart;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.AbstractObjectStore;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.SerializationException;
import org.eclipse.edt.mof.serialization.TypeNotFoundException;

public class PartEnvironment
implements IEnvironment {
    public static PartEnvironment INSTANCE = new PartEnvironment((IEnvironment)Environment.INSTANCE);
    IEnvironment env;
    IRUtils irUtils = new IRUtils();
    private static ThreadLocal<Stack<PartEnvironment>> currentEnvs = new ThreadLocal<Stack<PartEnvironment>>(){

        @Override
        protected synchronized Stack<PartEnvironment> initialValue() {
            return new Stack<PartEnvironment>();
        }
    };

    public static synchronized PartEnvironment getCurrentEnv() {
        return currentEnvs.get().size() == 0 ? INSTANCE : currentEnvs.get().peek();
    }

    public static synchronized void pushEnv(PartEnvironment env) {
        currentEnvs.get().push(env);
    }

    public static synchronized PartEnvironment popEnv() {
        return currentEnvs.get().pop();
    }

    public PartEnvironment() {
        this(Environment.getCurrentEnv());
    }

    public PartEnvironment(IEnvironment env) {
        this.env = env;
        if (env.getLookupDelegates().get("egl") == null) {
            env.registerLookupDelegate("egl", (IEnvironment.LookupDelegate)new EglLookupDelegate());
        }
    }

    public EObject find(String key) throws MofObjectNotFoundException, DeserializationException {
        return this.find(key, false);
    }

    public MofSerializable findType(String mofSignature) throws TypeNotFoundException, DeserializationException {
        EObject type;
        try {
            type = this.find(mofSignature);
        }
        catch (MofObjectNotFoundException e) {
            throw new TypeNotFoundException((Throwable)e);
        }
        return (MofSerializable)type;
    }

    public EObject find(String key, boolean useProxies) throws MofObjectNotFoundException, DeserializationException {
        EObject obj = this.env.find(key, useProxies);
        if (!(obj instanceof ProxyPart) && obj instanceof LogicAndDataPart && ((Part)obj).getAnnotation("egl.core.IncludeReferencedFunctions") != null) {
            this.irUtils.resolveTopLevelFunctionsAndDanglingReferences((LogicAndDataPart)obj);
        }
        return obj;
    }

    public ObjectStore getDefaultSerializeStore(String keyScheme) {
        return this.env.getDefaultSerializeStore(keyScheme);
    }

    public EObject lookup(String key) throws DeserializationException {
        return this.env.lookup(key);
    }

    public void registerLookupDelegate(String scheme, IEnvironment.LookupDelegate delegate) {
        this.env.registerLookupDelegate(scheme, delegate);
    }

    public void registerObjectStore(String scheme, ObjectStore store) {
        this.env.registerObjectStore(scheme, store);
    }

    public void remove(String key) {
        this.env.remove(key);
    }

    public void save(MofSerializable object) throws SerializationException {
        this.env.save(object);
    }

    public void save(MofSerializable object, boolean serialize) throws SerializationException {
        this.env.save(object, serialize);
    }

    public void save(String key, EObject object) throws SerializationException {
        this.env.save(key, object);
    }

    public void save(String key, EObject object, boolean serialize) throws SerializationException {
        this.env.save(key, object, serialize);
    }

    public void setDefaultSerializeStore(String keyScheme, ObjectStore store) {
        this.env.setDefaultSerializeStore(keyScheme, store);
    }

    public long lastModified(String key) {
        return this.env.lastModified(key);
    }

    public EObject get(String key) {
        return this.env.get(key);
    }

    public IEnvironment.LookupDelegate getLookupDelegateForKey(String key) {
        return this.env.getLookupDelegateForKey(key);
    }

    public Map<String, List<ObjectStore>> getObjectStores() {
        return this.env.getObjectStores();
    }

    public Map<String, IEnvironment.LookupDelegate> getLookupDelegates() {
        return this.env.getLookupDelegates();
    }

    public void registerObjectStores(Map<String, List<ObjectStore>> newStores) {
        for (Map.Entry<String, List<ObjectStore>> entry : newStores.entrySet()) {
            String scheme = entry.getKey();
            List<ObjectStore> stores = entry.getValue();
            for (ObjectStore store : stores) {
                this.registerObjectStore(scheme, store);
            }
        }
    }

    public List<String> getAllKeysFromPkg(String pkg, boolean includeSubPkgs) {
        ArrayList<String> list = new ArrayList<String>();
        for (List osList : this.env.getObjectStores().values()) {
            for (ObjectStore os : osList) {
                if (!(os instanceof AbstractObjectStore)) continue;
                list.addAll(((AbstractObjectStore)os).getAllKeysFromPkg(pkg, includeSubPkgs));
            }
        }
        return list;
    }
}

