/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.EGLMessages;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.edt.compiler.internal.interfaces.IEGLMessageContributor;
import org.eclipse.edt.compiler.internal.interfaces.IEGLNestedMessageContributor;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.mof.egl.Annotation;

public class EGLMessage
implements IGenerationResultsMessage {
    public static final String IncludeEndOffset = "IncludeEndOffsetInGenerationMessage";
    protected int severity = 0;
    private String id = null;
    private String[] params = null;
    private IEGLMessageContributor messageContributor;
    private int startLineNumber = 0;
    private int endLineNumber = 0;
    private int endOffset = 0;
    private int startOffset = 0;
    private int startColumnNumber = 0;
    private int endColumnNumber = 0;
    private String builtMessage;
    private Map<String, String> messageBundle;
    private String partName;
    private static final MessageFormat formatter = new MessageFormat("");
    public static final int EGL_ERROR_MESSAGE = 1;
    public static final int EGL_WARNING_MESSAGE = 2;
    public static final int EGL_INFORMATIONAL_MESSAGE = 3;

    public EGLMessage() {
    }

    public EGLMessage(Map<String, String> mapping, int aSeverity, String anId, String[] aParams) {
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.messageBundle = mapping;
        this.builtMessage = this.buildMessageText(anId, aParams);
    }

    public EGLMessage(Map<String, String> mapping, int aSeverity, String anId, Object aMessageContributor, String[] aParams, int aStartOffset, int anEndOffset) {
        this.messageBundle = mapping;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.setStartOffset(aStartOffset);
        this.setEndOffset(Math.max(anEndOffset, aStartOffset));
        this.builtMessage = this.buildMessageText(anId, aParams);
        if (aMessageContributor != null && aMessageContributor instanceof IEGLMessageContributor) {
            IEGLMessageContributor mc = (IEGLMessageContributor)aMessageContributor;
            this.setMessageContributor(mc);
            if (aStartOffset == -1 && mc.getStart() != null) {
                this.setStartLine(mc.getStart().getLine());
                this.setStartColumn(mc.getStart().getColumn());
                this.setStartOffset(mc.getStart().getOffset());
            }
            if (anEndOffset == -1 && mc.getEnd() != null) {
                this.setEndLine(mc.getEnd().getLine());
                this.setEndColumn(mc.getEnd().getColumn());
                this.setEndOffset(mc.getEnd().getOffset() + 1);
            }
        }
    }

    public EGLMessage(Map<String, String> mapping, int aSeverity, String anId, Object aMessageContributor, String[] aParams, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        int aStartOffset = aStartColumn;
        int anEndOffset = Math.max(anEndColumn, aStartOffset);
        this.messageBundle = mapping;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.builtMessage = this.buildMessageText(anId, aParams);
        if (aMessageContributor != null && aMessageContributor instanceof IEGLMessageContributor) {
            IEGLMessageContributor mc = (IEGLMessageContributor)aMessageContributor;
            this.setMessageContributor(mc);
            if (aStartLine == -1 && mc.getStart() != null) {
                aStartLine = mc.getStart().getLine();
                aStartColumn = mc.getStart().getColumn();
                aStartOffset = mc.getStart().getOffset();
            }
            if (anEndLine == -1 && mc.getEnd() != null) {
                anEndLine = mc.getEnd().getLine();
                anEndColumn = mc.getEnd().getColumn();
                anEndOffset = mc.getEnd().getOffset() + 1;
            }
        }
        this.setStartLine(aStartLine);
        this.setStartColumn(aStartColumn);
        this.setEndLine(anEndLine);
        this.setEndColumn(anEndColumn);
        this.setStartOffset(aStartOffset);
        this.setEndOffset(anEndOffset);
    }

    public String buildMessageText(String key, Object[] inserts) {
        String message = this.messageBundle.get(key);
        if (message != null) {
            if (inserts == null || inserts.length == 0) {
                return message;
            }
            formatter.applyPattern(message);
            return formatter.format(EGLMessage.insertsWithoutNulls(inserts));
        }
        return key;
    }

    public static Object[] insertsWithoutNulls(Object[] originalInserts) {
        int numberInserts = originalInserts.length;
        Object[] newInserts = new Object[numberInserts];
        int i = 0;
        while (i < numberInserts) {
            newInserts[i] = originalInserts[i] != null ? originalInserts[i] : "";
            ++i;
        }
        return newInserts;
    }

    public static EGLMessage createEGLMessage(Map<String, String> mapping, int aSeverity, String messageID, Object messageContributor, String[] inserts, Annotation eglLocation) {
        int startLine = 0;
        int startOffset = 0;
        int endOffset = 0;
        if (eglLocation != null) {
            if (eglLocation.getValue("line") != null) {
                startLine = (Integer)eglLocation.getValue("line");
            }
            if (eglLocation.getValue("off") != null) {
                startOffset = (Integer)eglLocation.getValue("off");
            }
            if (eglLocation.getAnnotation(IncludeEndOffset) != null && eglLocation.getValue("len") != null) {
                endOffset = startOffset + (Integer)eglLocation.getValue("len");
                eglLocation.removeAnnotation(eglLocation.getAnnotation(IncludeEndOffset));
            }
        }
        return new EGLMessage(mapping, aSeverity, messageID, messageContributor, inserts, startLine, startOffset, 0, endOffset);
    }

    public String getBuiltMessage() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        return "IWN." + this.messageBundle.get("group") + "." + this.id + "." + flag + " " + this.startLineNumber + "/" + this.startColumnNumber + " " + this.builtMessage;
    }

    public String getBuiltMessageWithoutLineAndColumn() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        return "IWN." + this.messageBundle.get("group") + "." + this.id + "." + flag + " " + this.builtMessage;
    }

    public String getBuiltMessageWithLineAndColumn() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        if (this.messageContributor instanceof IEGLMessageContributor && this.messageContributor.getResourceName() != null) {
            return "IWN." + this.messageBundle.get("group") + "." + this.id + "." + flag + " - " + this.messageContributor.getResourceName() + " - " + this.startLineNumber + "/" + this.startColumnNumber + " - " + this.builtMessage;
        }
        return "IWN." + this.messageBundle.get("group") + "." + this.id + "." + flag + " - " + this.startLineNumber + "/" + this.startColumnNumber + " - " + this.builtMessage;
    }

    public int getEndColumn() {
        return this.endColumnNumber;
    }

    public int getEndLine() {
        return this.endLineNumber;
    }

    public String getId() {
        return this.id;
    }

    public Object getMessageContributor() {
        return this.messageContributor;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getStartColumn() {
        return this.startColumnNumber;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getStartLine() {
        return this.startLineNumber;
    }

    public boolean isError() {
        return this.getSeverity() == 1;
    }

    public boolean isInformational() {
        return this.getSeverity() == 3;
    }

    public boolean isWarning() {
        return this.getSeverity() == 2;
    }

    public String primGetBuiltMessage() {
        return this.builtMessage;
    }

    public void setBuiltMessage(String msgText) {
        this.builtMessage = msgText;
    }

    public void setEndColumn(int newColumnNumber) {
        this.endColumnNumber = newColumnNumber < 0 ? 0 : newColumnNumber;
    }

    public void setEndLine(int lineNumber) {
        this.endLineNumber = lineNumber < 0 ? 0 : lineNumber;
    }

    public void setMessageContributor(IEGLMessageContributor newPart) {
        this.messageContributor = newPart.getMessageContributor();
    }

    public void setMessageContributor(IEGLNestedMessageContributor newPart) {
        this.messageContributor = newPart.getMessageContributor();
    }

    public void setStartColumn(int newColumnNumber) {
        this.startColumnNumber = newColumnNumber < 0 ? 0 : newColumnNumber;
    }

    public void setStartLine(int lineNumber) {
        this.startLineNumber = lineNumber < 0 ? 0 : lineNumber;
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset < 0 ? 0 : offset;
    }

    public void setEndOffset(int offset) {
        this.endOffset = offset < 0 ? 0 : offset;
    }

    public String toString() {
        return String.valueOf(this.getId()) + ": " + this.builtMessage;
    }

    public String[] getParams() {
        return this.params;
    }

    public String getPartName() {
        return this.partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public String getResourceName() {
        if (this.getMessageContributor() instanceof IEGLMessageContributor) {
            return ((IEGLMessageContributor)this.getMessageContributor()).getResourceName();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EGLMessage) {
            EGLMessage msg = (EGLMessage)o;
            return msg.endColumnNumber == this.endColumnNumber && msg.endLineNumber == this.endLineNumber && msg.endOffset == this.endOffset && msg.severity == this.severity && msg.startColumnNumber == this.startColumnNumber && msg.startLineNumber == this.startLineNumber && msg.startOffset == this.startOffset && this.equals(msg.id, this.id) && this.equals(msg.partName, this.partName) && this.equals(msg.builtMessage, this.builtMessage) && this.equals(msg.params, this.params) && this.equals(msg.messageBundle, this.messageBundle);
        }
        return false;
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private boolean equals(Object[] o1, Object[] o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return Arrays.equals(o1, o2);
    }
}

