/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;

public class AnnotationFieldBinding
extends AnnotationBinding {
    private IAnnotationTypeBinding enclosingAnnotationType;
    private transient Object value;

    public AnnotationFieldBinding(String caseSensitiveInternedName, IPartBinding declarer, ITypeBinding typeBinding, IAnnotationTypeBinding enclosingAnnotationType) {
        super(caseSensitiveInternedName, declarer, typeBinding, true);
        this.enclosingAnnotationType = enclosingAnnotationType;
    }

    @Override
    public boolean isAnnotationField() {
        return true;
    }

    @Override
    public IAnnotationTypeBinding getEnclosingAnnotationType() {
        return this.enclosingAnnotationType;
    }

    @Override
    protected boolean shouldSerializeTypeBinding() {
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.value instanceof ITypeBinding) {
            out.writeBoolean(true);
            this.writeTypeBindingReference(out, (ITypeBinding)this.value);
        } else {
            out.writeBoolean(false);
            if (this.value instanceof Node) {
                out.writeObject(null);
            } else {
                out.writeObject(this.value);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.typeBinding = PrimitiveTypeBinding.getInstance(Primitive.ANY);
        boolean isType = in.readBoolean();
        this.value = isType ? this.readTypeBindingReference(in) : in.readObject();
    }

    @Override
    public Object getValue() {
        if (this.value instanceof ITypeBinding) {
            return this.realizeTypeBinding((ITypeBinding)this.value, this.getDeclaringPart() != null ? this.getDeclaringPart().getEnvironment() : null);
        }
        return this.value;
    }

    @Override
    protected void primSetValue(Object value) {
        this.value = value;
    }

    @Override
    public AnnotationBinding createCopy() {
        AnnotationFieldBinding copy = new AnnotationFieldBinding(this.getCaseSensitiveName(), this.getDeclaringPart(), this.getType(), this.getEnclosingAnnotationType());
        this.populateCopy(copy);
        return copy;
    }

    @Override
    protected void populateCopy(AnnotationBinding copy) {
        super.populateCopy(copy);
        copy.primSetValue(this.getValue());
    }
}

