/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLDataItemPropertyProblemAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLDataItemPropertyProblemsAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;

public class DataItemPropertiesProblemsProblemRequestor
extends DefaultProblemRequestor {
    private IProblemRequestor baseProblemRequestor;
    private IBinding targetBinding;
    private IAnnotationTypeBinding annotationType;

    public DataItemPropertiesProblemsProblemRequestor(IProblemRequestor baseProblemRequestor, IBinding targetBinding, IAnnotationTypeBinding annotationType) {
        this.baseProblemRequestor = baseProblemRequestor;
        this.targetBinding = targetBinding;
        this.annotationType = annotationType;
    }

    @Override
    public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
        int trueSeverity = severity;
        if (this.isDataItemBinding(this.targetBinding) && 2 == severity) {
            trueSeverity = 1;
            this.appendProblem(problemKind, inserts);
        }
        this.baseProblemRequestor.acceptProblem(startOffset, endOffset, trueSeverity, problemKind, inserts);
    }

    private void appendProblem(int problemKind, String[] inserts) {
        IPartBinding dataItemBinding = (IPartBinding)this.targetBinding;
        IAnnotationBinding propertyProblemsABinding = dataItemBinding.getAnnotation(EGLDataItemPropertyProblemsAnnotationTypeBinding.getInstance());
        if (propertyProblemsABinding == null) {
            propertyProblemsABinding = new AnnotationBinding(EGLDataItemPropertyProblemsAnnotationTypeBinding.caseSensitiveName, dataItemBinding, EGLDataItemPropertyProblemsAnnotationTypeBinding.getInstance());
            dataItemBinding.addAnnotation(propertyProblemsABinding);
        }
        IAnnotationBinding newProblemABinding = this.createProblemAnnotationBinding(dataItemBinding, problemKind, inserts);
        IAnnotationBinding[] propertyProblemABindings = (IAnnotationBinding[])propertyProblemsABinding.getValue();
        if (propertyProblemABindings == null) {
            propertyProblemABindings = new IAnnotationBinding[]{newProblemABinding};
        } else {
            IAnnotationBinding[] newPropertyProblemABindings = new IAnnotationBinding[propertyProblemABindings.length + 1];
            System.arraycopy(propertyProblemABindings, 0, newPropertyProblemABindings, 0, propertyProblemABindings.length);
            newPropertyProblemABindings[newPropertyProblemABindings.length - 1] = newProblemABinding;
            propertyProblemABindings = newPropertyProblemABindings;
        }
        propertyProblemsABinding.setValue(propertyProblemABindings, null, null, null, false);
    }

    private IAnnotationBinding createProblemAnnotationBinding(IPartBinding dataItemBinding, int problemKind, String[] inserts) {
        AnnotationBinding aBinding = new AnnotationBinding(EGLDataItemPropertyProblemAnnotationTypeBinding.caseSensitiveName, dataItemBinding, EGLDataItemPropertyProblemAnnotationTypeBinding.getInstance());
        AnnotationFieldBinding fieldBinding = new AnnotationFieldBinding(EGLDataItemPropertyProblemAnnotationTypeBinding.QUALIFIED_DATAITEM_NAME, dataItemBinding, (ITypeBinding)PrimitiveTypeBinding.getInstance(Primitive.STRING), EGLDataItemPropertyProblemAnnotationTypeBinding.getInstance());
        fieldBinding.setValue(dataItemBinding.getPackageQualifiedName(), null, null, null, false);
        aBinding.addField(fieldBinding);
        fieldBinding = new AnnotationFieldBinding(EGLDataItemPropertyProblemAnnotationTypeBinding.ANNOTATION_NAME, dataItemBinding, (ITypeBinding)PrimitiveTypeBinding.getInstance(Primitive.STRING), EGLDataItemPropertyProblemAnnotationTypeBinding.getInstance());
        fieldBinding.setValue(this.annotationType.getPackageQualifiedName(), null, null, null, false);
        aBinding.addField(fieldBinding);
        fieldBinding = new AnnotationFieldBinding(EGLDataItemPropertyProblemAnnotationTypeBinding.ERROR_MSG, dataItemBinding, (ITypeBinding)PrimitiveTypeBinding.getInstance(Primitive.STRING), EGLDataItemPropertyProblemAnnotationTypeBinding.getInstance());
        fieldBinding.setValue(DataItemPropertiesProblemsProblemRequestor.getMessageFromBundle(problemKind, inserts), null, null, null, false);
        aBinding.addField(fieldBinding);
        return aBinding;
    }

    private boolean isDataItemBinding(IBinding targetBinding2) {
        return this.targetBinding.isTypeBinding() && 17 == ((ITypeBinding)this.targetBinding).getKind();
    }
}

