/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionBindingCompletor;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.PartSubTypeAndAnnotationCollector;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.ExternalTypeScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;

public class ExternalTypeBindingCompletor
extends AbstractBinder {
    private ExternalTypeBinding externalTypeBinding;
    private IProblemRequestor problemRequestor;
    protected PartSubTypeAndAnnotationCollector partSubTypeAndAnnotationCollector;
    protected Set definedDataNames = new HashSet();
    protected Set definedFunctionNames = new HashSet();
    private List dataDeclarations = new ArrayList();

    public ExternalTypeBindingCompletor(Scope currentScope, ExternalTypeBinding externalTypeBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, externalTypeBinding, dependencyRequestor, compilerOptions);
        this.problemRequestor = problemRequestor;
        this.externalTypeBinding = externalTypeBinding;
    }

    public PartSubTypeAndAnnotationCollector getPartSubTypeAndAnnotationCollector() {
        if (this.partSubTypeAndAnnotationCollector == null) {
            this.partSubTypeAndAnnotationCollector = new PartSubTypeAndAnnotationCollector(this.externalTypeBinding, this, this.currentScope, this.problemRequestor);
        }
        return this.partSubTypeAndAnnotationCollector;
    }

    @Override
    public boolean visit(ExternalType externalType) {
        externalType.getName().setBinding(this.externalTypeBinding);
        externalType.accept(this.getPartSubTypeAndAnnotationCollector());
        this.externalTypeBinding.setPrivate(externalType.isPrivate());
        this.processExtends(externalType);
        return true;
    }

    private void processExtends(ExternalType externalType) {
        if (externalType.hasExtendedType()) {
            Iterator iter = externalType.getExtendedTypes().iterator();
            while (iter.hasNext()) {
                try {
                    Name name = (Name)iter.next();
                    ITypeBinding typeBinding = this.bindTypeName(name);
                    if (!Binding.isValidBinding(typeBinding) || typeBinding.getKind() != 28) continue;
                    ExternalTypeBinding extendedET = (ExternalTypeBinding)typeBinding;
                    if (extendedET.containsExtendsFor(this.externalTypeBinding)) {
                        this.problemRequestor.acceptProblem((Node)name, 5045, new String[]{this.externalTypeBinding.getCaseSensitiveName(), name.toString()});
                        name.setBinding(Binding.NOT_FOUND_BINDING);
                        continue;
                    }
                    this.externalTypeBinding.addExtendedType(typeBinding);
                }
                catch (ResolutionException e) {
                    this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                }
            }
        }
    }

    @Override
    public void endVisit(ExternalType externalType) {
        this.processSettingsBlocks();
        this.externalTypeBinding.setValid(true);
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        String name = nestedFunction.getName().getIdentifier();
        FunctionBinding functionBinding = new FunctionBinding(nestedFunction.getName().getCaseSensitiveIdentifier(), this.externalTypeBinding);
        FunctionBindingCompletor functionBindingCompletor = new FunctionBindingCompletor(this.externalTypeBinding, this.currentScope, functionBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        nestedFunction.accept(functionBindingCompletor);
        NestedFunctionBinding nestedFunctionBinding = new NestedFunctionBinding(functionBinding.getCaseSensitiveName(), (IPartBinding)this.externalTypeBinding, functionBinding);
        if (this.definedDataNames.contains(name)) {
            this.problemRequestor.acceptProblem((Node)nestedFunction.getName(), 3012, new String[]{nestedFunction.getName().getCanonicalName(), this.externalTypeBinding.getCaseSensitiveName()});
        } else if (this.definedFunctionNames.contains(name)) {
            Iterator iter = this.externalTypeBinding.getDeclaredFunctions().iterator();
            while (iter.hasNext()) {
                IFunctionBinding fBinding = (IFunctionBinding)((IDataBinding)iter.next()).getType();
                if (!TypeCompatibilityUtil.functionSignituresAreIdentical(fBinding, functionBinding, this.compilerOptions, false, false)) continue;
                this.problemRequestor.acceptProblem((Node)nestedFunction.getName(), 3022, new String[]{"function", nestedFunction.getName().getCanonicalName()});
                nestedFunction.getName().setBinding(nestedFunctionBinding);
                return false;
            }
        } else {
            this.definedFunctionNames.add(name);
        }
        this.externalTypeBinding.addDeclaredFunction(nestedFunctionBinding);
        nestedFunction.getName().setBinding(nestedFunctionBinding);
        return false;
    }

    protected void processSettingsBlocks() {
        this.processDataDeclarationsSettingsBlocks();
        if (this.getPartSubTypeAndAnnotationCollector().getSettingsBlocks().size() > 0) {
            AnnotationLeftHandScope scope = new AnnotationLeftHandScope(this.currentScope, this.externalTypeBinding, this.externalTypeBinding, this.externalTypeBinding, -1, this.externalTypeBinding);
            if (!this.getPartSubTypeAndAnnotationCollector().isFoundSubTypeInSettingsBlock() && this.getPartSubTypeAndAnnotationCollector().getSubTypeAnnotationBinding() != null) {
                scope = new AnnotationLeftHandScope(scope, this.getPartSubTypeAndAnnotationCollector().getSubTypeAnnotationBinding(), this.getPartSubTypeAndAnnotationCollector().getSubTypeAnnotationBinding().getType(), this.getPartSubTypeAndAnnotationCollector().getSubTypeAnnotationBinding(), -1, this.externalTypeBinding);
            }
            SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(new ExternalTypeScope(this.currentScope, this.externalTypeBinding), this.externalTypeBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            for (SettingsBlock block : this.getPartSubTypeAndAnnotationCollector().getSettingsBlocks()) {
                block.accept(blockCompletor);
            }
        }
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        ITypeBinding typeBinding = null;
        try {
            typeBinding = this.bindType(classDataDeclaration.getType());
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            if (classDataDeclaration.hasSettingsBlock()) {
                ExternalTypeBindingCompletor.bindNamesToNotFound(classDataDeclaration.getSettingsBlockOpt());
            }
            return false;
        }
        this.dataDeclarations.add(classDataDeclaration);
        for (Name name : classDataDeclaration.getNames()) {
            String dataName = name.getIdentifier();
            ClassFieldBinding fieldBinding = new ClassFieldBinding(name.getCaseSensitiveIdentifier(), this.externalTypeBinding, typeBinding);
            fieldBinding.setIsStatic(classDataDeclaration.isStatic());
            fieldBinding.setIsPrivate(classDataDeclaration.isPrivate());
            if (this.definedDataNames.contains(dataName)) {
                this.problemRequestor.acceptProblem((Node)name, 3012, new String[]{dataName, this.externalTypeBinding.getCaseSensitiveName()});
            } else {
                this.externalTypeBinding.addClassField(fieldBinding);
                this.definedDataNames.add(dataName);
            }
            name.setBinding(fieldBinding);
        }
        return false;
    }

    @Override
    public boolean visit(Constructor constructor) {
        final ConstructorBinding constructorBinding = new ConstructorBinding(this.externalTypeBinding);
        final HashSet definedParameters = new HashSet();
        constructor.setBinding(constructorBinding);
        constructorBinding.setPrivate(constructor.isPrivate());
        constructor.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(FunctionParameter functionParameter) {
                String parmName = functionParameter.getName().getIdentifier();
                Type parmType = functionParameter.getType();
                ITypeBinding typeBinding = null;
                try {
                    typeBinding = ExternalTypeBindingCompletor.this.bindType(parmType);
                }
                catch (ResolutionException e) {
                    functionParameter.getName().setBinding(new FunctionParameterBinding(functionParameter.getName().getCaseSensitiveIdentifier(), ExternalTypeBindingCompletor.this.externalTypeBinding, IBinding.NOT_FOUND_BINDING, (IFunctionBinding)constructorBinding.getType()));
                    ExternalTypeBindingCompletor.this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                    return false;
                }
                FunctionParameterBinding funcParmBinding = new FunctionParameterBinding(functionParameter.getName().getCaseSensitiveIdentifier(), ExternalTypeBindingCompletor.this.externalTypeBinding, typeBinding, (IFunctionBinding)constructorBinding.getType());
                functionParameter.getName().setBinding(funcParmBinding);
                if (!BindingUtilities.isValidDeclarationType(typeBinding)) {
                    ExternalTypeBindingCompletor.this.problemRequestor.acceptProblem((Node)parmType, 4902, new String[]{functionParameter.getName().getCanonicalName(), "constructor"});
                    return false;
                }
                FunctionParameter.AttrType attrType = functionParameter.getAttrType();
                if (attrType == FunctionParameter.AttrType.FIELD) {
                    funcParmBinding.setField(true);
                } else if (attrType == FunctionParameter.AttrType.SQLNULLABLE) {
                    funcParmBinding.setSqlNullable(true);
                }
                FunctionParameter.UseType useType = functionParameter.getUseType();
                if (useType == FunctionParameter.UseType.IN) {
                    funcParmBinding.setInput(true);
                } else if (useType == FunctionParameter.UseType.OUT) {
                    funcParmBinding.setOutput(true);
                } else if (useType == null && Binding.isValidBinding(typeBinding) && typeBinding.isReference()) {
                    funcParmBinding.setInput(true);
                }
                if (definedParameters.contains(parmName)) {
                    ExternalTypeBindingCompletor.this.problemRequestor.acceptProblem((Node)functionParameter, 3012, new String[]{functionParameter.getName().getCanonicalName(), "constructor"});
                } else {
                    constructorBinding.addParameter(funcParmBinding);
                    definedParameters.add(parmName);
                }
                return false;
            }
        });
        this.externalTypeBinding.addConstructor(constructorBinding);
        if (constructor.hasSettingsBlock()) {
            FunctionScope functionScope = new FunctionScope(this.currentScope, (FunctionBinding)constructorBinding.getType());
            AnnotationLeftHandScope scope = new AnnotationLeftHandScope(functionScope, constructorBinding, null, constructorBinding, -1, this.externalTypeBinding);
            SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(functionScope, this.externalTypeBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            constructor.getSettingsBlock().accept(blockCompletor);
        }
        return false;
    }

    private void processDataDeclarationsSettingsBlocks() {
        Iterator i = this.dataDeclarations.iterator();
        while (i.hasNext()) {
            this.processSettingsBlock((ClassDataDeclaration)i.next(), this.externalTypeBinding, this.currentScope, this.problemRequestor);
        }
    }
}

