/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.DataBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FixedRecordBindingImpl
extends FixedRecordBinding {
    public FixedRecordBindingImpl(String[] packageName, String caseSensitiveInternedName) {
        super(packageName, caseSensitiveInternedName);
    }

    private FixedRecordBindingImpl(FixedRecordBindingImpl old) {
        super(old);
    }

    private String getResourceAssociationName() {
        return InternUtil.intern((String)"resourceAssociation");
    }

    @Override
    public int getKind() {
        return 6;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean isStructurallyEqual(IPartBinding anotherPartBinding) {
        return false;
    }

    @Override
    public ITypeBinding copyTypeBinding() {
        FixedRecordBindingImpl newRecord = new FixedRecordBindingImpl(this.packageName, this.caseSensitiveInternedName);
        if (this.structureItems == Collections.EMPTY_LIST) {
            newRecord.structureItems = Collections.EMPTY_LIST;
        } else {
            newRecord.structureItems = new ArrayList();
            HashMap itemMapping = new HashMap();
            Iterator iter = this.structureItems.iterator();
            while (iter.hasNext()) {
                DataBinding newItem = (DataBinding)((StructureItemBinding)iter.next()).copyDataBinding(itemMapping);
                newItem.setDeclarer(this);
                newRecord.structureItems.add(newItem);
            }
            Iterator i = newRecord.getStructureItems().iterator();
            while (i.hasNext()) {
                this.copyResolvedAnnotationValues((StructureItemBinding)i.next(), itemMapping);
            }
        }
        newRecord.setNullable(this.isNullable());
        return newRecord;
    }

    private void copyResolvedAnnotationValues(StructureItemBinding siBinding, HashMap itemMappings) {
        this.switchResolovedAnnotationValues(siBinding, itemMappings);
        List list = siBinding.getChildren();
        for (StructureItemBinding item : list) {
            this.copyResolvedAnnotationValues(item, itemMappings);
        }
    }

    private void switchResolovedAnnotationValues(StructureItemBinding siBinding, HashMap itemMappings) {
        List anns = siBinding.getAnnotations();
        Iterator<Object> i = anns.iterator();
        HashMap<AnnotationBinding, AnnotationBinding> oldAnnToCopyAnnMap = new HashMap<AnnotationBinding, AnnotationBinding>();
        while (i.hasNext()) {
            AnnotationBinding origAnn = (AnnotationBinding)i.next();
            AnnotationBinding copyAnn = origAnn.createCopy();
            List fields = copyAnn.getAnnotationFields();
            for (AnnotationFieldBinding field : fields) {
                if (!itemMappings.containsKey(field.getValue())) continue;
                field.setValue(itemMappings.get(field.getValue()), null, null, null, false);
                oldAnnToCopyAnnMap.put(origAnn, copyAnn);
            }
        }
        for (Object key : oldAnnToCopyAnnMap.keySet()) {
            int index = anns.indexOf(key);
            if (index < 0) continue;
            anns.remove(key);
            anns.add(index, oldAnnToCopyAnnMap.get(key));
        }
    }

    @Override
    protected IDataBinding primFindData(String simpleName) {
        IDataBinding result = super.primFindData(simpleName);
        if (result == IBinding.NOT_FOUND_BINDING && simpleName == this.getResourceAssociationName() && BindingUtilities.hasResourceAssociation(this)) {
            return RESOURCEASSOCIATION;
        }
        return result;
    }

    @Override
    public boolean isDeclarablePart() {
        return true;
    }

    @Override
    public IDataBinding[] getFields() {
        return this.getStructureItems().toArray(new IDataBinding[this.getStructureItems().size()]);
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        FixedRecordBindingImpl nullable = new FixedRecordBindingImpl(this);
        nullable.setNullable(true);
        return nullable;
    }
}

