/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.TypeBinding;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ForeignLanguageTypeBinding
extends TypeBinding {
    public static final int NO_KIND = 0;
    public static final int OBJID_KIND = 1;
    public static final int JAVA_KIND = 2;
    public static ForeignLanguageTypeBinding OBJIDJAVA = new ForeignLanguageTypeBinding("objId:java", 1);
    public static ForeignLanguageTypeBinding JAVACHAR = new ForeignLanguageTypeBinding("java:char", 2);
    public static ForeignLanguageTypeBinding JAVABIGDECIMAL = new ForeignLanguageTypeBinding("java:java.math.bigdecimal", 2);
    public static ForeignLanguageTypeBinding JAVABIGINTEGER = new ForeignLanguageTypeBinding("java:java.math.biginteger", 2);
    public static ForeignLanguageTypeBinding JAVABYTE = new ForeignLanguageTypeBinding("java:byte", 2);
    public static ForeignLanguageTypeBinding JAVADOUBLE = new ForeignLanguageTypeBinding("java:double", 2);
    public static ForeignLanguageTypeBinding JAVAFLOAT = new ForeignLanguageTypeBinding("java:float", 2);
    public static ForeignLanguageTypeBinding JAVASHORT = new ForeignLanguageTypeBinding("java:short", 2);
    public static ForeignLanguageTypeBinding JAVAINT = new ForeignLanguageTypeBinding("java:int", 2);
    public static ForeignLanguageTypeBinding JAVALONG = new ForeignLanguageTypeBinding("java:long", 2);
    public static ForeignLanguageTypeBinding JAVABOOLEAN = new ForeignLanguageTypeBinding("java:boolean", 2);
    public static ForeignLanguageTypeBinding NULL = new ForeignLanguageTypeBinding("null", 0);
    private static Map instances = new HashMap();
    private int kind;

    static {
        instances.put(OBJIDJAVA.getName().toLowerCase(), OBJIDJAVA);
        instances.put(JAVACHAR.getName().toLowerCase(), JAVACHAR);
        instances.put(JAVABIGDECIMAL.getName().toLowerCase(), JAVABIGDECIMAL);
        instances.put(JAVABIGINTEGER.getName().toLowerCase(), JAVABIGINTEGER);
        instances.put(JAVABYTE.getName().toLowerCase(), JAVABYTE);
        instances.put(JAVADOUBLE.getName().toLowerCase(), JAVADOUBLE);
        instances.put(JAVAFLOAT.getName().toLowerCase(), JAVAFLOAT);
        instances.put(JAVASHORT.getName().toLowerCase(), JAVASHORT);
        instances.put(JAVAINT.getName().toLowerCase(), JAVAINT);
        instances.put(JAVALONG.getName().toLowerCase(), JAVALONG);
        instances.put(JAVABOOLEAN.getName().toLowerCase(), JAVABOOLEAN);
    }

    public static ForeignLanguageTypeBinding getInstance(String name) {
        return (ForeignLanguageTypeBinding)instances.get(name.toLowerCase());
    }

    private ForeignLanguageTypeBinding(String identifier, int kind) {
        super(InternUtil.internCaseSensitive((String)identifier));
        this.kind = kind;
    }

    @Override
    public int getKind() {
        return 29;
    }

    public int getForeignLanguageKind() {
        return this.kind;
    }

    @Override
    public ITypeBinding getBaseType() {
        return this;
    }

    public static Collection getSupportedCastStrings() {
        TreeSet<String> result = new TreeSet<String>();
        Iterator iter = instances.values().iterator();
        while (iter.hasNext()) {
            result.add(((IBinding)iter.next()).getCaseSensitiveName());
        }
        return result;
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        ForeignLanguageTypeBinding nullable = new ForeignLanguageTypeBinding(this.getCaseSensitiveName(), this.kind);
        nullable.setNullable(true);
        return nullable;
    }
}

