/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.AnnotationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ClassConstantBinding;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.DataBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionBindingCompletor;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.PartSubTypeAndAnnotationCollector;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.binding.UsedTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.Enumerations.ParameterModifierKind;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class FunctionContainerBindingCompletor
extends AbstractBinder {
    private FunctionContainerBinding functionContainerBinding;
    protected IProblemRequestor problemRequestor;
    protected Set definedDataNames = new HashSet();
    protected Set definedFunctionNames = new HashSet();
    protected PartSubTypeAndAnnotationCollector partSubTypeAndAnnotationCollector;
    protected FormGroupBinding mainFormGroup = null;
    protected Set usedForms = new HashSet();
    private FormGroupBinding helpFormGroup = null;
    private Set usedTypes = new HashSet();
    private Name helpFormGroupName;
    private List dataDeclarations = new ArrayList();
    private FunctionContainerScope functionContainerScope;

    public FunctionContainerBindingCompletor(FunctionContainerBinding functionContainerBinding, Scope currentScope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, functionContainerBinding, dependencyRequestor, compilerOptions);
        this.problemRequestor = problemRequestor;
        this.functionContainerBinding = functionContainerBinding;
    }

    public PartSubTypeAndAnnotationCollector getPartSubTypeAndAnnotationCollector() {
        if (this.partSubTypeAndAnnotationCollector == null) {
            this.partSubTypeAndAnnotationCollector = new PartSubTypeAndAnnotationCollector(this.functionContainerBinding, this, this.currentScope, this.problemRequestor);
        }
        return this.partSubTypeAndAnnotationCollector;
    }

    void endVisitFunctionContainer(Part part) {
        this.functionContainerBinding.setValid(true);
        if (this.helpFormGroup != null && this.mainFormGroup == null) {
            this.problemRequestor.acceptProblem(this.helpFormGroupName, 4936);
        }
        this.convertItemsToNullableIfNeccesary();
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        boolean varIsReadOnly = false;
        ITypeBinding typeBinding = null;
        try {
            typeBinding = this.bindType(classDataDeclaration.getType());
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            if (classDataDeclaration.hasSettingsBlock()) {
                FunctionContainerBindingCompletor.bindNamesToNotFound(classDataDeclaration.getSettingsBlockOpt());
            }
            return false;
        }
        this.dataDeclarations.add(classDataDeclaration);
        boolean isConstantDeclaration = classDataDeclaration.isConstant();
        Object constantValue = null;
        if (isConstantDeclaration) {
            constantValue = FunctionContainerBindingCompletor.getConstantValue(classDataDeclaration.getInitializer(), typeBinding, ((Name)classDataDeclaration.getNames().get(0)).getCanonicalName(), this.problemRequestor);
        }
        for (Name name : classDataDeclaration.getNames()) {
            String dataName = name.getIdentifier();
            ClassFieldBinding fieldBinding = isConstantDeclaration ? new ClassConstantBinding(name.getCaseSensitiveIdentifier(), this.functionContainerBinding, typeBinding, constantValue) : new ClassFieldBinding(name.getCaseSensitiveIdentifier(), this.functionContainerBinding, typeBinding);
            fieldBinding.setIsPrivate(classDataDeclaration.isPrivate());
            fieldBinding.setIsReadOnly(varIsReadOnly);
            if (this.definedDataNames.contains(dataName) || this.definedFunctionNames.contains(dataName)) {
                this.problemRequestor.acceptProblem((Node)name, 3012, new String[]{name.getCanonicalName(), this.functionContainerBinding.getName()});
            } else {
                this.functionContainerBinding.addClassField(fieldBinding);
                this.definedDataNames.add(dataName);
            }
            name.setBinding(fieldBinding);
        }
        return false;
    }

    private void processDataDeclarationsSettingsBlocks() {
        Iterator i = this.dataDeclarations.iterator();
        while (i.hasNext()) {
            this.processSettingsBlock((ClassDataDeclaration)i.next(), this.functionContainerBinding, this.getFunctionContainerScope(), this.problemRequestor);
        }
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        String name = nestedFunction.getName().getIdentifier();
        FunctionBinding functionBinding = new FunctionBinding(nestedFunction.getName().getCaseSensitiveIdentifier(), this.functionContainerBinding);
        FunctionBindingCompletor functionBindingCompletor = new FunctionBindingCompletor(this.functionContainerBinding, this.getFunctionContainerScope(), functionBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        nestedFunction.accept(functionBindingCompletor);
        NestedFunctionBinding nestedFunctionBinding = new NestedFunctionBinding(functionBinding.getCaseSensitiveName(), (IPartBinding)this.functionContainerBinding, functionBinding);
        nestedFunction.getName().setBinding(nestedFunctionBinding);
        ArrayList<IDataBinding> removeThese = new ArrayList<IDataBinding>();
        if (this.definedDataNames.contains(name)) {
            this.problemRequestor.acceptProblem((Node)nestedFunction.getName(), 3012, new String[]{nestedFunction.getName().getCanonicalName(), this.functionContainerBinding.getCaseSensitiveName()});
        } else if (this.definedFunctionNames.contains(name)) {
            for (IDataBinding fDataBinding : this.functionContainerBinding.getDeclaredFunctions()) {
                IFunctionBinding fBinding = (IFunctionBinding)fDataBinding.getType();
                if (!TypeCompatibilityUtil.functionSignituresAreIdentical(fBinding, functionBinding, this.compilerOptions, false, false)) continue;
                if (fBinding.isImplicit()) {
                    removeThese.add(fDataBinding);
                    if (this.isOverride(nestedFunction)) continue;
                    this.problemRequestor.acceptProblem(nestedFunction.getName(), 4038, 1, new String[]{nestedFunction.getName().getCanonicalName()});
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)nestedFunction.getName(), 3022, new String[]{"function", nestedFunction.getName().getCanonicalName()});
                return false;
            }
        } else {
            this.definedFunctionNames.add(name);
        }
        this.functionContainerBinding.addDeclaredFunction(nestedFunctionBinding);
        this.functionContainerBinding.getDeclaredFunctions().removeAll(removeThese);
        return false;
    }

    boolean isOverride(NestedFunction node) {
        final boolean[] override = new boolean[1];
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                setValuesExpression.getExpression().accept(this);
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                String name = annotationExpression.getCanonicalString();
                if (InternUtil.intern((String)name) == InternUtil.intern((String)"override")) {
                    override[0] = true;
                }
                return false;
            }
        };
        node.accept(visitor);
        return override[0];
    }

    protected void processSettingsBlocks() {
        this.processDataDeclarationsSettingsBlocks();
        if (this.getPartSubTypeAndAnnotationCollector().getSettingsBlocks().size() > 0) {
            AnnotationLeftHandScope scope = new AnnotationLeftHandScope(this.currentScope, this.functionContainerBinding, this.functionContainerBinding, this.functionContainerBinding, -1, this.functionContainerBinding);
            if (!this.getPartSubTypeAndAnnotationCollector().isFoundSubTypeInSettingsBlock()) {
                if (this.getPartSubTypeAndAnnotationCollector().getSubTypeAnnotationBinding() == null) {
                    if (this.getDefaultSubType() != null) {
                        AnnotationBinding annotation = new AnnotationBinding(this.getDefaultSubType().getCaseSensitiveName(), this.functionContainerBinding, this.getDefaultSubType());
                        this.functionContainerBinding.addAnnotation(annotation);
                        scope = new AnnotationLeftHandScope(scope, annotation, annotation.getType(), annotation, -1, this.functionContainerBinding);
                    }
                } else {
                    scope = new AnnotationLeftHandScope(scope, this.getPartSubTypeAndAnnotationCollector().getSubTypeAnnotationBinding(), this.getPartSubTypeAndAnnotationCollector().getSubTypeAnnotationBinding().getType(), this.getPartSubTypeAndAnnotationCollector().getSubTypeAnnotationBinding(), -1, this.functionContainerBinding);
                }
            }
            FunctionContainerScope fcScope = this.getFunctionContainerScope();
            fcScope.startReturningTopLevelFunctions();
            SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(fcScope, this.functionContainerBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            for (SettingsBlock block : this.getPartSubTypeAndAnnotationCollector().getSettingsBlocks()) {
                block.accept(blockCompletor);
            }
        } else if (this.getPartSubTypeAndAnnotationCollector().getSubTypeAnnotationBinding() == null && this.getDefaultSubType() != null) {
            AnnotationBinding annotation = new AnnotationBinding(this.getDefaultSubType().getCaseSensitiveName(), this.functionContainerBinding, this.getDefaultSubType());
            this.functionContainerBinding.addAnnotation(annotation);
        }
    }

    protected abstract IPartSubTypeAnnotationTypeBinding getDefaultSubType();

    @Override
    public boolean visit(UseStatement useStatement) {
        for (Name nextName : useStatement.getNames()) {
            IBinding qnBinding;
            ITypeBinding typeBinding = null;
            try {
                typeBinding = this.bindTypeName(nextName, true);
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                useStatement.setUsedTypeBinding(new UsedTypeBinding(IBinding.NOT_FOUND_BINDING));
                if (!useStatement.hasSettingsBlock()) continue;
                FunctionContainerBindingCompletor.bindNamesToNotFound(useStatement.getSettingsBlock());
                continue;
            }
            if (this.usedTypes.contains(typeBinding)) {
                this.problemRequestor.acceptProblem((Node)nextName, 3031, new String[]{nextName.getCanonicalString(), this.functionContainerBinding.getCaseSensitiveName()});
            } else {
                this.usedTypes.add(typeBinding);
            }
            if (11 == typeBinding.getKind()) {
                this.getFunctionContainerScope().addUsedLibrary(typeBinding);
                continue;
            }
            if (typeBinding.getKind() != 9 && typeBinding.getKind() != 8) continue;
            FormGroupBinding formGroupBinding = null;
            if (9 == typeBinding.getKind()) {
                formGroupBinding = (FormGroupBinding)typeBinding;
            } else if (nextName instanceof QualifiedName && Binding.isValidBinding(qnBinding = ((QualifiedName)nextName).getQualifier().resolveBinding()) && qnBinding.isTypeBinding() && ((ITypeBinding)qnBinding).getKind() == 9) {
                formGroupBinding = (FormGroupBinding)((QualifiedName)nextName).getQualifier().resolveBinding();
                this.usedForms.add(typeBinding);
                this.getFunctionContainerScope().setMainFormGroup(this.usedForms);
            }
            if (formGroupBinding == null) {
                this.problemRequestor.acceptProblem((Node)nextName, 4965, new String[]{nextName.getCanonicalString()});
                return false;
            }
            if (!formGroupBinding.isValid()) {
                formGroupBinding = (FormGroupBinding)formGroupBinding.realize();
            }
            UsedTypeBinding usedType = new UsedTypeBinding(formGroupBinding);
            useStatement.setUsedTypeBinding(usedType);
            if (useStatement.hasSettingsBlock()) {
                AnnotationLeftHandScope scope = new AnnotationLeftHandScope(this.currentScope, usedType, formGroupBinding, usedType, -1, this.functionContainerBinding);
                SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.functionContainerBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
                useStatement.getSettingsBlock().accept(blockCompletor);
            }
            if (usedType.isHelpGroup()) {
                if (this.helpFormGroup == null) {
                    this.helpFormGroup = formGroupBinding;
                    this.helpFormGroupName = nextName;
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)nextName, 4932, new String[]{nextName.getCanonicalString(), this.functionContainerBinding.getCaseSensitiveName()});
                continue;
            }
            if (9 == typeBinding.getKind()) {
                this.usedForms.addAll(formGroupBinding.getForms());
                this.getFunctionContainerScope().setMainFormGroup(this.usedForms);
            }
            if (this.mainFormGroup == null) {
                this.mainFormGroup = formGroupBinding;
                continue;
            }
            if (this.mainFormGroup == formGroupBinding) continue;
            this.problemRequestor.acceptProblem((Node)nextName, 4931, new String[]{nextName.getCanonicalString(), this.functionContainerBinding.getCaseSensitiveName()});
        }
        return false;
    }

    protected FunctionContainerScope getFunctionContainerScope() {
        if (this.functionContainerScope == null) {
            this.functionContainerScope = new FunctionContainerScope(this.currentScope, this.functionContainerBinding);
        }
        return this.functionContainerScope;
    }

    protected void addImplicitFieldsFromAnnotations() {
        for (IAnnotationBinding annotationBinding : this.functionContainerBinding.getAnnotations()) {
            int i;
            if ((annotationBinding = annotationBinding.getAnnotation(AnnotationAnnotationTypeBinding.getInstance())) == null) continue;
            IAnnotationBinding aBinding = (IAnnotationBinding)annotationBinding.findData("implicitFields");
            if (IBinding.NOT_FOUND_BINDING != aBinding) {
                IAnnotationBinding[] implicitFields = (IAnnotationBinding[])aBinding.getValue();
                i = 0;
                while (i < implicitFields.length) {
                    IAnnotationBinding implicitField = implicitFields[i];
                    IAnnotationBinding fieldNameBinding = (IAnnotationBinding)implicitField.findData("FieldName");
                    IAnnotationBinding fieldTypeBinding = (IAnnotationBinding)implicitField.findData("FieldType");
                    IAnnotationBinding isPrivateBinding = (IAnnotationBinding)implicitField.findData("IsPrivate");
                    if (IBinding.NOT_FOUND_BINDING != fieldNameBinding && IBinding.NOT_FOUND_BINDING != fieldTypeBinding) {
                        ClassFieldBinding newField = new ClassFieldBinding(InternUtil.internCaseSensitive((String)((String)fieldNameBinding.getValue())), this.functionContainerBinding, (ITypeBinding)fieldTypeBinding.getValue());
                        newField.setIsPrivate(IBinding.NOT_FOUND_BINDING != isPrivateBinding && Boolean.YES == isPrivateBinding.getValue());
                        this.functionContainerBinding.addClassField(newField);
                        newField.addAnnotations(implicitField.getAnnotations());
                        newField.setImplicit(true);
                        this.definedDataNames.add(newField);
                    }
                    ++i;
                }
            }
            if (IBinding.NOT_FOUND_BINDING == (aBinding = (IAnnotationBinding)annotationBinding.findData("implicitFunctions"))) continue;
            IAnnotationBinding[] implicitFunctions = (IAnnotationBinding[])aBinding.getValue();
            i = 0;
            while (i < implicitFunctions.length) {
                IAnnotationBinding implicitFunction = implicitFunctions[i];
                IAnnotationBinding functionNameBinding = (IAnnotationBinding)implicitFunction.findData("FunctionName");
                IAnnotationBinding isStaticBinding = (IAnnotationBinding)implicitFunction.findData("IsStatic");
                IAnnotationBinding parameterTypesBinding = (IAnnotationBinding)implicitFunction.findData("ParameterTypes");
                IAnnotationBinding returnTypeBinding = (IAnnotationBinding)implicitFunction.findData("ReturnType");
                IAnnotationBinding isPrivateBinding = (IAnnotationBinding)implicitFunction.findData("IsPrivate");
                IAnnotationBinding modifiersBinding = (IAnnotationBinding)implicitFunction.findData("modifiers");
                if (IBinding.NOT_FOUND_BINDING != functionNameBinding) {
                    FunctionBinding newFunction = new FunctionBinding(InternUtil.internCaseSensitive((String)((String)functionNameBinding.getValue())), this.functionContainerBinding);
                    newFunction.setImplicit(true);
                    if (IBinding.NOT_FOUND_BINDING != isStaticBinding && Boolean.YES == isStaticBinding.getValue()) {
                        newFunction.setStatic(true);
                    }
                    if (IBinding.NOT_FOUND_BINDING != isPrivateBinding && Boolean.YES == isPrivateBinding.getValue()) {
                        newFunction.setPrivate(true);
                    }
                    if (IBinding.NOT_FOUND_BINDING != parameterTypesBinding) {
                        Object[] parameterTypes = (Object[])parameterTypesBinding.getValue();
                        Object[] modifiers = null;
                        if (IBinding.NOT_FOUND_BINDING != modifiersBinding) {
                            modifiers = (Object[])modifiersBinding.getValue();
                        }
                        int j = 0;
                        while (j < parameterTypes.length) {
                            ITypeBinding typeBinding = (ITypeBinding)parameterTypes[j];
                            FunctionParameterBinding functionParameterBinding = new FunctionParameterBinding(InternUtil.internCaseSensitive((String)("arg" + Integer.toString(j + 1))), this.functionContainerBinding, typeBinding, newFunction);
                            if (modifiers != null && j < modifiers.length) {
                                if (modifiers[j].toString().equalsIgnoreCase(ParameterModifierKind.INMODIFIER.getName())) {
                                    functionParameterBinding.setInput(true);
                                } else if (modifiers[j].toString().equalsIgnoreCase(ParameterModifierKind.OUTMODIFIER.getName())) {
                                    functionParameterBinding.setOutput(true);
                                }
                            }
                            newFunction.addParameter(functionParameterBinding);
                            ++j;
                        }
                    }
                    if (IBinding.NOT_FOUND_BINDING != returnTypeBinding) {
                        newFunction.setReturnType((ITypeBinding)returnTypeBinding.getValue());
                    }
                    this.functionContainerBinding.addDeclaredFunction(new NestedFunctionBinding(newFunction.getCaseSensitiveName(), (IPartBinding)this.functionContainerBinding, newFunction));
                    this.definedFunctionNames.add(newFunction.getName());
                }
                ++i;
            }
        }
    }

    private void convertItemsToNullableIfNeccesary() {
        IAnnotationBinding aBinding = this.functionContainerBinding.getAnnotation(new String[]{"egl", "core"}, "I4GLItemsNullable");
        if (aBinding != null && Boolean.YES == aBinding.getValue()) {
            for (DataBinding next : this.functionContainerBinding.getClassFields()) {
                ITypeBinding type = next.getType();
                if (type == null || 3 != type.getBaseType().getKind()) continue;
                next.setType(type.getNullableInstance());
            }
            for (DataBinding next : this.functionContainerBinding.getDeclaredFunctions()) {
                FunctionBinding nextFunc = (FunctionBinding)next.getType();
                ITypeBinding returnType = nextFunc.getReturnType();
                if (returnType != null && 3 == returnType.getBaseType().getKind()) {
                    nextFunc.setReturnType(returnType.getNullableInstance());
                }
                for (DataBinding dBinding : nextFunc.getParameters()) {
                    ITypeBinding type = dBinding.getType();
                    if (type == null || 3 != type.getBaseType().getKind()) continue;
                    dBinding.setType(type.getNullableInstance());
                }
            }
        }
    }
}

