/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionBindingCompletor;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.InterfaceBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.PartSubTypeAndAnnotationCollector;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;

public class InterfaceBindingCompletor
extends AbstractBinder {
    private InterfaceBinding interfaceBinding;
    private IProblemRequestor problemRequestor;
    protected Set definedFunctionNames = new HashSet();
    protected PartSubTypeAndAnnotationCollector partSubTypeAndAnnotationCollector;

    public InterfaceBindingCompletor(Scope currentScope, InterfaceBinding interfaceBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, interfaceBinding, dependencyRequestor, compilerOptions);
        this.problemRequestor = problemRequestor;
        this.interfaceBinding = interfaceBinding;
    }

    public PartSubTypeAndAnnotationCollector getPartSubTypeAndAnnotationCollector() {
        if (this.partSubTypeAndAnnotationCollector == null) {
            this.partSubTypeAndAnnotationCollector = new PartSubTypeAndAnnotationCollector(this.interfaceBinding, this, this.currentScope, this.problemRequestor);
        }
        return this.partSubTypeAndAnnotationCollector;
    }

    @Override
    public boolean visit(Interface interfaceAST) {
        interfaceAST.getName().setBinding(this.interfaceBinding);
        interfaceAST.accept(this.getPartSubTypeAndAnnotationCollector());
        this.processSettingsBlocks();
        this.interfaceBinding.setPrivate(interfaceAST.isPrivate());
        this.processExtends(interfaceAST);
        return true;
    }

    private void processExtends(Interface interfaceAST) {
        if (interfaceAST.hasExtendedType()) {
            Iterator iter = interfaceAST.getExtendedTypes().iterator();
            while (iter.hasNext()) {
                try {
                    Name name = (Name)iter.next();
                    ITypeBinding typeBinding = this.bindTypeName(name);
                    if (!Binding.isValidBinding(typeBinding) || typeBinding.getKind() != 15) continue;
                    InterfaceBinding extendedInterface = (InterfaceBinding)typeBinding;
                    if (extendedInterface.containsExtendsFor(this.interfaceBinding)) {
                        this.problemRequestor.acceptProblem((Node)name, 5045, new String[]{this.interfaceBinding.getCaseSensitiveName(), name.toString()});
                        name.setBinding(Binding.NOT_FOUND_BINDING);
                        continue;
                    }
                    this.interfaceBinding.addExtendedType(typeBinding);
                }
                catch (ResolutionException e) {
                    this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                }
            }
        }
    }

    @Override
    public void endVisit(Interface interfaceNode) {
        this.interfaceBinding.setValid(true);
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        String name = nestedFunction.getName().getIdentifier();
        FunctionBinding functionBinding = new FunctionBinding(nestedFunction.getName().getCaseSensitiveIdentifier(), this.interfaceBinding);
        FunctionBindingCompletor functionBindingCompletor = new FunctionBindingCompletor(this.interfaceBinding, this.currentScope, functionBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        nestedFunction.accept(functionBindingCompletor);
        NestedFunctionBinding nestedFunctionBinding = new NestedFunctionBinding(functionBinding.getCaseSensitiveName(), (IPartBinding)this.interfaceBinding, functionBinding);
        if (this.definedFunctionNames.contains(name)) {
            Iterator iter = this.interfaceBinding.getDeclaredFunctions().iterator();
            while (iter.hasNext()) {
                IFunctionBinding fBinding = (IFunctionBinding)((IDataBinding)iter.next()).getType();
                if (!TypeCompatibilityUtil.functionSignituresAreIdentical(fBinding, functionBinding, this.compilerOptions, false, false)) continue;
                this.problemRequestor.acceptProblem((Node)nestedFunction.getName(), 3022, new String[]{"function", nestedFunction.getName().getCanonicalName()});
                nestedFunction.getName().setBinding(nestedFunctionBinding);
                return false;
            }
        } else {
            this.definedFunctionNames.add(name);
        }
        this.interfaceBinding.addDeclaredFunction(nestedFunctionBinding);
        nestedFunction.getName().setBinding(nestedFunctionBinding);
        return false;
    }

    protected void processSettingsBlocks() {
        if (this.getPartSubTypeAndAnnotationCollector().getSettingsBlocks().size() > 0) {
            AnnotationLeftHandScope scope = new AnnotationLeftHandScope(this.currentScope, this.interfaceBinding, this.interfaceBinding, this.interfaceBinding, -1, this.interfaceBinding);
            SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.interfaceBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            for (SettingsBlock block : this.getPartSubTypeAndAnnotationCollector().getSettingsBlocks()) {
                block.accept(blockCompletor);
            }
        }
    }
}

