/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.OverloadedFunctionSet;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBindingImpl;
import org.eclipse.edt.compiler.binding.SystemFunctionBinding;
import org.eclipse.edt.compiler.binding.TypeBinding;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemLibrary;

public abstract class PrimitiveTypeBinding
extends TypeBinding {
    private static Map primitivePool = new HashMap();
    private static final Set REFERENCE_PRIMITIVES = new HashSet();
    public static final SystemFunctionBinding LENGTH;
    public static final SystemFunctionBinding CLIP;
    public static final SystemFunctionBinding CLIPLEADING;
    public static final SystemFunctionBinding TRIM;
    public static final SystemFunctionBinding TOUPPERCASE;
    public static final SystemFunctionBinding TOLOWERCASE;
    public static final SystemFunctionBinding INDEXOF1;
    public static final SystemFunctionBinding INDEXOF2;
    public static final OverloadedFunctionSet INDEXOF3;
    public static final SystemFunctionBinding LASTINDEXOF;
    public static final SystemFunctionBinding ENDSWITH;
    public static final SystemFunctionBinding STARTSWITH;
    public static final SystemFunctionBinding REPLACESTR;
    public static final SystemFunctionBinding CHARCODEAT;
    public static final SystemFunctionBinding ISLIKE1;
    public static final SystemFunctionBinding ISLIKE2;
    public static final OverloadedFunctionSet ISLIKE3;
    public static final SystemFunctionBinding MATCHESPATTERN1;
    public static final SystemFunctionBinding MATCHESPATTERN2;
    public static final OverloadedFunctionSet MATCHESPATTERN3;
    protected static final Map<String, IDataBinding> STRING_FUNCTIONS;
    public static final SystemFunctionBinding DAYSDIFFERENT;
    public static final SystemFunctionBinding ADDDAYS;
    public static final SystemFunctionBinding EXTEND;
    protected static final Map<String, IDataBinding> DATE_FUNCTIONS;
    public static final SystemFunctionBinding DAYOF;
    public static final SystemFunctionBinding MONTHOF;
    public static final SystemFunctionBinding YEAROF;
    public static final SystemFunctionBinding WEEKDAYOF;
    public static final SystemFunctionBinding DATEOF;
    public static final SystemFunctionBinding TIMEOF;
    protected static final Map<String, IDataBinding> TIMESTAMP_FUNCTIONS;

    static {
        REFERENCE_PRIMITIVES.add(Primitive.ANY);
        REFERENCE_PRIMITIVES.add(Primitive.NUMBER);
        REFERENCE_PRIMITIVES.add(Primitive.BLOB);
        REFERENCE_PRIMITIVES.add(Primitive.CLOB);
        REFERENCE_PRIMITIVES.add(Primitive.STRING);
        LENGTH = SystemLibrary.createSystemFunction("length", null, PrimitiveTypeBinding.getInstance(Primitive.INT), 0);
        CLIP = SystemLibrary.createSystemFunction("clip", null, PrimitiveTypeBinding.getInstance(Primitive.STRING), 0);
        CLIPLEADING = SystemLibrary.createSystemFunction("clipLeading", null, PrimitiveTypeBinding.getInstance(Primitive.STRING), 0);
        TRIM = SystemLibrary.createSystemFunction("trim", null, PrimitiveTypeBinding.getInstance(Primitive.STRING), 0);
        TOUPPERCASE = SystemLibrary.createSystemFunction("toUpperCase", null, PrimitiveTypeBinding.getInstance(Primitive.STRING), 0);
        TOLOWERCASE = SystemLibrary.createSystemFunction("toLowerCase", null, PrimitiveTypeBinding.getInstance(Primitive.STRING), 0);
        INDEXOF1 = SystemLibrary.createSystemFunction("indexOf", null, PrimitiveTypeBinding.getInstance(Primitive.INT), new String[]{"substr"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
        INDEXOF2 = SystemLibrary.createSystemFunction("indexOf", null, PrimitiveTypeBinding.getInstance(Primitive.INT), new String[]{"substr", "startIndex"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING), PrimitiveTypeBinding.getInstance(Primitive.INT)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN, FunctionParameter.UseType.IN}, 0);
        INDEXOF3 = new OverloadedFunctionSet();
        INDEXOF3.setName(INDEXOF1.getCaseSensitiveName());
        INDEXOF3.addNestedFunctionBinding(new NestedFunctionBinding(INDEXOF1.getCaseSensitiveName(), null, INDEXOF1));
        INDEXOF3.addNestedFunctionBinding(new NestedFunctionBinding(INDEXOF2.getCaseSensitiveName(), null, INDEXOF2));
        LASTINDEXOF = SystemLibrary.createSystemFunction("lastIndexOf", null, PrimitiveTypeBinding.getInstance(Primitive.INT), new String[]{"substr"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
        ENDSWITH = SystemLibrary.createSystemFunction("endsWith", null, PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN), new String[]{"suffix"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
        STARTSWITH = SystemLibrary.createSystemFunction("startsWith", null, PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN), new String[]{"prefix"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
        REPLACESTR = SystemLibrary.createSystemFunction("replaceStr", null, PrimitiveTypeBinding.getInstance(Primitive.STRING), new String[]{"target", "replacement"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING), PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN, FunctionParameter.UseType.IN}, 0);
        CHARCODEAT = SystemLibrary.createSystemFunction("charCodeAt", null, PrimitiveTypeBinding.getInstance(Primitive.INT), new String[]{"index"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.INT)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
        ISLIKE1 = SystemLibrary.createSystemFunction("isLike", null, PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN), new String[]{"value"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
        ISLIKE2 = SystemLibrary.createSystemFunction("isLike", null, PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN), new String[]{"value", "esc"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING), PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN, FunctionParameter.UseType.IN}, 0);
        ISLIKE3 = new OverloadedFunctionSet();
        ISLIKE3.setName(ISLIKE1.getCaseSensitiveName());
        ISLIKE3.addNestedFunctionBinding(new NestedFunctionBinding(ISLIKE1.getCaseSensitiveName(), null, ISLIKE1));
        ISLIKE3.addNestedFunctionBinding(new NestedFunctionBinding(ISLIKE2.getCaseSensitiveName(), null, ISLIKE2));
        MATCHESPATTERN1 = SystemLibrary.createSystemFunction("matchesPattern", null, PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN), new String[]{"value"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
        MATCHESPATTERN2 = SystemLibrary.createSystemFunction("matchesPattern", null, PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN), new String[]{"value", "esc"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING), PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN, FunctionParameter.UseType.IN}, 0);
        MATCHESPATTERN3 = new OverloadedFunctionSet();
        MATCHESPATTERN3.setName(MATCHESPATTERN1.getCaseSensitiveName());
        MATCHESPATTERN3.addNestedFunctionBinding(new NestedFunctionBinding(MATCHESPATTERN1.getCaseSensitiveName(), null, MATCHESPATTERN1));
        MATCHESPATTERN3.addNestedFunctionBinding(new NestedFunctionBinding(MATCHESPATTERN2.getCaseSensitiveName(), null, MATCHESPATTERN2));
        STRING_FUNCTIONS = new HashMap<String, IDataBinding>();
        STRING_FUNCTIONS.put(LENGTH.getName(), new NestedFunctionBinding(LENGTH.getName(), null, LENGTH));
        STRING_FUNCTIONS.put(CLIP.getName(), new NestedFunctionBinding(CLIP.getName(), null, CLIP));
        STRING_FUNCTIONS.put(CLIPLEADING.getName(), new NestedFunctionBinding(CLIPLEADING.getName(), null, CLIPLEADING));
        STRING_FUNCTIONS.put(TRIM.getName(), new NestedFunctionBinding(TRIM.getName(), null, TRIM));
        STRING_FUNCTIONS.put(TOUPPERCASE.getName(), new NestedFunctionBinding(TOUPPERCASE.getName(), null, TOUPPERCASE));
        STRING_FUNCTIONS.put(TOLOWERCASE.getName(), new NestedFunctionBinding(TOLOWERCASE.getName(), null, TOLOWERCASE));
        STRING_FUNCTIONS.put(INDEXOF3.getName(), INDEXOF3);
        STRING_FUNCTIONS.put(LASTINDEXOF.getName(), new NestedFunctionBinding(LASTINDEXOF.getName(), null, LASTINDEXOF));
        STRING_FUNCTIONS.put(ENDSWITH.getName(), new NestedFunctionBinding(ENDSWITH.getName(), null, ENDSWITH));
        STRING_FUNCTIONS.put(STARTSWITH.getName(), new NestedFunctionBinding(STARTSWITH.getName(), null, STARTSWITH));
        STRING_FUNCTIONS.put(REPLACESTR.getName(), new NestedFunctionBinding(REPLACESTR.getName(), null, REPLACESTR));
        STRING_FUNCTIONS.put(CHARCODEAT.getName(), new NestedFunctionBinding(CHARCODEAT.getName(), null, CHARCODEAT));
        STRING_FUNCTIONS.put(ISLIKE3.getName(), ISLIKE3);
        STRING_FUNCTIONS.put(MATCHESPATTERN3.getName(), MATCHESPATTERN3);
        DAYSDIFFERENT = SystemLibrary.createSystemFunction("daysDifferent", null, PrimitiveTypeBinding.getInstance(Primitive.INT), new String[]{"other"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.DATE)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
        ADDDAYS = SystemLibrary.createSystemFunction("addDays", null, PrimitiveTypeBinding.getInstance(Primitive.DATE), new String[]{"days"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.INT)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
        EXTEND = SystemLibrary.createSystemFunction("extend", null, PrimitiveTypeBinding.getInstance(Primitive.TIMESTAMP), new String[]{"timeStampPattern"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
        DATE_FUNCTIONS = new HashMap<String, IDataBinding>();
        DATE_FUNCTIONS.put(DAYSDIFFERENT.getName(), new NestedFunctionBinding(DAYSDIFFERENT.getName(), null, DAYSDIFFERENT));
        DATE_FUNCTIONS.put(ADDDAYS.getName(), new NestedFunctionBinding(ADDDAYS.getName(), null, ADDDAYS));
        DATE_FUNCTIONS.put(EXTEND.getName(), new NestedFunctionBinding(EXTEND.getName(), null, EXTEND));
        DAYOF = SystemLibrary.createSystemFunction("dayOf", null, PrimitiveTypeBinding.getInstance(Primitive.INT), 0);
        MONTHOF = SystemLibrary.createSystemFunction("monthOf", null, PrimitiveTypeBinding.getInstance(Primitive.INT), 0);
        YEAROF = SystemLibrary.createSystemFunction("yearOf", null, PrimitiveTypeBinding.getInstance(Primitive.INT), 0);
        WEEKDAYOF = SystemLibrary.createSystemFunction("weekDayOf", null, PrimitiveTypeBinding.getInstance(Primitive.INT), 0);
        DATEOF = SystemLibrary.createSystemFunction("dateOf", null, PrimitiveTypeBinding.getInstance(Primitive.DATE), 0);
        TIMEOF = SystemLibrary.createSystemFunction("timeOf", null, PrimitiveTypeBinding.getInstance(Primitive.TIMESTAMP), 0);
        TIMESTAMP_FUNCTIONS = new HashMap<String, IDataBinding>();
        TIMESTAMP_FUNCTIONS.put(DAYOF.getName(), new NestedFunctionBinding(DAYOF.getName(), null, DAYOF));
        TIMESTAMP_FUNCTIONS.put(MONTHOF.getName(), new NestedFunctionBinding(MONTHOF.getName(), null, MONTHOF));
        TIMESTAMP_FUNCTIONS.put(YEAROF.getName(), new NestedFunctionBinding(YEAROF.getName(), null, YEAROF));
        TIMESTAMP_FUNCTIONS.put(WEEKDAYOF.getName(), new NestedFunctionBinding(WEEKDAYOF.getName(), null, WEEKDAYOF));
        TIMESTAMP_FUNCTIONS.put(DATEOF.getName(), new NestedFunctionBinding(DATEOF.getName(), null, DATEOF));
        TIMESTAMP_FUNCTIONS.put(TIMEOF.getName(), new NestedFunctionBinding(TIMEOF.getName(), null, TIMEOF));
        TIMESTAMP_FUNCTIONS.put(EXTEND.getName(), new NestedFunctionBinding(EXTEND.getName(), null, EXTEND));
    }

    public abstract Primitive getPrimitive();

    public abstract String getPattern();

    public abstract int getLength();

    public abstract int getDecimals();

    public abstract String getTimeStampOrIntervalPattern();

    @Override
    public abstract int getKind();

    public abstract int getBytes();

    public static Map getStringFunctions() {
        return STRING_FUNCTIONS;
    }

    public static Map getDateFunctions() {
        return DATE_FUNCTIONS;
    }

    public static Map getTimestampFunctions() {
        return TIMESTAMP_FUNCTIONS;
    }

    protected PrimitiveTypeBinding(String caseSensitiveInternedName) {
        super(caseSensitiveInternedName);
    }

    public static PrimitiveTypeBinding getInstance(Primitive prim) {
        int length = prim.hasDefaultLength() ? prim.getDefaultLength() : 0;
        int decimals = prim.hasDefaultDecimals() ? prim.getDefaultDecimals() : 0;
        return PrimitiveTypeBinding.getInstance(new PrimitiveSpec(prim, length, decimals, null));
    }

    public static PrimitiveTypeBinding getInstance(Primitive prim, int length) {
        int decimals = prim.hasDefaultDecimals() ? prim.getDefaultDecimals() : 0;
        return PrimitiveTypeBinding.getInstance(new PrimitiveSpec(prim, length, decimals, null));
    }

    public static PrimitiveTypeBinding getInstance(Primitive prim, int length, int decimals) {
        return PrimitiveTypeBinding.getInstance(new PrimitiveSpec(prim, length, decimals, null));
    }

    public static PrimitiveTypeBinding getInstance(Primitive prim, String pattern) {
        return PrimitiveTypeBinding.getInstance(new PrimitiveSpec(prim, 0, 0, pattern));
    }

    private static PrimitiveTypeBinding getInstance(PrimitiveSpec primSpec) {
        PrimitiveTypeBinding result = (PrimitiveTypeBinding)primitivePool.get(primSpec);
        if (result == null) {
            result = new PrimitiveTypeBindingImpl(primSpec);
            primitivePool.put(primSpec, result);
        }
        return result;
    }

    public String toString() {
        return new PrimitiveSpec(this.getPrimitive(), this.getLength(), this.getDecimals(), this.getPattern()).toString();
    }

    @Override
    public boolean isReference() {
        return REFERENCE_PRIMITIVES.contains(this.getPrimitive()) || this.getPrimitive() == Primitive.DECIMAL && this.getLength() == 0 || this.getPrimitive() == Primitive.TIMESTAMP && this.getPattern() == null;
    }

    public boolean isUnparemeterizedReference() {
        return this.isReference() && (this.getPrimitive() == Primitive.DECIMAL || this.getPrimitive() == Primitive.NUMBER || this.getPrimitive() == Primitive.TIMESTAMP || this.getPrimitive() == Primitive.STRING);
    }

    @Override
    public boolean isInstantiable() {
        return this.getPrimitive() == Primitive.STRING || this.getPrimitive() == Primitive.DECIMAL || this.getPrimitive() == Primitive.NUMBER;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        if (this.getPrimitive() == Primitive.STRING) {
            IDataBinding result = STRING_FUNCTIONS.get(simpleName);
            if (result != null) {
                return result;
            }
            return IBinding.NOT_FOUND_BINDING;
        }
        if (this.getPrimitive() == Primitive.DATE) {
            IDataBinding result = DATE_FUNCTIONS.get(simpleName);
            if (result != null) {
                return result;
            }
            return IBinding.NOT_FOUND_BINDING;
        }
        if (this.getPrimitive() == Primitive.TIMESTAMP) {
            IDataBinding result = TIMESTAMP_FUNCTIONS.get(simpleName);
            if (result != null) {
                return result;
            }
            return IBinding.NOT_FOUND_BINDING;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    protected static class PrimitiveSpec {
        Primitive prim;
        int length;
        int decimals;
        String pattern;

        public PrimitiveSpec(Primitive prim, int length, int decimals, String pattern) {
            this.prim = prim;
            this.length = length;
            this.decimals = decimals;
            this.pattern = pattern;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.prim.getType();
            result = 37 * result + this.length;
            result = 37 * result + this.decimals;
            if (this.pattern != null) {
                result = 37 * result + this.pattern.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PrimitiveSpec) {
                PrimitiveSpec otherSpec = (PrimitiveSpec)obj;
                return otherSpec.prim == this.prim && otherSpec.length == this.length && otherSpec.decimals == this.decimals && (otherSpec.pattern == null ? this.pattern == null : otherSpec.pattern.equals(this.pattern));
            }
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.prim.getName());
            if (this.decimals != 0) {
                sb.append("(" + Integer.toString(this.length) + "," + Integer.toString(this.decimals) + ")");
            } else if (!(this.length == 0 || this.prim.hasDefaultLength() && this.prim.getDefaultLength() == this.length)) {
                sb.append("(" + Integer.toString(this.length) + ")");
            } else if (this.pattern != null) {
                sb.append("(\"" + this.pattern + "\")");
            }
            return sb.toString();
        }
    }
}

