/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.DataBinding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Primitive;

public class StructureItemBinding
extends DataBinding {
    private Object initialValue;
    private List children = Collections.EMPTY_LIST;
    private transient Map unqualifiedNamesToDataBindings;
    transient StructureItemBinding parentItem;
    transient FixedStructureBinding enclosingStructureBinding;
    private int occurs = -1;
    private transient List occursDimensions;
    private transient int length = -1;
    private boolean readOnly;
    protected transient DataItemBinding dataItemReference;

    public StructureItemBinding(String caseSensitiveInternedName, IPartBinding declarer, ITypeBinding typeBinding) {
        super(caseSensitiveInternedName, declarer, typeBinding);
    }

    @Override
    public int getKind() {
        return 5;
    }

    public List getChildren() {
        return this.children;
    }

    public void addChild(StructureItemBinding itemBinding) {
        if (this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList();
        }
        this.children.add(itemBinding);
        itemBinding.setParentItem(this);
    }

    public StructureItemBinding getParentItem() {
        return this.parentItem;
    }

    void setParentItem(StructureItemBinding parentItem) {
        this.parentItem = parentItem;
    }

    public FixedStructureBinding getEnclosingStructureBinding() {
        if (this.enclosingStructureBinding == null && this.parentItem != null) {
            this.enclosingStructureBinding = this.parentItem.getEnclosingStructureBinding();
        }
        return this.enclosingStructureBinding;
    }

    @Override
    public IPartBinding getDeclaringPart() {
        if (super.getDeclaringPart() == null && this.parentItem != null) {
            return this.parentItem.getDeclaringPart();
        }
        return super.getDeclaringPart();
    }

    void setEnclosingStructureBinding(FixedStructureBinding structureBinding) {
        this.enclosingStructureBinding = structureBinding;
    }

    public boolean isMultiplyOccuring() {
        return this.hasOccurs() || this.parentItem != null && this.parentItem.isMultiplyOccuring();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setIsReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getOccurs() {
        return this.occurs;
    }

    public int numOccursDimensions() {
        return this.getOccursDimensions().size();
    }

    public List getOccursDimensions() {
        if (this.occursDimensions == null) {
            this.occursDimensions = this.parentItem != null ? new ArrayList(this.parentItem.getOccursDimensions()) : new ArrayList();
            if (this.hasOccurs()) {
                this.occursDimensions.add(new Integer(this.getOccurs()));
            }
        }
        return this.occursDimensions;
    }

    public void setOccurs(int occurs) {
        this.occurs = occurs;
    }

    public boolean hasOccurs() {
        return this.occurs > 1;
    }

    public boolean definedWithOccurs() {
        return this.occurs > 0;
    }

    @Override
    public ITypeBinding getType() {
        if (Binding.isValidBinding(this.typeBinding) && this.typeBinding.getKind() == 3 && ((PrimitiveTypeBinding)this.typeBinding).getLength() == -1) {
            this.getLengthInBytes();
        }
        return this.typeBinding;
    }

    public int getLengthInBytes() {
        if (this.length == -1) {
            if (Binding.isValidBinding(this.typeBinding) && this.typeBinding.getKind() == 3) {
                if (((PrimitiveTypeBinding)this.typeBinding).getLength() == -1) {
                    this.length = 0;
                    for (StructureItemBinding siBinding : this.children) {
                        if (siBinding.getAnnotation(new String[]{"egl", "core"}, "Redefines") != null) continue;
                        this.length += siBinding.getLengthInBytes();
                    }
                    this.typeBinding = this.createTypeBinding(((PrimitiveTypeBinding)this.typeBinding).getPrimitive(), this.length);
                } else {
                    this.length = ((PrimitiveTypeBinding)this.typeBinding).getBytes();
                }
            }
            if (this.hasOccurs()) {
                this.length *= this.occurs;
            }
        }
        return this.length;
    }

    private ITypeBinding createTypeBinding(Primitive prim, int bytes) {
        return PrimitiveTypeBinding.getInstance(prim, this.getLength(prim, bytes));
    }

    private int getLength(Primitive prim, int bytes) {
        switch (prim.getType()) {
            case 2: {
                if (bytes == 2) {
                    return 4;
                }
                if (bytes == 4) {
                    return 9;
                }
                if (bytes != 8) break;
                return 18;
            }
            case 7: 
            case 12: 
            case 16: {
                return bytes * 2 - 1;
            }
            case 5: 
            case 19: 
            case 20: {
                return bytes / 2;
            }
            case 9: {
                return bytes * 2;
            }
        }
        return bytes;
    }

    @Override
    public IDataBinding copyDataBinding(HashMap itemMapping) {
        StructureItemBinding newItem = new StructureItemBinding(this.getCaseSensitiveName(), null, this.typeBinding.copyTypeBinding());
        newItem.occurs = this.occurs;
        newItem.length = this.length;
        newItem.initialValue = this.initialValue;
        newItem.dataItemReference = this.dataItemReference;
        newItem.annotations = this.annotations != Collections.EMPTY_LIST ? new ArrayList(this.annotations) : this.annotations;
        itemMapping.put(this, newItem);
        if (this.children == Collections.EMPTY_LIST) {
            newItem.children = Collections.EMPTY_LIST;
        } else {
            newItem.children = new ArrayList();
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                StructureItemBinding copiedChild = (StructureItemBinding)((StructureItemBinding)iter.next()).copyDataBinding(itemMapping);
                newItem.children.add(copiedChild);
                copiedChild.setParentItem(newItem);
            }
        }
        return newItem;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        for (IDataBinding binding : this.children) {
            if (binding.getName() != simpleName) continue;
            return binding;
        }
        IDataBinding result = (IDataBinding)this.getSimpleNamesToDataBindingsMap().get(simpleName);
        if (result == null) {
            result = IBinding.NOT_FOUND_BINDING;
        }
        return result;
    }

    public void clearSimpleNamesToDataBindingsMap() {
        this.unqualifiedNamesToDataBindings = null;
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            ((StructureItemBinding)iter.next()).clearSimpleNamesToDataBindingsMap();
        }
    }

    public Map getSimpleNamesToDataBindingsMap() {
        if (this.unqualifiedNamesToDataBindings == null) {
            if (this.children == Collections.EMPTY_LIST) {
                this.unqualifiedNamesToDataBindings = Collections.EMPTY_MAP;
            } else {
                this.unqualifiedNamesToDataBindings = new HashMap();
                for (StructureItemBinding nextItem : this.children) {
                    BindingUtilities.addToUnqualifiedBindingNameMap(this.unqualifiedNamesToDataBindings, null, nextItem);
                    BindingUtilities.addAllToUnqualifiedBindingNameMap(this.unqualifiedNamesToDataBindings, null, nextItem.getSimpleNamesToDataBindingsMap());
                }
            }
        }
        return this.unqualifiedNamesToDataBindings;
    }

    public String getParentQualifiedName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCaseSensitiveName());
        StructureItemBinding curParent = this.getParentItem();
        while (curParent != null) {
            if (!"*".equals(curParent.getName())) {
                buffer.insert(0, String.valueOf(curParent.getCaseSensitiveName()) + ".");
            }
            curParent = curParent.getParentItem();
        }
        return buffer.toString();
    }

    public boolean hasInitialValue() {
        return this.initialValue != null;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Object initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public void setDataItemReference(DataItemBinding item) {
        this.dataItemReference = item;
    }

    public DataItemBinding getDataItemReference() {
        return this.dataItemReference;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeTypeBindingReference(out, this.dataItemReference);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.dataItemReference = (DataItemBinding)this.readTypeBindingReference(in);
        this.length = -1;
    }

    public void resetChildren() {
        this.children = Collections.EMPTY_LIST;
    }
}

