/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding.annotationType;

import java.util.Iterator;
import org.eclipse.edt.compiler.binding.AnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.mof.egl.utils.InternUtil;

class ContentsAnnotationTypeBinding
extends AnnotationTypeBinding {
    public static final String caseSensitiveName = InternUtil.internCaseSensitive((String)"contents");
    public static final String name = InternUtil.intern((String)caseSensitiveName);
    private static ContentsAnnotationTypeBinding INSTANCE = new ContentsAnnotationTypeBinding();

    private ContentsAnnotationTypeBinding() {
        super(caseSensitiveName, PrimitiveTypeBinding.getInstance(Primitive.ANY));
    }

    public static ContentsAnnotationTypeBinding getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isApplicableFor(IBinding binding) {
        return binding.isTypeBinding() && ((ITypeBinding)binding).getKind() == 5;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public ITypeBinding getSingleValueType() {
        return PrimitiveTypeBinding.getInstance(Primitive.ANY);
    }

    private static class OneDimensionArrayOfExpressionsChecker
    extends DefaultASTVisitor {
        boolean isOneDimensionalArrayOfLiterals = false;

        private OneDimensionArrayOfExpressionsChecker() {
        }

        void visitExpression(Expression expr) {
            expr.accept(this);
        }

        @Override
        public boolean visit(ArrayLiteral arrayLiteral) {
            this.isOneDimensionalArrayOfLiterals = true;
            return false;
        }
    }

    private static class TwoDimensionArrayOfExpressionsChecker
    extends DefaultASTVisitor {
        boolean isTwoDimensionalArrayOfLiterals = false;

        private TwoDimensionArrayOfExpressionsChecker() {
        }

        void visitExpression(Expression expr) {
            expr.accept(this);
        }

        @Override
        public boolean visit(ArrayLiteral arrayLiteral) {
            Iterator iter = arrayLiteral.getExpressions().iterator();
            while (iter.hasNext()) {
                OneDimensionArrayOfExpressionsChecker checker = new OneDimensionArrayOfExpressionsChecker();
                checker.visitExpression((Expression)iter.next());
                if (checker.isOneDimensionalArrayOfLiterals) continue;
                return false;
            }
            this.isTwoDimensionalArrayOfLiterals = true;
            return false;
        }
    }
}

