/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;

public class ArrayLiteral
extends LiteralExpression {
    private List exprs;

    public ArrayLiteral(List exprs, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.exprs = this.setParent(exprs);
    }

    public List getExpressions() {
        return this.exprs;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            ArrayLiteral.acceptChildren(visitor, this.exprs);
        }
        visitor.endVisit(this);
    }

    @Override
    public int getLiteralKind() {
        return 6;
    }

    @Override
    public String getCanonicalString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        Iterator iter = this.getExpressions().iterator();
        while (iter.hasNext()) {
            result.append(((Expression)iter.next()).getCanonicalString());
            if (!iter.hasNext()) continue;
            result.append(",");
        }
        result.append("]");
        return result.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new ArrayLiteral(this.cloneList(this.exprs), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        Iterator i = this.exprs.iterator();
        boolean first = true;
        while (i.hasNext()) {
            Expression exp = (Expression)i.next();
            if (!first) {
                buffer.append(",");
            }
            first = false;
            buffer.append(exp.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

