/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;

public class HexLiteral
extends LiteralExpression {
    private String rawString;
    private String stringValue;

    public HexLiteral(String rawString, String stringValue, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.rawString = rawString;
        this.stringValue = stringValue;
    }

    @Override
    public String getValue() {
        return this.stringValue;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int getLiteralKind() {
        return 8;
    }

    @Override
    public String getCanonicalString() {
        return this.rawString;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new HexLiteral(this.rawString, this.stringValue, this.getOffset(), this.getOffset() + this.getLength());
    }
}

