/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;

public class LikeMatchesExpression
extends Expression {
    private Operator operator;
    private Expression expr;
    private Expression expr2;
    private String escapeOpt;

    public LikeMatchesExpression(Operator operator, Expression expr, Expression expr2, String escapeOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.operator = operator;
        this.expr = expr;
        expr.setParent(this);
        this.expr2 = expr2;
        expr2.setParent(this);
        this.escapeOpt = escapeOpt;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getFirstExpression() {
        return this.expr;
    }

    public Expression getSecondExpression() {
        return this.expr2;
    }

    @Override
    public String getCanonicalString() {
        return "";
    }

    public boolean hasEscapeString() {
        return this.escapeOpt != null;
    }

    public String getEscapeString() {
        return this.escapeOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
            this.expr2.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        String newEscapeOpt = this.escapeOpt != null ? new String(this.escapeOpt) : null;
        return new LikeMatchesExpression(this.operator, (Expression)this.expr.clone(), (Expression)this.expr2.clone(), newEscapeOpt, this.getOffset(), this.getOffset() + this.getLength());
    }

    public static class Operator {
        private String token;
        public static final Operator LIKE = new Operator("like");
        public static final Operator MATCHES = new Operator("matches");
        private static final Map CODES = new HashMap(2);

        static {
            Operator[] ops = new Operator[]{LIKE, MATCHES};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return (Operator)CODES.get(token);
        }
    }
}

