/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;

public class MBCharLiteral
extends LiteralExpression {
    private String rawString;
    private String stringValue;
    private boolean isHex;

    public MBCharLiteral(String rawString, String stringValue, boolean isHex, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.rawString = rawString;
        this.stringValue = stringValue;
        this.isHex = isHex;
    }

    @Override
    public String getValue() {
        return this.stringValue;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public boolean isHex() {
        return this.isHex;
    }

    @Override
    public int getLiteralKind() {
        return 11;
    }

    @Override
    public String getCanonicalString() {
        return this.rawString;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new MBCharLiteral(this.rawString, this.stringValue, this.isHex, this.getOffset(), this.getOffset() + this.getLength());
    }
}

