/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.Statement;

public class TryStatement
extends Statement {
    private List stmts;
    private List onExceptionBlocks;

    public TryStatement(List stmts, List onExceptionBlocks, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.stmts = this.setParent(stmts);
        this.onExceptionBlocks = this.setParent(onExceptionBlocks);
    }

    public List getStmts() {
        return this.stmts;
    }

    public List getOnExceptionBlocks() {
        return this.onExceptionBlocks;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            TryStatement.acceptChildren(visitor, this.stmts);
            TryStatement.acceptChildren(visitor, this.onExceptionBlocks);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean canIncludeOtherStatements() {
        return true;
    }

    @Override
    public List getStatementBlocks() {
        ArrayList<List> result = new ArrayList<List>();
        result.add(this.stmts);
        Iterator iter = this.onExceptionBlocks.iterator();
        while (iter.hasNext()) {
            result.add(((OnExceptionBlock)iter.next()).getStmts());
        }
        return result;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new TryStatement(this.cloneList(this.stmts), this.cloneList(this.onExceptionBlocks), this.getOffset(), this.getOffset() + this.getLength());
    }
}

