/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IOStatementClauseInfo;
import org.eclipse.edt.compiler.core.ast.InlineDLIStatement;
import org.eclipse.edt.compiler.core.ast.WithInlineClause;

public class WithInlineDLIClause
extends WithInlineClause {
    public static IOStatementClauseInfo INFO = new IOStatementClauseInfo(){

        @Override
        public String getClauseKeyword() {
            return "with";
        }

        @Override
        public String getContentPrefix() {
            return "#SQL{";
        }

        @Override
        public String getContentSuffix() {
            return "}";
        }

        @Override
        public int getContentType() {
            return 1;
        }
    };
    private InlineDLIStatement dliStmt;

    public WithInlineDLIClause(InlineDLIStatement dliStmt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.dliStmt = dliStmt;
        dliStmt.setParent(this);
    }

    public InlineDLIStatement getDliStmt() {
        return this.dliStmt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.dliStmt.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new WithInlineDLIClause((InlineDLIStatement)this.dliStmt.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public boolean isWithInlineDLI() {
        return true;
    }

    @Override
    public String getStatement() {
        return this.getDliStmt().getValue();
    }
}

