/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.AnnotationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.AnnotationBindingForElement;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartFoundButNotAnnotationRecordAnnotationBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeManager;
import org.eclipse.edt.compiler.binding.annotationType.EGLSystemConstantAnnotationTypeBinding;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class AnnotationLeftHandScope
extends Scope {
    Scope scopeToUseWhenResolving;
    IBinding bindingBeingAnnotated;
    IBinding bindingToHoldAnnotation;
    IAnnotationBinding notApplicableBinding;
    ITypeBinding typeOfBindingBeingAnnotated;
    IDataBinding[] path;
    int index;
    boolean annotationFoundUsingThisScope;
    IPartBinding partBinding;
    boolean withinAnnotationExpression;
    boolean withinNewExpression;
    boolean resolveToAnnotations = true;

    public IBinding getBindingBeingAnnotated() {
        return this.bindingBeingAnnotated;
    }

    public IBinding getBindingToHoldAnnotation() {
        return this.bindingToHoldAnnotation;
    }

    public int getIndex() {
        return this.index;
    }

    public AnnotationLeftHandScope(Scope parentScope, IBinding bindingBeingAnnotated, ITypeBinding typeOfBindingBeingAnnotated, IBinding bindingToHoldAnnotation, int index, IPartBinding partBinding) {
        super(parentScope);
        this.scopeToUseWhenResolving = parentScope;
        this.bindingBeingAnnotated = bindingBeingAnnotated;
        this.bindingToHoldAnnotation = bindingToHoldAnnotation;
        this.index = index;
        this.typeOfBindingBeingAnnotated = typeOfBindingBeingAnnotated;
        this.partBinding = partBinding;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        IDataBinding result;
        IAnnotationTypeBinding typeBinding;
        IDataBinding fieldWithinTarget;
        IDataBinding fieldWithinStereotype;
        if (!this.withinNewExpression && (fieldWithinStereotype = this.getFieldWithinStereotype(simpleName)) != null) {
            return fieldWithinStereotype;
        }
        if (!this.withinAnnotationExpression && this.typeOfBindingBeingAnnotated != null && (fieldWithinTarget = this.typeOfBindingBeingAnnotated.getBaseType().findData(simpleName)) != IBinding.NOT_FOUND_BINDING) {
            this.annotationFoundUsingThisScope = fieldWithinTarget.isAnnotationBinding();
            return fieldWithinTarget;
        }
        this.annotationFoundUsingThisScope = false;
        this.notApplicableBinding = null;
        if (this.resolveToAnnotations && (typeBinding = AnnotationTypeManager.getAnnotationType(simpleName)) != null) {
            if (this.isApplicableFor(typeBinding, this.bindingBeingAnnotated, this.index)) {
                this.annotationFoundUsingThisScope = true;
                AnnotationBinding annotationBinding = this.index < 0 ? new AnnotationBinding(typeBinding.getCaseSensitiveName(), this.partBinding, typeBinding) : new AnnotationBindingForElement(typeBinding.getCaseSensitiveName(), this.partBinding, (ITypeBinding)typeBinding, this.index);
                return annotationBinding;
            }
            IDataBinding result2 = this.getScopeToUseWhenResolving().findData(simpleName);
            if (result2 == IBinding.NOT_FOUND_BINDING || result2 == IAnnotationBinding.NOT_APPLICABLE_ANNOTATION_BINDING) {
                this.notApplicableBinding = new AnnotationBindingForElement(typeBinding.getCaseSensitiveName(), null, (ITypeBinding)typeBinding, this.index);
                return IAnnotationBinding.NOT_APPLICABLE_ANNOTATION_BINDING;
            }
            return result2;
        }
        boolean foundPartButNotAnnotationRecord = false;
        ITypeBinding type = null;
        if (this.resolveToAnnotations) {
            type = this.getScopeToUseWhenResolving().findType(simpleName);
            if (IBinding.NOT_FOUND_BINDING != type && type.isPartBinding() && !((IPartBinding)type).isValid()) {
                type = ((IPartBinding)type).realize();
            }
            if (IBinding.NOT_FOUND_BINDING != type) {
                if (type.getKind() == 7 && ((IPartBinding)type).getSubType() == AnnotationAnnotationTypeBinding.getInstance()) {
                    AnnotationTypeBindingImpl annotationTypeBindingImpl = new AnnotationTypeBindingImpl((FlexibleRecordBinding)type, this.partBinding);
                    if (this.isApplicableFor(annotationTypeBindingImpl, this.bindingBeingAnnotated, this.index)) {
                        this.annotationFoundUsingThisScope = true;
                        AnnotationBinding annotationBinding = this.index < 0 ? new AnnotationBinding(type.getCaseSensitiveName(), this.partBinding, annotationTypeBindingImpl) : new AnnotationBindingForElement(type.getCaseSensitiveName(), this.partBinding, (ITypeBinding)annotationTypeBindingImpl, this.index);
                        return annotationBinding;
                    }
                    IDataBinding result3 = this.getScopeToUseWhenResolving().findData(simpleName);
                    if (IBinding.NOT_FOUND_BINDING != result3 && result3 != null && (15 == result3.getKind() || 20 == result3.getKind())) {
                        result3 = IBinding.NOT_FOUND_BINDING;
                    }
                    if (result3 == IBinding.NOT_FOUND_BINDING || result3 == IAnnotationBinding.NOT_APPLICABLE_ANNOTATION_BINDING) {
                        result3 = this.getFieldWithinStereotype(simpleName);
                    }
                    if (result3 == null) {
                        this.notApplicableBinding = new AnnotationBindingForElement(type.getCaseSensitiveName(), this.partBinding, (ITypeBinding)annotationTypeBindingImpl, this.index);
                        return IAnnotationBinding.NOT_APPLICABLE_ANNOTATION_BINDING;
                    }
                    return result3;
                }
                foundPartButNotAnnotationRecord = true;
            }
        }
        if ((result = this.getScopeToUseWhenResolving().findData(simpleName)) == IBinding.NOT_FOUND_BINDING && foundPartButNotAnnotationRecord) {
            return new PartFoundButNotAnnotationRecordAnnotationBinding(simpleName, null, type);
        }
        return result;
    }

    private IDataBinding getFieldWithinStereotype(String simpleName) {
        if (!this.withinAnnotationExpression && this.typeOfBindingBeingAnnotated != null) {
            IDataBinding fieldWithinStereotype = this.findInStereotypes(this.getStereotypes(this.typeOfBindingBeingAnnotated), simpleName);
            if (fieldWithinStereotype != IBinding.NOT_FOUND_BINDING) {
                this.annotationFoundUsingThisScope = true;
                return fieldWithinStereotype;
            }
            ITypeBinding baseType = this.typeOfBindingBeingAnnotated.getBaseType();
            if (this.typeOfBindingBeingAnnotated != baseType && baseType != null && (fieldWithinStereotype = this.findInStereotypes(this.getStereotypes(baseType), simpleName)) != IBinding.NOT_FOUND_BINDING) {
                this.annotationFoundUsingThisScope = true;
                return fieldWithinStereotype;
            }
        }
        return null;
    }

    private IDataBinding findInStereotypes(List stereotypes, String fieldName) {
        Iterator iter = stereotypes.iterator();
        while (iter.hasNext()) {
            IDataBinding result = ((ITypeBinding)iter.next()).findData(fieldName);
            if (IBinding.NOT_FOUND_BINDING == result) continue;
            return result;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    private List getStereotypes(ITypeBinding type) {
        ArrayList<ITypeBinding> result = new ArrayList<ITypeBinding>();
        for (IBinding next : type.getAnnotations()) {
            IAnnotationBinding aBinding;
            IAnnotationTypeBinding aType;
            if (!next.isAnnotationBinding() || (aType = (IAnnotationTypeBinding)(aBinding = (IAnnotationBinding)next).getType()) == null || !aType.isPartSubType()) continue;
            result.add(aBinding.getType());
        }
        return result;
    }

    private boolean isApplicableFor(IAnnotationTypeBinding annotationType, IBinding binding) {
        if (!this.withinAnnotationExpression && binding != null && IBinding.NOT_FOUND_BINDING != binding) {
            ITypeBinding type = null;
            if (binding.isTypeBinding()) {
                type = (ITypeBinding)binding;
            } else if (binding.isDataBinding()) {
                type = ((IDataBinding)binding).getType();
            }
            if (type != null) {
                switch (type.getKind()) {
                    case 21: {
                        return annotationType == EGLSystemConstantAnnotationTypeBinding.getInstance() || AbstractBinder.annotationIs(annotationType, new String[]{"eglx", "lang"}, "ordering") || AbstractBinder.annotationIs(annotationType, new String[]{"eglx", "lang"}, "caseSensitive");
                    }
                    case 22: {
                        return false;
                    }
                }
            }
        }
        return annotationType.isApplicableFor(binding);
    }

    public boolean isApplicableFor(IAnnotationTypeBinding annotationType, IBinding binding, int index) {
        boolean result = this.isApplicableFor(annotationType, binding);
        if (index < 0) {
            return result;
        }
        return result && annotationType.supportsElementOverride();
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        return this.getScopeToUseWhenResolving().findFunction(simpleName);
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.getScopeToUseWhenResolving().findPackage(simpleName);
    }

    @Override
    public ITypeBinding findType(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }

    public AnnotationLeftHandScope getTopLevelAnnotationLeftHandScope() {
        if (this.getParentScope().isAnnotationLeftHandScope()) {
            return ((AnnotationLeftHandScope)this.getParentScope()).getTopLevelAnnotationLeftHandScope();
        }
        return this;
    }

    @Override
    public boolean isAnnotationLeftHandScope() {
        return true;
    }

    public IAnnotationBinding getNotApplicableBinding() {
        return this.notApplicableBinding;
    }

    public void resetNotApplicableBinding() {
        this.notApplicableBinding = null;
    }

    public Scope getScopeToUseWhenResolving() {
        return this.scopeToUseWhenResolving;
    }

    public void setScopeToUseWhenResolving(Scope scopeToUseWhenResolving) {
        this.scopeToUseWhenResolving = scopeToUseWhenResolving;
    }

    public ITypeBinding getTypeOfBindingBeingAnnotated() {
        return this.typeOfBindingBeingAnnotated;
    }

    public IDataBinding[] getPath() {
        return this.path;
    }

    public void setPath(IDataBinding[] path) {
        this.path = path;
    }

    public void setAnnotationFoundUsingThisScope(boolean b) {
        this.annotationFoundUsingThisScope = b;
    }

    public boolean isAnnotationFoundUsingThisScope() {
        return this.annotationFoundUsingThisScope;
    }

    public void setWithinAnnotationExpression(boolean b) {
        this.withinAnnotationExpression = b;
    }

    public void setWithinNewExpression(boolean b) {
        this.withinNewExpression = b;
    }

    public void setNotApplicableBinding(IAnnotationBinding annotationBinding) {
        this.notApplicableBinding = annotationBinding;
    }

    public void setResolveToAnnotations(boolean b) {
        this.resolveToAnnotations = b;
    }

    public boolean isWithinNewExpression() {
        return this.withinNewExpression;
    }
}

