/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import org.eclipse.edt.compiler.binding.DataBindingWithImplicitQualifier;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class DataBindingScope
extends Scope {
    private IDataBinding dataBinding;
    private boolean includeImplicitQualifier = false;

    public DataBindingScope(Scope parentScope, IDataBinding dataBinding) {
        this(parentScope, dataBinding, false);
    }

    public DataBindingScope(Scope parentScope, IDataBinding dataBinding, boolean includeImplicitQualifier) {
        super(parentScope);
        this.dataBinding = dataBinding;
        this.includeImplicitQualifier = includeImplicitQualifier;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        IDataBinding result = this.dataBinding.findData(simpleName);
        if (result != IBinding.NOT_FOUND_BINDING) {
            if (this.includeImplicitQualifier) {
                result = new DataBindingWithImplicitQualifier(result, this.dataBinding);
            }
            return result;
        }
        return this.parentScope.findData(simpleName);
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        return this.parentScope.findFunction(simpleName);
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public ITypeBinding findType(String simpleName) {
        return this.parentScope.findType(simpleName);
    }
}

