/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.DataBindingWithImplicitQualifier;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.EnumerationTypeBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.internal.core.lookup.Enumerations.ElementKind;
import org.eclipse.edt.compiler.internal.core.lookup.Enumerations.Enumeration;
import org.eclipse.edt.compiler.internal.core.lookup.Enumerations.TypeKind;

public class EnumerationManager {
    private Map resolvableEnumDataBindings = Collections.EMPTY_MAP;
    private static Map enumTypes = Collections.EMPTY_MAP;
    private static Map allSystemEnumTypes = new HashMap();
    private static List resolvableEnumTypes = Collections.EMPTY_LIST;

    public EnumerationManager(EnumerationManager parentManager) {
        if (parentManager != null) {
            this.resolvableEnumDataBindings = new HashMap();
            this.resolvableEnumDataBindings.putAll(parentManager.resolvableEnumDataBindings);
        }
    }

    public IDataBinding findData(String simpleName) {
        EnumerationDataBinding result = (EnumerationDataBinding)this.getResolvableEnumDataBindings().get(simpleName);
        if (result != null) {
            EnumerationTypeBinding type = (EnumerationTypeBinding)result.getType();
            return new DataBindingWithImplicitQualifier(result, type.getStaticEnumerationTypeDataBinding());
        }
        return result;
    }

    private static List getResolvableEnumTypes() {
        if (resolvableEnumTypes == Collections.EMPTY_LIST) {
            EnumerationManager.initializeEnumTypes();
        }
        return resolvableEnumTypes;
    }

    public static Map getEnumTypes() {
        if (enumTypes == Collections.EMPTY_MAP) {
            EnumerationManager.initializeEnumTypes();
        }
        return enumTypes;
    }

    public Map getResolvableEnumDataBindings() {
        if (this.resolvableEnumDataBindings == Collections.EMPTY_MAP) {
            this.initializeResolvableEnumDataBindings();
        }
        return this.resolvableEnumDataBindings;
    }

    private static void initializeEnumTypes() {
        enumTypes = new HashMap();
        resolvableEnumTypes = new ArrayList();
        EnumerationManager.addEnumType(ElementKind.INSTANCE);
        EnumerationManager.addEnumType(TypeKind.INSTANCE);
    }

    private static void addEnumType(Enumeration enumeration) {
        EnumerationTypeBinding enumType = enumeration.getType();
        enumTypes.put(enumType.getName(), enumType);
        if (enumeration.isResolvable()) {
            resolvableEnumTypes.add(enumType);
        }
    }

    public void addSystemEnumType(EnumerationTypeBinding enumTypeBinding) {
        allSystemEnumTypes.put(enumTypeBinding.getName(), enumTypeBinding);
    }

    public Map getAllSystemEnumType() {
        return allSystemEnumTypes;
    }

    private void initializeResolvableEnumDataBindings() {
        this.resolvableEnumDataBindings = new HashMap();
        for (EnumerationTypeBinding type : EnumerationManager.getResolvableEnumTypes()) {
            this.addResolvableDataBindings(type);
        }
    }

    public void addResolvableDataBindings(EnumerationTypeBinding enumTypeBinding) {
        if (this.resolvableEnumDataBindings == Collections.EMPTY_MAP) {
            this.resolvableEnumDataBindings = new HashMap();
        }
        for (EnumerationDataBinding enumDataBinding : enumTypeBinding.getEnumerations()) {
            this.resolvableEnumDataBindings.put(enumDataBinding.getName(), enumDataBinding);
        }
    }
}

