/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.OverloadedFunctionSet;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.UsedTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.utils.ExpressionParser;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class FunctionContainerBinder
extends DefaultBinder {
    private FunctionContainerBinding functionContainerBinding;

    public FunctionContainerBinder(FunctionContainerBinding functionContainerBinding, Scope scope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(scope, functionContainerBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.functionContainerBinding = functionContainerBinding;
    }

    protected void preprocessPart(Part part) {
        this.dependencyRequestor.recordFunctionContainerScope((FunctionContainerScope)this.currentScope);
        final HashSet usedForms = new HashSet();
        Iterator iter = part.getContents().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(UseStatement useStatement) {
                    for (Name nextName : useStatement.getNames()) {
                        IBinding qualifierBinding;
                        ITypeBinding typeBinding = (ITypeBinding)nextName.resolveBinding();
                        if (typeBinding == IBinding.NOT_FOUND_BINDING || typeBinding == null) continue;
                        UsedTypeBinding usedType = useStatement.getUsedTypeBinding();
                        if (useStatement.getUsedTypeBinding() == null) {
                            usedType = new UsedTypeBinding(typeBinding);
                            useStatement.setUsedTypeBinding(usedType);
                            if (useStatement.hasSettingsBlock()) {
                                AnnotationLeftHandScope scope = new AnnotationLeftHandScope(FunctionContainerBinder.this.currentScope, usedType, null, usedType, -1, FunctionContainerBinder.this.functionContainerBinding);
                                SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(FunctionContainerBinder.this.currentScope, FunctionContainerBinder.this.functionContainerBinding, scope, FunctionContainerBinder.this.dependencyRequestor, FunctionContainerBinder.this.problemRequestor, FunctionContainerBinder.this.compilerOptions);
                                useStatement.getSettingsBlock().accept(blockCompletor);
                            }
                        }
                        if (typeBinding.getKind() == 11) {
                            ((FunctionContainerScope)FunctionContainerBinder.this.currentScope).addUsedLibrary(typeBinding);
                            continue;
                        }
                        if (typeBinding.getKind() == 5) {
                            ((FunctionContainerScope)FunctionContainerBinder.this.currentScope).addUsedDataTable(typeBinding);
                            continue;
                        }
                        if (typeBinding.getKind() == 19) {
                            ((FunctionContainerScope)FunctionContainerBinder.this.currentScope).addUsedEnumeration(typeBinding);
                            continue;
                        }
                        if (typeBinding.getKind() == 9) {
                            if (usedType.isHelpGroup()) continue;
                            FormGroupBinding formGroupBinding = (FormGroupBinding)typeBinding;
                            usedForms.addAll(formGroupBinding.getForms());
                            ((FunctionContainerScope)FunctionContainerBinder.this.currentScope).setMainFormGroup(usedForms);
                            for (FormBinding nextForm : formGroupBinding.getForms()) {
                                for (FormFieldBinding nextField : nextForm.getFields()) {
                                    IAnnotationBinding aBinding = nextField.getAnnotation(new String[]{"egl", "ui"}, "ValidatorFunction");
                                    if (aBinding == null || aBinding.getValue() == null) continue;
                                    if (aBinding.getValue() instanceof String) {
                                        FunctionContainerBinder.this.resolveValidatorFunctionRef(nextName, (String)aBinding.getValue());
                                        continue;
                                    }
                                    IFunctionBinding valFunctionBinding = (IFunctionBinding)aBinding.getValue();
                                    if (valFunctionBinding == IBinding.NOT_FOUND_BINDING || valFunctionBinding.isSystemFunction()) continue;
                                    FunctionContainerBinder.this.dependencyRequestor.recordTopLevelFunctionBinding(valFunctionBinding);
                                }
                            }
                            continue;
                        }
                        if (typeBinding.getKind() != 8) continue;
                        usedForms.add(typeBinding);
                        if (nextName.isQualifiedName() && (qualifierBinding = ((QualifiedName)nextName).getQualifier().resolveBinding()).isTypeBinding() && 9 == ((ITypeBinding)qualifierBinding).getKind()) {
                            ((FunctionContainerScope)FunctionContainerBinder.this.currentScope).setMainFormGroup(usedForms);
                        }
                        FormBinding nextForm = (FormBinding)typeBinding;
                        for (FormFieldBinding nextField : nextForm.getFields()) {
                            IFunctionBinding valFunctionBinding;
                            IAnnotationBinding aBinding = nextField.getAnnotation(new String[]{"egl", "ui"}, "ValidatorFunction");
                            if (aBinding == null) continue;
                            if (aBinding.getValue() instanceof String) {
                                FunctionContainerBinder.this.resolveValidatorFunctionRef(nextName, (String)aBinding.getValue());
                                continue;
                            }
                            if (!(aBinding.getValue() instanceof IFunctionBinding) || (valFunctionBinding = (IFunctionBinding)aBinding.getValue()) == IBinding.NOT_FOUND_BINDING || valFunctionBinding.isSystemFunction()) continue;
                            FunctionContainerBinder.this.dependencyRequestor.recordTopLevelFunctionBinding(valFunctionBinding);
                        }
                    }
                    return false;
                }
            });
        }
    }

    protected void doneVisitingPart() {
        this.currentScope.startReturningTopLevelFunctions();
        if (this.functionContainerBinding.getAnnotation(new String[]{"egl", "ui", "webtransaction"}, "VGWebTransaction") != null) {
            for (IDataBinding dBinding : this.functionContainerBinding.getDeclaredData()) {
                IFunctionBinding validatorFunctionBinding;
                IAnnotationBinding validatorFunctionAnnotation;
                ITypeBinding tBinding = dBinding.getType().getBaseType();
                if (tBinding.getAnnotation(new String[]{"egl", "ui", "webtransaction"}, "VGUIRecord") == null) continue;
                HashSet<IFunctionBinding> validatorFunctions = new HashSet<IFunctionBinding>();
                IAnnotationBinding runValidatorAnnotation = (IAnnotationBinding)tBinding.getAnnotation(new String[]{"egl", "ui", "webtransaction"}, "VGUIRecord").findData(InternUtil.intern((String)"runValidatorFromProgram"));
                if ((runValidatorAnnotation == IBinding.NOT_FOUND_BINDING || Boolean.YES == runValidatorAnnotation.getValue()) && (validatorFunctionAnnotation = (IAnnotationBinding)tBinding.getAnnotation(new String[]{"egl", "ui", "webtransaction"}, "VGUIRecord").findData(InternUtil.intern((String)"validatorFunction"))) != IBinding.NOT_FOUND_BINDING && (validatorFunctionBinding = (IFunctionBinding)validatorFunctionAnnotation.getValue()) != IBinding.NOT_FOUND_BINDING) {
                    validatorFunctions.add(validatorFunctionBinding);
                }
                Iterator iter2 = ((FixedRecordBinding)tBinding).getStructureItems().iterator();
                while (iter2.hasNext()) {
                    this.addValidatorFunctions(validatorFunctions, (StructureItemBinding)iter2.next());
                }
                iter2 = validatorFunctions.iterator();
                while (iter2.hasNext()) {
                    this.dependencyRequestor.recordTopLevelFunctionBinding((IFunctionBinding)iter2.next());
                }
            }
        }
    }

    private void addValidatorFunctions(Set functionBindings, StructureItemBinding sItemBinding) {
        IFunctionBinding validatorFunctionBinding;
        IAnnotationBinding validatorFunctionAnnotation;
        IAnnotationBinding runValidatorAnnotation = sItemBinding.getAnnotation(new String[]{"egl", "ui"}, "RunValidatorFromProgram");
        if ((runValidatorAnnotation == null || Boolean.YES == runValidatorAnnotation.getValue()) && (validatorFunctionAnnotation = sItemBinding.getAnnotation(new String[]{"egl", "ui"}, "ValidatorFunction")) != null && (validatorFunctionBinding = (IFunctionBinding)validatorFunctionAnnotation.getValue()) != IBinding.NOT_FOUND_BINDING) {
            functionBindings.add(validatorFunctionBinding);
        }
        Iterator iter = sItemBinding.getChildren().iterator();
        while (iter.hasNext()) {
            this.addValidatorFunctions(functionBindings, (StructureItemBinding)iter.next());
        }
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        if (classDataDeclaration.getSettingsBlockOpt() != null) {
            classDataDeclaration.getSettingsBlockOpt().accept(this);
        }
        if (classDataDeclaration.hasInitializer()) {
            classDataDeclaration.getInitializer().accept(this);
        }
        this.processResolvableProperties(classDataDeclaration);
        return false;
    }

    private void processResolvableProperties(ClassDataDeclaration classDataDeclaration) {
        for (Name name : classDataDeclaration.getNames()) {
            if (name.resolveBinding() == IBinding.NOT_FOUND_BINDING) break;
            if (classDataDeclaration.hasSettingsBlock()) {
                this.processResolvableProperties(classDataDeclaration.getSettingsBlockOpt(), name.resolveDataBinding(), null);
            }
            this.processResolvableProperties(name);
        }
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        IFunctionBinding functionBinding = (IFunctionBinding)((NestedFunctionBinding)nestedFunction.getName().resolveBinding()).getType();
        if (functionBinding != null) {
            FunctionBinder functionBinder = new FunctionBinder(this.functionContainerBinding, functionBinding, this.currentScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            nestedFunction.accept(functionBinder);
        }
        return false;
    }

    private Object resolveValidatorFunctionRef(Node errorNode, String value) {
        IFunctionBinding result;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(value);
        if (name == null) {
            return null;
        }
        try {
            IDataBinding resultDBinding = this.bindExpressionName(name, true);
            if (23 == resultDBinding.getKind()) {
                resultDBinding = (IDataBinding)((OverloadedFunctionSet)resultDBinding).getNestedFunctionBindings().get(0);
            }
            if (resultDBinding.getType() != null && resultDBinding.getType().isFunctionBinding()) {
                if (11 == resultDBinding.getDeclaringPart().getKind()) {
                    result = IBinding.NOT_FOUND_BINDING;
                    this.problemRequestor.acceptProblem(errorNode, 3169, 2, new String[]{"validatorFunction", value});
                } else {
                    result = (IFunctionBinding)resultDBinding.getType();
                }
            } else {
                result = IBinding.NOT_FOUND_BINDING;
                this.problemRequestor.acceptProblem(errorNode, 3183, 2, new String[]{"validatorFunction", value});
            }
        }
        catch (ResolutionException e) {
            if (6619 == e.getProblemKind()) {
                this.problemRequestor.acceptProblem(errorNode, 6746, 2, e.getInserts());
                result = IBinding.NOT_FOUND_BINDING;
            }
            if (6620 == e.getProblemKind()) {
                this.problemRequestor.acceptProblem(errorNode, 6747, 2, e.getInserts());
                result = IBinding.NOT_FOUND_BINDING;
            }
            this.problemRequestor.acceptProblem(errorNode, e.getProblemKind(), 2, e.getInserts());
            result = IBinding.NOT_FOUND_BINDING;
        }
        return result;
    }
}

