/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.AmbiguousDataBinding;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.DataBindingWithImplicitQualifier;
import org.eclipse.edt.compiler.binding.DataTableBinding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.EnumerationTypeBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.OverloadedFunctionSet;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FunctionContainerScope
extends Scope {
    FunctionContainerBinding functionContainerBinding;
    private boolean unqualifiedItemReferencesAreAllowed;
    private boolean I4GLItemsNullableIsEnabled;
    private List usedLibraries = Collections.EMPTY_LIST;
    private List usedDataTables = Collections.EMPTY_LIST;
    private List usedEnumerations = Collections.EMPTY_LIST;
    private Set usedForms = Collections.EMPTY_SET;
    private List recordClassFields;
    private List formClassFields;
    private boolean returnFunctionContainerFunctions = true;
    private Map level4Items;
    private Map level5Items;
    private Map level6Items;
    private Map usedEnumerationItems;
    private Map itemsWhoseNamesCanBeUnqualified;
    private Map recordsFormsAndDataTables;
    private Map usedLibraryFunctionBindings;
    private boolean hasDLIAnnotation;

    public FunctionContainerScope(Scope parentScope, FunctionContainerBinding functionContainerBinding) {
        super(parentScope);
        this.functionContainerBinding = functionContainerBinding;
        if (functionContainerBinding != null) {
            IAnnotationBinding annotation = functionContainerBinding.getAnnotation(InternUtil.intern((String[])new String[]{"egl", "core"}), InternUtil.intern((String)"AllowUnqualifiedItemReferences"));
            if (annotation != null && Boolean.YES == annotation.getValue()) {
                this.unqualifiedItemReferencesAreAllowed = true;
            }
            if ((annotation = functionContainerBinding.getAnnotation(InternUtil.intern((String[])new String[]{"egl", "core"}), InternUtil.intern((String)"IncludeReferencedFunctions"))) == null || annotation.getValue() == Boolean.NO) {
                this.stopReturningTopLevelFunctions();
            }
            if ((annotation = functionContainerBinding.getAnnotation(InternUtil.intern((String[])new String[]{"egl", "io", "dli"}), InternUtil.intern((String)"DLI"))) != null) {
                this.hasDLIAnnotation = true;
            }
            if ((annotation = functionContainerBinding.getAnnotation(InternUtil.intern((String[])new String[]{"egl", "core"}), InternUtil.intern((String)"I4GLItemsNullable"))) != null && Boolean.YES == annotation.getValue()) {
                this.I4GLItemsNullableIsEnabled = true;
            }
        }
    }

    public FunctionContainerScope(Scope parentScope, FunctionContainerScope fContainerScope) {
        super(parentScope);
        this.functionContainerBinding = fContainerScope.functionContainerBinding;
        this.unqualifiedItemReferencesAreAllowed = fContainerScope.unqualifiedItemReferencesAreAllowed;
        this.usedLibraries = fContainerScope.usedLibraries;
        this.usedDataTables = fContainerScope.usedDataTables;
        this.usedForms = fContainerScope.usedForms;
        this.recordClassFields = fContainerScope.recordClassFields;
        this.formClassFields = fContainerScope.formClassFields;
        this.returnFunctionContainerFunctions = fContainerScope.returnFunctionContainerFunctions;
        this.level4Items = fContainerScope.level4Items;
        this.level5Items = fContainerScope.level5Items;
        this.level6Items = fContainerScope.level6Items;
        this.usedEnumerationItems = fContainerScope.usedEnumerationItems;
        this.itemsWhoseNamesCanBeUnqualified = fContainerScope.itemsWhoseNamesCanBeUnqualified;
        this.recordsFormsAndDataTables = fContainerScope.recordsFormsAndDataTables;
        this.usedLibraryFunctionBindings = fContainerScope.usedLibraryFunctionBindings;
        this.hasDLIAnnotation = fContainerScope.hasDLIAnnotation;
        this.I4GLItemsNullableIsEnabled = fContainerScope.I4GLItemsNullableIsEnabled;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        IDataBinding result = this.functionContainerBinding.findData(simpleName);
        if (!(result == IBinding.NOT_FOUND_BINDING || 20 != result.getKind() && 23 != result.getKind() || this.returnFunctionContainerFunctions)) {
            result = IBinding.NOT_FOUND_BINDING;
        }
        if (result != IBinding.NOT_FOUND_BINDING) {
            return result;
        }
        if (this.usedForms != null) {
            for (FormBinding nextForm : this.usedForms) {
                if (nextForm.getName() != simpleName) continue;
                return nextForm.getStaticFormDataBinding();
            }
        }
        for (DataTableBinding usedTable : this.usedDataTables) {
            if (usedTable.getName() != simpleName) continue;
            return usedTable.getStaticDataTableDataBinding();
        }
        result = (IDataBinding)this.getLevel4Items().get(simpleName);
        if (result != null) {
            return result;
        }
        IDataBinding resultFromParent = this.findDataInParent(simpleName);
        if (IBinding.NOT_FOUND_BINDING != resultFromParent && 21 == resultFromParent.getKind()) {
            return resultFromParent;
        }
        result = (IDataBinding)this.getLevel5Items().get(simpleName);
        if (result != null && 20 == result.getKind() && !this.returnFunctionContainerFunctions) {
            result = IBinding.NOT_FOUND_BINDING;
        }
        if (result != null) {
            return result;
        }
        if (resultFromParent != IBinding.NOT_FOUND_BINDING && 3 == resultFromParent.getKind() && !this.hasDLIAnnotation && this.isDLIVarVariable(resultFromParent)) {
            return resultFromParent;
        }
        result = (IDataBinding)this.getUsedEnumerationItems().get(simpleName);
        if (result != null) {
            return result;
        }
        ITypeBinding type = this.findType(simpleName);
        if (type != null && type != IBinding.NOT_FOUND_BINDING) {
            if (type.getKind() == 5) {
                return ((DataTableBinding)type).getStaticDataTableDataBinding();
            }
            if (type.getKind() == 28) {
                return ((ExternalTypeBinding)type).getStaticExternalTypeDataBinding();
            }
        }
        for (LibraryBinding usedLibrary : this.usedLibraries) {
            if (usedLibrary.getName() != simpleName) continue;
            return usedLibrary.getStaticLibraryDataBinding();
        }
        if (resultFromParent != IBinding.NOT_FOUND_BINDING) {
            return resultFromParent;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    private IDataBinding findDataInParent(String simpleName) {
        IDataBinding binding = this.parentScope.findData(simpleName);
        if (IBinding.NOT_FOUND_BINDING != binding && AbstractBinder.typeIs(binding.getDeclaringPart(), new String[]{"egl", "io", "dli"}, "dliVar") && this.functionContainerBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "dli") == null) {
            binding = IBinding.NOT_FOUND_BINDING;
        }
        return binding;
    }

    private boolean isDLIVarVariable(IDataBinding dBinding) {
        IPartBinding declaringPart;
        IPartBinding iPartBinding = declaringPart = dBinding.isDataBindingWithImplicitQualifier() ? ((DataBindingWithImplicitQualifier)dBinding).getWrappedDataBinding().getDeclaringPart() : dBinding.getDeclaringPart();
        return declaringPart != null && InternUtil.intern((String[])new String[]{"egl", "io", "dli"}) == declaringPart.getPackageName() && InternUtil.intern((String)"dlivar") == declaringPart.getName();
    }

    @Override
    public IDataBinding findIOTargetData(String simpleName) {
        int resultTypeKind;
        IDataBinding result = this.functionContainerBinding.findData(simpleName);
        if (result != IBinding.NOT_FOUND_BINDING && (resultTypeKind = result.getType().getBaseType().getKind()) != 6 && resultTypeKind != 7) {
            result = IBinding.NOT_FOUND_BINDING;
        }
        if (this.usedForms != null) {
            for (FormBinding nextForm : this.usedForms) {
                if (nextForm.getName() != simpleName) continue;
                if (result == IBinding.NOT_FOUND_BINDING) {
                    result = nextForm.getStaticFormDataBinding();
                    break;
                }
                return AmbiguousDataBinding.getInstance();
            }
        }
        return result;
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        IFunctionBinding usedLibraryFunction;
        IFunctionBinding result = null;
        if (this.returnFunctionContainerFunctions && (result = this.functionContainerBinding.findFunction(simpleName)) != IBinding.NOT_FOUND_BINDING) {
            return result;
        }
        result = this.parentScope.findFunction(simpleName);
        IFunctionBinding iFunctionBinding = usedLibraryFunction = this.returnFunctionContainerFunctions ? (IFunctionBinding)this.getUsedLibraryFunctionBindings().get(simpleName) : null;
        if (usedLibraryFunction == null) {
            if (result != IBinding.NOT_FOUND_BINDING) {
                return result;
            }
        } else {
            if (result != IBinding.NOT_FOUND_BINDING && result.isSystemFunction()) {
                return usedLibraryFunction;
            }
            if (result != IBinding.NOT_FOUND_BINDING) {
                return result;
            }
            return usedLibraryFunction;
        }
        return result;
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public ITypeBinding findType(String simpleName) {
        ITypeBinding result = this.parentScope.findType(simpleName);
        if (IBinding.NOT_FOUND_BINDING != result && 11 == result.getKind() && result.getPackageName() == InternUtil.intern((String[])new String[]{"egl", "io", "dli"}) && result.getName() == InternUtil.intern((String)"DLIVar") && !this.hasDLIAnnotation) {
            result = IBinding.NOT_FOUND_BINDING;
        }
        return result;
    }

    public void addUsedLibrary(ITypeBinding usedLibraryBinding) {
        if (this.usedLibraries == Collections.EMPTY_LIST) {
            this.usedLibraries = new ArrayList();
        }
        this.usedLibraries.add(usedLibraryBinding);
    }

    void addUsedDataTable(ITypeBinding usedTableBinding) {
        if (this.usedDataTables == Collections.EMPTY_LIST) {
            this.usedDataTables = new ArrayList();
        }
        this.usedDataTables.add(usedTableBinding);
    }

    void addUsedEnumeration(ITypeBinding usedTableBinding) {
        if (this.usedEnumerations == Collections.EMPTY_LIST) {
            this.usedEnumerations = new ArrayList();
        }
        this.usedEnumerations.add(usedTableBinding);
    }

    public void setMainFormGroup(Set usedForms) {
        this.usedForms = usedForms;
    }

    @Override
    public boolean unqualifiedItemReferencesAreAllowed() {
        return this.unqualifiedItemReferencesAreAllowed;
    }

    @Override
    public boolean I4GLItemsNullableIsEnabled() {
        return this.I4GLItemsNullableIsEnabled;
    }

    private List getRecordClassFields() {
        if (this.recordClassFields == null) {
            this.recordClassFields = new ArrayList();
            for (IDataBinding nextVar : this.functionContainerBinding.getDeclaredData()) {
                int nextVarTypeKind = nextVar.getType().getKind();
                if (nextVarTypeKind != 7 && nextVarTypeKind != 6 && (nextVarTypeKind != 2 || nextVar.getType().getBaseType().getKind() != 6)) continue;
                this.recordClassFields.add(nextVar);
            }
        }
        return this.recordClassFields;
    }

    private Map getLevel4Items() {
        if (this.level4Items == null) {
            this.level4Items = new HashMap();
            if (this.unqualifiedItemReferencesAreAllowed()) {
                for (IDataBinding nextRecVar : this.getRecordClassFields()) {
                    BindingUtilities.addAllToUnqualifiedBindingNameMap(this.level4Items, nextRecVar, nextRecVar.getType().getSimpleNamesToDataBindingsMap());
                    BindingUtilities.addResourceAssociationBindingToMap(this.level4Items, nextRecVar);
                }
                if (this.usedForms != null) {
                    for (FormBinding nextForm : this.usedForms) {
                        BindingUtilities.addAllToUnqualifiedBindingNameMap(this.level4Items, nextForm.getStaticFormDataBinding(), nextForm.getSimpleNamesToDataBindingsMap());
                    }
                }
                for (DataTableBinding usedTable : this.usedDataTables) {
                    BindingUtilities.addAllToUnqualifiedBindingNameMap(this.level4Items, usedTable.getStaticDataTableDataBinding(), usedTable.getSimpleNamesToDataBindingsMap());
                }
            }
        }
        return this.level4Items;
    }

    private Map getLevel5Items() {
        if (this.level5Items == null) {
            this.level5Items = new HashMap();
            for (LibraryBinding nextLibrary : this.usedLibraries) {
                for (ClassFieldBinding next : nextLibrary.getDeclaredData()) {
                    if (next.isPrivate()) continue;
                    BindingUtilities.addToUnqualifiedBindingNameMap(this.level5Items, nextLibrary.getStaticLibraryDataBinding(), next);
                }
                HashMap<String, IDataBinding> functionNamesToBindings = new HashMap<String, IDataBinding>();
                for (NestedFunctionBinding next : nextLibrary.getDeclaredFunctions()) {
                    if (next.isPrivate()) continue;
                    if (functionNamesToBindings.containsKey(next.getName())) {
                        OverloadedFunctionSet functionSet;
                        IDataBinding existingFunction = (IDataBinding)functionNamesToBindings.get(next.getName());
                        if (20 == existingFunction.getKind()) {
                            functionSet = new OverloadedFunctionSet();
                            functionSet.setName(next.getCaseSensitiveName());
                            functionSet.addNestedFunctionBinding(existingFunction);
                        } else {
                            functionSet = (OverloadedFunctionSet)existingFunction;
                        }
                        functionSet.addNestedFunctionBinding(next);
                        functionNamesToBindings.put(next.getName(), functionSet);
                        continue;
                    }
                    functionNamesToBindings.put(next.getName(), next);
                }
                Iterator<Object> dataIter = functionNamesToBindings.values().iterator();
                while (dataIter.hasNext()) {
                    BindingUtilities.addToUnqualifiedBindingNameMap(this.level5Items, nextLibrary.getStaticLibraryDataBinding(), (IDataBinding)dataIter.next());
                }
            }
        }
        return this.level5Items;
    }

    private Map getUsedEnumerationItems() {
        if (this.usedEnumerationItems == null) {
            this.usedEnumerationItems = new HashMap();
            for (EnumerationTypeBinding nextEnumeration : this.usedEnumerations) {
                for (EnumerationDataBinding next : nextEnumeration.getEnumerations()) {
                    BindingUtilities.addToUnqualifiedBindingNameMap(this.usedEnumerationItems, nextEnumeration.getStaticEnumerationTypeDataBinding(), next);
                }
            }
        }
        return this.usedEnumerationItems;
    }

    private Map getUsedLibraryFunctionBindings() {
        if (this.usedLibraryFunctionBindings == null) {
            this.usedLibraryFunctionBindings = new HashMap();
            for (LibraryBinding nextLibrary : this.usedLibraries) {
                Iterator functionIter = nextLibrary.getDeclaredFunctions().iterator();
                while (functionIter.hasNext()) {
                    BindingUtilities.addToUnqualifiedFunctionNameMap(this.usedLibraryFunctionBindings, (IFunctionBinding)((NestedFunctionBinding)functionIter.next()).getType(), nextLibrary.getStaticLibraryDataBinding());
                }
            }
        }
        return this.usedLibraryFunctionBindings;
    }

    @Override
    public Scope getScopeForKeywordThis() {
        return this;
    }

    @Override
    public void stopReturningFunctionContainerFunctions() {
        super.stopReturningFunctionContainerFunctions();
        this.returnFunctionContainerFunctions = false;
    }

    @Override
    public void startReturningFunctionContainerFunctions() {
        super.startReturningFunctionContainerFunctions();
        this.returnFunctionContainerFunctions = true;
    }

    public List getUsedLibraries() {
        return this.usedLibraries;
    }

    @Override
    public IPartBinding getPartBinding() {
        return this.functionContainerBinding;
    }

    public Map getItemsWhoseNamesCanBeUnqualified() {
        if (this.itemsWhoseNamesCanBeUnqualified == null) {
            this.itemsWhoseNamesCanBeUnqualified = new HashMap();
            if (this.unqualifiedItemReferencesAreAllowed()) {
                for (IDataBinding nextRecVar : this.getRecordClassFields()) {
                    for (IDataBinding next : nextRecVar.getType().getSimpleNamesToDataBindingsMap().values()) {
                        this.itemsWhoseNamesCanBeUnqualified.put(next.getName(), next);
                    }
                }
                if (this.usedForms != null) {
                    for (FormBinding nextForm : this.usedForms) {
                        for (IDataBinding next : nextForm.getSimpleNamesToDataBindingsMap().values()) {
                            this.itemsWhoseNamesCanBeUnqualified.put(next.getName(), next);
                        }
                    }
                }
                for (DataTableBinding usedTable : this.usedDataTables) {
                    for (IDataBinding next : usedTable.getSimpleNamesToDataBindingsMap().values()) {
                        this.itemsWhoseNamesCanBeUnqualified.put(next.getName(), next);
                    }
                }
            }
        }
        return this.itemsWhoseNamesCanBeUnqualified;
    }

    public Map getRecordsFormsAndDataTables() {
        if (this.recordsFormsAndDataTables == null) {
            this.recordsFormsAndDataTables = new HashMap();
            for (IDataBinding next : this.getRecordClassFields()) {
                this.recordsFormsAndDataTables.put(next.getName(), next);
            }
            if (this.usedForms != null) {
                for (FormBinding nextForm : this.usedForms) {
                    this.recordsFormsAndDataTables.put(nextForm.getName(), nextForm.getStaticFormDataBinding());
                }
            }
            for (DataTableBinding usedTable : this.usedDataTables) {
                this.recordsFormsAndDataTables.put(usedTable.getName(), usedTable.getStaticDataTableDataBinding());
            }
        }
        return this.recordsFormsAndDataTables;
    }
}

