/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import org.eclipse.edt.compiler.binding.AmbiguousDataBinding;
import org.eclipse.edt.compiler.binding.AmbiguousFunctionBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.TopLevelFunctionBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class SystemScope
extends Scope {
    private IEnvironment sysEnvironment = null;

    public SystemScope(Scope parentScope, IEnvironment env) {
        super(parentScope);
        this.sysEnvironment = env;
    }

    @Override
    public ITypeBinding findType(String simpleName) {
        ITypeBinding result = this.parentScope.findType(simpleName);
        if (result != IBinding.NOT_FOUND_BINDING) {
            return result;
        }
        result = this.sysEnvironment.getPartBinding(null, simpleName);
        if (result != null) {
            return result;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        IFunctionBinding result = this.parentScope.findFunction(simpleName);
        if (result != IBinding.NOT_FOUND_BINDING) {
            return result;
        }
        result = this.sysEnvironment.getSystemEnvironment().getSystemLibraryManager().findFunction(simpleName);
        if (result == null) {
            result = IBinding.NOT_FOUND_BINDING;
        }
        if (result != IBinding.NOT_FOUND_BINDING) {
            return result;
        }
        return result;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        IFunctionBinding topLevelFunctionBinding = this.parentScope.findFunction(simpleName);
        if (topLevelFunctionBinding == AmbiguousFunctionBinding.getInstance()) {
            return AmbiguousDataBinding.getInstance();
        }
        if (topLevelFunctionBinding != IBinding.NOT_FOUND_BINDING) {
            return ((TopLevelFunctionBinding)topLevelFunctionBinding).getStaticTopLevelFunctionDataBinding();
        }
        IDataBinding result = this.sysEnvironment.getSystemEnvironment().getSystemLibraryManager().findData(simpleName);
        if (result != null) {
            return result;
        }
        result = this.sysEnvironment.getSystemEnvironment().getEnumerationManager().findData(simpleName);
        if (result != null) {
            return result;
        }
        return this.parentScope.findData(simpleName);
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public boolean isSystemScope() {
        return true;
    }
}

