/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.AS400ArrayAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AbstractAS400ParameterAnnotaionValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IBMiProgramParameterAnnotationsValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IBMiProgramValidator;

public class AS400ArrayValidator
extends AbstractAS400ParameterAnnotaionValidator {
    @Override
    public void validate(IAnnotationBinding annotation, Node errorNode, ITypeBinding targetTypeBinding, IProblemRequestor problemRequestor) {
        super.validate(annotation, errorNode, targetTypeBinding, problemRequestor);
        if (Binding.isValidBinding(targetTypeBinding) && this.isValidType(targetTypeBinding)) {
            if (this.getElementType(annotation) == null) {
                this.validateElementTypeNotRequired((ArrayTypeBinding)targetTypeBinding, errorNode, problemRequestor);
                this.validateElementTypeNotNullable((ArrayTypeBinding)targetTypeBinding, errorNode, problemRequestor);
            } else {
                this.validateElementType(annotation, (ArrayTypeBinding)targetTypeBinding, errorNode, problemRequestor);
            }
            this.validateReturnCount(annotation, errorNode, problemRequestor);
        }
    }

    private boolean isCompatibleWithINT(ITypeBinding type) {
        if (3 != type.getKind()) {
            return false;
        }
        return TypeCompatibilityUtil.isMoveCompatible(PrimitiveTypeBinding.getInstance(Primitive.INT), (PrimitiveTypeBinding)type);
    }

    protected void validateReturnCount(IAnnotationBinding ann, Node errorNode, IProblemRequestor problemRequestor) {
        Object obj = this.getReturnCount(ann);
        if (obj == null || !(obj instanceof Name)) {
            return;
        }
        IDataBinding db = ((Name)obj).resolveDataBinding();
        if (!Binding.isValidBinding(db) || !Binding.isValidBinding(db.getType())) {
            return;
        }
        if (!this.isCompatibleWithINT(db.getType())) {
            problemRequestor.acceptProblem(errorNode, 5713, new String[]{db.getCaseSensitiveName()});
        }
        if (db.getKind() == 0) {
            return;
        }
        IBinding containerBinding = this.getContainerBinding(errorNode);
        if (containerBinding == db.getDeclaringPart()) {
            return;
        }
        problemRequestor.acceptProblem(errorNode, 5714, new String[]{db.getCaseSensitiveName()});
    }

    private IBinding getContainerBinding(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Part) {
            return ((Part)node).getName().resolveBinding();
        }
        if (node instanceof NestedFunction) {
            return ((NestedFunction)node).getName().resolveBinding();
        }
        return this.getContainerBinding(node.getParent());
    }

    protected void validateElementTypeNotNullable(ArrayTypeBinding targetTypeBinding, Node errorNode, IProblemRequestor problemRequestor) {
        if (Binding.isValidBinding(targetTypeBinding.getElementType()) && targetTypeBinding.getElementType().isNullable()) {
            problemRequestor.acceptProblem(errorNode, 5716, new String[]{this.getName(), String.valueOf(targetTypeBinding.getElementType().getCaseSensitiveName()) + "?"});
        }
    }

    protected void validateElementTypeNotRequired(ArrayTypeBinding targetTypeBinding, Node errorNode, IProblemRequestor problemRequestor) {
        if (IBMiProgramValidator.requiresAS400TypeAnnotation(targetTypeBinding.getElementType())) {
            problemRequestor.acceptProblem(errorNode, 5710, new String[]{"elementTypeAS400Annotation", this.getName()});
        }
    }

    protected void validateElementType(IAnnotationBinding ann, ArrayTypeBinding targetTypeBinding, Node errorNode, IProblemRequestor problemRequestor) {
        Object obj = this.getElementType(ann);
        AbstractAS400ParameterAnnotaionValidator validator = IBMiProgramParameterAnnotationsValidator.getValidator(obj);
        if (validator == null) {
            problemRequestor.acceptProblem(errorNode, 5712, new String[0]);
        } else {
            validator.validate((IAnnotationBinding)obj, errorNode, targetTypeBinding.getElementType(), problemRequestor);
        }
    }

    protected Object getElementType(IAnnotationBinding annotation) {
        return this.getValue(annotation, "elementTypeAS400Annotation");
    }

    protected Object getReturnCount(IAnnotationBinding annotation) {
        return this.getValue(annotation, "returnCountVariable");
    }

    @Override
    protected List<Primitive> getSupportedTypes() {
        return new ArrayList<Primitive>();
    }

    @Override
    protected String getName() {
        return AS400ArrayAnnotationTypeBinding.caseSensitiveName;
    }

    @Override
    protected String getInternedName() {
        return AS400ArrayAnnotationTypeBinding.name;
    }

    @Override
    protected boolean isValidType(ITypeBinding typeBinding) {
        if (Binding.isValidBinding(typeBinding)) {
            if (2 == typeBinding.getKind()) {
                return IBMiProgramValidator.isValidAS400Type(typeBinding);
            }
            return false;
        }
        return true;
    }
}

