/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.AS400TimestampAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AbstractAS400ParameterAnnotaionValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.PrimitiveTypeValidator;

public class AS400TimestampValidator
extends AbstractAS400ParameterAnnotaionValidator {
    @Override
    public void validate(IAnnotationBinding annotation, Node errorNode, ITypeBinding targetTypeBinding, IProblemRequestor problemRequestor) {
        super.validate(annotation, errorNode, targetTypeBinding, problemRequestor);
        if (Binding.isValidBinding(targetTypeBinding) && this.isValidType(targetTypeBinding)) {
            if (((PrimitiveTypeBinding)targetTypeBinding).getPattern() != null && ((PrimitiveTypeBinding)targetTypeBinding).getPattern().length() > 0) {
                this.validatePatternNotSpecified(annotation, errorNode, problemRequestor);
            } else {
                this.validatePatternSpecified(annotation, errorNode, problemRequestor);
                this.validatePattern(annotation, errorNode, problemRequestor);
            }
        }
    }

    private void validatePattern(IAnnotationBinding ann, Node errorNode, IProblemRequestor problemRequestor) {
        PrimitiveTypeValidator.DateTimePattern dtPat;
        String pattern = this.getPattern(ann);
        if (pattern != null && !(dtPat = new PrimitiveTypeValidator.DateTimePattern(pattern)).isValidTimeStampPattern()) {
            Integer[] errors = dtPat.getErrorMessageNumbers();
            int i = 0;
            while (i < errors.length) {
                problemRequestor.acceptProblem(errorNode, (int)errors[i], new String[]{pattern});
                ++i;
            }
        }
    }

    protected void validatePatternNotSpecified(IAnnotationBinding ann, Node errorNode, IProblemRequestor problemRequestor) {
        if (this.getPattern(ann) != null) {
            problemRequestor.acceptProblem(errorNode, 5711, new String[]{"eglPattern", this.getName()});
        }
    }

    protected void validatePatternSpecified(IAnnotationBinding ann, Node errorNode, IProblemRequestor problemRequestor) {
        if (this.getPattern(ann) == null) {
            problemRequestor.acceptProblem(errorNode, 5710, new String[]{"eglPattern", this.getName()});
        }
    }

    protected String getPattern(IAnnotationBinding annotation) {
        return (String)this.getValue(annotation, "eglPattern");
    }

    @Override
    protected List<Primitive> getSupportedTypes() {
        ArrayList<Primitive> list = new ArrayList<Primitive>();
        list.add(Primitive.TIMESTAMP);
        return list;
    }

    @Override
    protected String getName() {
        return AS400TimestampAnnotationTypeBinding.caseSensitiveName;
    }

    @Override
    protected String getInternedName() {
        return AS400TimestampAnnotationTypeBinding.name;
    }
}

