/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AbstractAnnotationValidator;

public class LengthItemAnnotationValidator
extends AbstractAnnotationValidator {
    public LengthItemAnnotationValidator(AnnotationExpression annotation, ITypeBinding type, IProblemRequestor problemRequestor) {
        super(annotation, type, problemRequestor);
    }

    @Override
    public void validate() {
        if (this.type.getKind() == 3) {
            this.validateType((PrimitiveTypeBinding)this.type);
            this.validateDecimals((PrimitiveTypeBinding)this.type);
            this.validateLength((PrimitiveTypeBinding)this.type);
        }
    }

    private void validateDecimals(PrimitiveTypeBinding primType) {
        if (primType.getDecimals() != 0) {
            this.problemRequestor.acceptProblem(this.annotation, 3220);
        }
    }

    private void validateLength(PrimitiveTypeBinding primType) {
        if (primType.getLength() > 9) {
            this.problemRequestor.acceptProblem(this.annotation, 3219);
        }
    }

    private void validateType(PrimitiveTypeBinding primType) {
        Primitive primitive = primType.getPrimitive();
        if (primitive != Primitive.BIN || primitive != Primitive.NUM || primitive != Primitive.NUMC || primitive != Primitive.PACF || primitive != Primitive.DECIMAL || primitive != Primitive.INT || primitive != Primitive.SMALLINT) {
            this.problemRequestor.acceptProblem(this.annotation, 3218);
        }
    }
}

