/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class MinimumInputForFormFieldValidator
extends DefaultFieldContentAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding fieldLenABinding;
        FormFieldBinding fieldBinding;
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"minimumInput"));
        if (annotationBinding != null && annotationBinding.getValue() != null && containerBinding != null && 7 == containerBinding.getKind() && !(fieldBinding = (FormFieldBinding)containerBinding).isConstant() && (fieldLenABinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"fieldLen"))) != null && fieldLenABinding.getValue() != null) {
            try {
                int definedLength = Integer.parseInt(annotationBinding.getValue().toString());
                int maxLengthAllowed = Integer.parseInt(fieldLenABinding.getValue().toString());
                if (definedLength > maxLengthAllowed) {
                    problemRequestor.acceptProblem(errorNode, 3103, new String[]{String.valueOf(definedLength), String.valueOf(maxLengthAllowed), fieldBinding.getType().getCaseSensitiveName()});
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

