/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class XXXrestValidator
implements IAnnotationValidationRule {
    private Map allAnnotations;
    private HashMap parmNamesToNodes = new HashMap();
    private HashMap namesToSubstitutionVars = new HashMap();
    private Node errorNode;
    private Node uriTemplateNode;
    private Node responseFormatNode;
    private Node requestFormatNode;

    private boolean isResourceType(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        if (this.getResponseFormat() == InternUtil.intern((String)"json") && type.getKind() == 2) {
            type = ((ArrayTypeBinding)type).getElementType();
        }
        if (type.getKind() == 3) {
            return ((PrimitiveTypeBinding)type).getPrimitive() == Primitive.STRING;
        }
        return type.getKind() == 7;
    }

    private boolean isIn(FunctionParameter parm) {
        if (parm.getName().resolveBinding() instanceof FunctionParameterBinding) {
            return ((FunctionParameterBinding)parm.getName().resolveBinding()).isInput();
        }
        return parm.getUseType() == FunctionParameter.UseType.IN;
    }

    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.errorNode = errorNode;
        this.allAnnotations = allAnnotations;
        final boolean[] isFunction = new boolean[1];
        final Type[] returnType = new Type[1];
        final ArrayList parms = new ArrayList();
        final String[] funcName = new String[1];
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                isFunction[0] = true;
                if (nestedFunction.hasReturnType()) {
                    returnType[0] = nestedFunction.getReturnType();
                }
                parms.addAll(nestedFunction.getFunctionParameters());
                funcName[0] = nestedFunction.getName().getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(TopLevelFunction topLevelFunction) {
                isFunction[0] = true;
                if (topLevelFunction.hasReturnType()) {
                    returnType[0] = topLevelFunction.getReturnType();
                }
                parms.addAll(topLevelFunction.getFunctionParameters());
                funcName[0] = topLevelFunction.getName().getCanonicalName();
                return false;
            }
        };
        target.accept(visitor);
        if (!isFunction[0]) {
            return;
        }
        final boolean[] inInterface = new boolean[1];
        target.getParent().accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(Interface interfaceNode) {
                inInterface[0] = true;
                return false;
            }
        });
        if (!inInterface[0]) {
            problemRequestor.acceptProblem(errorNode, 2058, 2, new String[]{this.getName()});
        }
        for (FunctionParameter parm : parms) {
            this.parmNamesToNodes.put(parm.getName().getCanonicalName().toUpperCase().toLowerCase(), parm);
            if (this.isIn(parm)) continue;
            problemRequestor.acceptProblem(parm, 3401, 2, new String[]{parm.getName().getCanonicalName(), funcName[0], this.getName()});
        }
        if (returnType[0] != null && Binding.isValidBinding(returnType[0].resolveTypeBinding())) {
            if (!this.isResourceType(returnType[0].resolveTypeBinding())) {
                problemRequestor.acceptProblem(returnType[0], 3403, 2, new String[]{funcName[0], this.getName()});
            }
            if (returnType[0].resolveTypeBinding() == PrimitiveTypeBinding.getInstance(Primitive.STRING)) {
                this.getRequestFormat();
                String respForm = this.getResponseFormat();
                if (respForm != null && InternUtil.intern((String)"none") != respForm) {
                    problemRequestor.acceptProblem(this.getResponseFormatNode(), 3407, 2, new String[]{"responseFormat"});
                }
            }
        }
        this.parseSubtitutionVars();
        boolean foundResourceParm = false;
        for (String key : this.parmNamesToNodes.keySet()) {
            FunctionParameter parm = (FunctionParameter)this.parmNamesToNodes.get(key);
            if (this.namesToSubstitutionVars.get(key) == null) {
                if (this.supportsResourceParm()) {
                    ITypeBinding type;
                    if (foundResourceParm) {
                        problemRequestor.acceptProblem(parm, 3402, 2, new String[]{funcName[0], this.getName(), parm.getName().getCanonicalName()});
                        continue;
                    }
                    foundResourceParm = true;
                    if (!Binding.isValidBinding(parm.getType().resolveTypeBinding())) continue;
                    if (!this.isResourceType(parm.getType().resolveTypeBinding())) {
                        problemRequestor.acceptProblem(parm.getType(), 3406, 2, new String[]{parm.getName().getCanonicalName(), funcName[0], this.getName()});
                        continue;
                    }
                    if (parm.getType().resolveTypeBinding() == PrimitiveTypeBinding.getInstance(Primitive.STRING)) {
                        String reqForm = this.getRequestFormat();
                        this.getResponseFormat();
                        if (reqForm != null && InternUtil.intern((String)"none") != reqForm) {
                            problemRequestor.acceptProblem(this.getRequestFormatNode(), 3407, 2, new String[]{"requestFormat"});
                        }
                    }
                    if (InternUtil.intern((String)"formdata") != this.getRequestFormat() || this.isFlatRecord(type = parm.getType().resolveTypeBinding())) continue;
                    problemRequestor.acceptProblem(parm.getType(), 3409, 2, new String[]{parm.getName().getCanonicalName(), funcName[0]});
                    continue;
                }
                problemRequestor.acceptProblem(parm, 3411, 2, new String[]{funcName[0], this.getName(), parm.getName().getCanonicalName()});
                continue;
            }
            if (!Binding.isValidBinding(parm.getType().resolveTypeBinding()) || TypeCompatibilityUtil.isMoveCompatible(PrimitiveTypeBinding.getInstance(Primitive.STRING), parm.getType().resolveTypeBinding(), null, compilerOptions)) continue;
            problemRequestor.acceptProblem(parm.getType(), 3404, 2, new String[]{parm.getName().getCanonicalName(), funcName[0], this.getName()});
        }
        for (String key : this.namesToSubstitutionVars.keySet()) {
            SubstitutionVar var = (SubstitutionVar)this.namesToSubstitutionVars.get(key);
            int absStart = this.getUriTemplateNode().getOffset() + 1;
            FunctionParameter parm = (FunctionParameter)this.parmNamesToNodes.get(key);
            if (parm != null) continue;
            problemRequestor.acceptProblem(absStart + var.getStartOffset(), absStart + var.getEndOffset(), 2, 3405, new String[]{var.getVarName(), funcName[0]});
        }
        if (this.getResponseFormat() == InternUtil.intern((String)"formData")) {
            problemRequestor.acceptProblem(this.getResponseFormatNode(), 3408, 2, new String[]{this.getResponseFormat(), "responseFormat"});
        }
    }

    private boolean isFlatRecord(ITypeBinding binding) {
        if (!Binding.isValidBinding(binding)) {
            return false;
        }
        if (binding.getKind() != 7) {
            return false;
        }
        FlexibleRecordBinding flexRec = (FlexibleRecordBinding)binding;
        IDataBinding[] fields = flexRec.getFields();
        int i = 0;
        while (i < fields.length) {
            if (Binding.isValidBinding(fields[i].getType()) && Binding.isValidBinding(fields[i].getType().getBaseType()) && fields[i].getType().getBaseType().getKind() == 7) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Node getRequestFormatNode() {
        if (this.requestFormatNode == null) {
            this.requestFormatNode = this.getAnnotationValueNode("requestFormat");
        }
        return this.requestFormatNode;
    }

    private Node getResponseFormatNode() {
        if (this.responseFormatNode == null) {
            this.responseFormatNode = this.getAnnotationValueNode("responseFormat");
        }
        return this.responseFormatNode;
    }

    private String getRequestFormat() {
        IAnnotationBinding binding = (IAnnotationBinding)this.allAnnotations.get(InternUtil.intern((String)"requestFormat"));
        if (binding == null) {
            return null;
        }
        return ((IDataBinding)binding.getValue()).getName();
    }

    private String getResponseFormat() {
        IAnnotationBinding binding = (IAnnotationBinding)this.allAnnotations.get(InternUtil.intern((String)"responseFormat"));
        if (binding == null) {
            return null;
        }
        return ((IDataBinding)binding.getValue()).getName();
    }

    private Node getUriTemplateNode() {
        if (this.uriTemplateNode == null) {
            this.uriTemplateNode = this.getAnnotationValueNode("uriTemplate");
        }
        return this.uriTemplateNode;
    }

    private Node getAnnotationValueNode(String annName) {
        final Node[] result = new Node[1];
        final String name = InternUtil.intern((String)annName);
        this.errorNode.getParent().accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(Assignment assignment) {
                if (assignment.resolveBinding() != null && assignment.resolveBinding().getName() == name) {
                    result[0] = assignment.getRightHandSide();
                }
                return false;
            }
        });
        return result[0];
    }

    private void parseSubtitutionVars() {
        IAnnotationBinding uriTempAnn = (IAnnotationBinding)this.allAnnotations.get(InternUtil.intern((String)"uriTemplate"));
        if (uriTempAnn == null) {
            return;
        }
        String value = (String)uriTempAnn.getValue();
        char[] chars = value.toCharArray();
        int lOffset = 0;
        boolean lookingForL = true;
        int i = 0;
        while (i < chars.length) {
            if (lookingForL) {
                if (chars[i] == '{') {
                    lOffset = i;
                    lookingForL = false;
                }
            } else if (chars[i] == '}') {
                SubstitutionVar var = new SubstitutionVar(lOffset + 1, i, value);
                this.namesToSubstitutionVars.put(var.getVarName().toUpperCase().toLowerCase(), var);
                lookingForL = true;
            }
            ++i;
        }
    }

    protected abstract String getName();

    protected boolean supportsResourceParm() {
        return true;
    }

    private static class SubstitutionVar {
        int startOffset;
        int endOffset;
        String varName;

        public SubstitutionVar(int startOffset, int endOffset, String uriTemplate) {
            this.endOffset = endOffset;
            this.startOffset = startOffset;
            this.varName = uriTemplate.substring(startOffset, endOffset);
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String getVarName() {
            return this.varName;
        }
    }
}

