/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.edt.compiler.binding.AnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.CharLiteral;
import org.eclipse.edt.compiler.core.ast.DBCharLiteral;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.DecimalLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.HexLiteral;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.MBCharLiteral;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FixedStructureValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class DataTableValidator
extends FixedStructureValidator {
    private static Set validCharactersForHexContent = new HashSet<Character>(Arrays.asList(new Character('0'), new Character('a'), new Character('A'), new Character('1'), new Character('b'), new Character('B'), new Character('2'), new Character('c'), new Character('C'), new Character('3'), new Character('d'), new Character('D'), new Character('4'), new Character('e'), new Character('E'), new Character('5'), new Character('f'), new Character('F'), new Character('6'), new Character('7'), new Character('8'), new Character('9')));
    private Map primitivesToContentCheckers = null;
    DataTable tableNode;

    private ContentToPrimitiveTypeChecker getChecker(Primitive prim) {
        if (this.primitivesToContentCheckers == null) {
            this.primitivesToContentCheckers = new HashMap();
            this.primitivesToContentCheckers.put(Primitive.BIGINT, new ContentToFixedLengthNumericTypeChecker(Primitive.BIGINT.getDefaultLength()));
            this.primitivesToContentCheckers.put(Primitive.SMALLINT, new ContentToFixedLengthNumericTypeChecker(Primitive.SMALLINT.getDefaultLength()));
            this.primitivesToContentCheckers.put(Primitive.INT, new ContentToFixedLengthNumericTypeChecker(Primitive.INT.getDefaultLength()));
            this.primitivesToContentCheckers.put(Primitive.BIN, new ContentToUserDefinedLengthAndDecimalTypeChecker());
            this.primitivesToContentCheckers.put(Primitive.NUM, new ContentToUserDefinedLengthAndDecimalTypeChecker());
            this.primitivesToContentCheckers.put(Primitive.NUMC, new ContentToUserDefinedLengthAndDecimalTypeChecker());
            this.primitivesToContentCheckers.put(Primitive.PACF, new ContentToUserDefinedLengthAndDecimalTypeChecker());
            this.primitivesToContentCheckers.put(Primitive.DECIMAL, new ContentToUserDefinedLengthAndDecimalTypeChecker());
            this.primitivesToContentCheckers.put(Primitive.CHAR, new ContentToCharacterTypeChecker(null, null));
            this.primitivesToContentCheckers.put(Primitive.UNICODE, new ContentToCharacterTypeChecker(null, null));
            this.primitivesToContentCheckers.put(Primitive.DBCHAR, new ContentToDBCharTypeChecker());
            this.primitivesToContentCheckers.put(Primitive.HEX, new ContentToHexTypeChecker());
            this.primitivesToContentCheckers.put(Primitive.BOOLEAN, new ContentToBooleanTypeChecker());
        }
        return (ContentToPrimitiveTypeChecker)this.primitivesToContentCheckers.get(prim);
    }

    public DataTableValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(problemRequestor, compilerOptions);
        this.sItemValidatorFactory = this.getItemValidatorFactory();
    }

    @Override
    public boolean visit(DataTable dataTable) {
        this.tableNode = dataTable;
        this.canonicalStructureName = dataTable.getName().getCanonicalName();
        this.structureBinding = (FixedStructureBinding)dataTable.getName().resolveBinding();
        this.sItemValidatorFactory = this.getItemValidatorFactory();
        EGLNameValidator.validate(dataTable.getName(), 8, this.problemRequestor, this.compilerOptions);
        return true;
    }

    @Override
    public void endVisit(DataTable dataTable) {
        if (this.structureBinding != null) {
            Column[] columns = this.buildColumns(this.structureBinding);
            ContentsAnnotationChecker cAnnotationChecker = new ContentsAnnotationChecker(columns);
            dataTable.accept(cAnnotationChecker);
            if (!cAnnotationChecker.foundContents) {
                this.problemRequestor.acceptProblem((Node)dataTable.getName(), 5003, new String[]{this.canonicalStructureName});
            }
            this.checkNumberOfColumnsCorrect(columns.length);
        }
    }

    private void checkNumberOfColumnsCorrect(int numColumns) {
        IPartSubTypeAnnotationTypeBinding subType = this.structureBinding.getSubType();
        if (AbstractBinder.annotationIs(subType, new String[]{"egl", "core"}, "MatchValidTable")) {
            this.checkNumberOfColumnsCorrect(1, numColumns, 4176);
        } else if (AbstractBinder.annotationIs(subType, new String[]{"egl", "core"}, "MatchInValidTable")) {
            this.checkNumberOfColumnsCorrect(1, numColumns, 4175);
        } else if (AbstractBinder.annotationIs(subType, new String[]{"egl", "core"}, "MsgTable")) {
            this.checkNumberOfColumnsCorrect(2, numColumns, 4181);
        } else if (AbstractBinder.annotationIs(subType, new String[]{"egl", "core"}, "RangeChkTable")) {
            this.checkNumberOfColumnsCorrect(2, numColumns, 4177);
        }
    }

    private void checkNumberOfColumnsCorrect(int minimumColumnsRequired, int numColumns, int problemKindIfIncorrect) {
        if (numColumns < minimumColumnsRequired) {
            this.problemRequestor.acceptProblem((Node)this.tableNode.getName(), problemKindIfIncorrect, new String[]{this.canonicalStructureName});
        }
    }

    private Column[] buildColumns(FixedStructureBinding structureBinding) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (StructureItemBinding nextItem : structureBinding.getStructureItems()) {
            columns.add(new Column(nextItem.getCaseSensitiveName(), (PrimitiveTypeBinding)nextItem.getType()));
        }
        return columns.toArray(new Column[0]);
    }

    @Override
    public boolean visit(StructureItem structureItem) {
        super.visit(structureItem);
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        super.visit(settingsBlock);
        return false;
    }

    private FixedStructureValidator.StructureItemValidatorFactory getItemValidatorFactory() {
        return new DefaultDataTableItemValidatorFactory();
    }

    private static class Column {
        PrimitiveTypeBinding columnType;
        String columnName;

        Column(String columnName, PrimitiveTypeBinding columnType) {
            this.columnType = columnType;
            this.columnName = columnName;
        }
    }

    private class ContentToBooleanTypeChecker
    extends ContentToPrimitiveTypeChecker {
        private ContentToBooleanTypeChecker() {
        }

        @Override
        boolean checkBooleanLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            return true;
        }

        @Override
        boolean checkStringLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5028, new String[]{content, DataTableValidator.this.canonicalStructureName});
            return false;
        }

        @Override
        boolean checkNumericLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5028, new String[]{content, DataTableValidator.this.canonicalStructureName});
            return false;
        }
    }

    private class ContentToCharacterTypeChecker
    extends ContentToPrimitiveTypeChecker {
        private ContentToCharacterTypeChecker() {
        }

        @Override
        boolean checkNumericLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            return this.checkStringLiteralContent(content, primTypeBinding, nodeForErrors);
        }

        @Override
        boolean checkStringLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            if (content.length() > primTypeBinding.getLength()) {
                DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5023, new String[]{content, DataTableValidator.this.canonicalStructureName, primTypeBinding.getPrimitive().getName(), Integer.toString(primTypeBinding.getLength()), Integer.toString(content.length())});
                return false;
            }
            return true;
        }

        @Override
        boolean checkBooleanLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5026, new String[]{content, DataTableValidator.this.canonicalStructureName});
            return false;
        }

        /* synthetic */ ContentToCharacterTypeChecker(ContentToCharacterTypeChecker contentToCharacterTypeChecker, ContentToCharacterTypeChecker contentToCharacterTypeChecker2) {
            this();
        }
    }

    private class ContentToDBCharTypeChecker
    extends ContentToCharacterTypeChecker {
        private ContentToDBCharTypeChecker() {
        }

        @Override
        boolean checkStringLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            if (!super.checkStringLiteralContent(content, primTypeBinding, nodeForErrors)) {
                return false;
            }
            char[] chars = content.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char[] originalChar = new char[]{chars[i]};
                String originalContents = new String(originalChar);
                byte[] contentBytes = originalContents.getBytes();
                String newContents = new String(contentBytes);
                if (!originalContents.equals(newContents)) {
                    DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5019, new String[]{content, DataTableValidator.this.canonicalStructureName});
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private class ContentToFixedLengthNumericTypeChecker
    extends ContentToNumericTypeChecker {
        int maxDigits;

        public ContentToFixedLengthNumericTypeChecker(int maxDigits) {
            this.maxDigits = maxDigits;
        }

        @Override
        boolean checkNumericLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            int decimalLoc;
            int contentLength = content.length();
            if (content.startsWith("-")) {
                --contentLength;
            }
            if ((decimalLoc = content.indexOf(46)) != -1) {
                contentLength -= content.length() - decimalLoc;
            }
            if (contentLength > this.maxDigits) {
                DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5023, new String[]{content, DataTableValidator.this.canonicalStructureName, primTypeBinding.getPrimitive().getName(), Integer.toString(this.maxDigits), Integer.toString(contentLength)});
                return false;
            }
            return true;
        }
    }

    private class ContentToHexTypeChecker
    extends ContentToCharacterTypeChecker {
        private ContentToHexTypeChecker() {
        }

        @Override
        boolean checkStringLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            if (!super.checkStringLiteralContent(content, primTypeBinding, nodeForErrors)) {
                return false;
            }
            char[] chars = content.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (!validCharactersForHexContent.contains(new Character(chars[i]))) {
                    DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5022, new String[]{content, DataTableValidator.this.canonicalStructureName, String.valueOf(chars[i])});
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private abstract class ContentToNumericTypeChecker
    extends ContentToPrimitiveTypeChecker {
        private ContentToNumericTypeChecker() {
        }

        @Override
        boolean checkStringLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            int firstChar = 0;
            char[] chars = content.toCharArray();
            boolean foundDecimal = false;
            boolean hasMultipleDecimals = false;
            Character invalidChar = null;
            if (content.startsWith("-")) {
                firstChar = 1;
            }
            int i = firstChar;
            while (i < chars.length) {
                char ch = chars[i];
                if ('.' == ch) {
                    if (foundDecimal) {
                        hasMultipleDecimals = true;
                    } else {
                        foundDecimal = true;
                    }
                } else if (invalidChar == null && !Character.isDigit(ch)) {
                    invalidChar = new Character(ch);
                }
                ++i;
            }
            if (hasMultipleDecimals) {
                DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5027, new String[]{content, DataTableValidator.this.canonicalStructureName});
                return false;
            }
            if (invalidChar != null) {
                DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5020, new String[]{content, DataTableValidator.this.canonicalStructureName, primTypeBinding.getPrimitive().getName(), invalidChar.toString()});
                return false;
            }
            return this.checkNumericLiteralContent(content, primTypeBinding, nodeForErrors);
        }

        @Override
        boolean checkBooleanLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5026, new String[]{content, DataTableValidator.this.canonicalStructureName});
            return false;
        }
    }

    private abstract class ContentToPrimitiveTypeChecker {
        private ContentToPrimitiveTypeChecker() {
        }

        abstract boolean checkStringLiteralContent(String var1, PrimitiveTypeBinding var2, Node var3);

        abstract boolean checkBooleanLiteralContent(String var1, PrimitiveTypeBinding var2, Node var3);

        abstract boolean checkNumericLiteralContent(String var1, PrimitiveTypeBinding var2, Node var3);
    }

    private class ContentToUserDefinedLengthAndDecimalTypeChecker
    extends ContentToNumericTypeChecker {
        private ContentToUserDefinedLengthAndDecimalTypeChecker() {
        }

        @Override
        boolean checkNumericLiteralContent(String content, PrimitiveTypeBinding primTypeBinding, Node nodeForErrors) {
            int totalContentLength = 0;
            int contentLengthBeforeDecimalPoint = 0;
            int contentLengthAfterDecimalPoint = 0;
            StringTokenizer st = new StringTokenizer(content, "-.", true);
            if (st.hasMoreTokens()) {
                String firstToken = st.nextToken();
                if ("-".equals(firstToken)) {
                    firstToken = st.nextToken();
                }
                if (".".equals(firstToken)) {
                    contentLengthBeforeDecimalPoint = 0;
                    totalContentLength = contentLengthAfterDecimalPoint = this.trimZerosFromRight(st.nextToken()).length();
                } else {
                    contentLengthBeforeDecimalPoint = firstToken.length();
                    if (st.hasMoreTokens()) {
                        String nextToken = st.nextToken();
                        if (".".equals(nextToken)) {
                            nextToken = st.nextToken();
                        }
                        contentLengthAfterDecimalPoint = this.trimZerosFromRight(nextToken).length();
                    }
                    totalContentLength = contentLengthBeforeDecimalPoint + contentLengthAfterDecimalPoint;
                }
            }
            if (contentLengthAfterDecimalPoint > 32) {
                DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5024, new String[]{content, DataTableValidator.this.canonicalStructureName, Integer.toString(contentLengthAfterDecimalPoint)});
                return false;
            }
            if (contentLengthAfterDecimalPoint > primTypeBinding.getDecimals()) {
                DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5025, new String[]{content, DataTableValidator.this.canonicalStructureName, Integer.toString(contentLengthAfterDecimalPoint)});
                return false;
            }
            int typeBindingLength = primTypeBinding.getLength();
            if (totalContentLength > typeBindingLength) {
                DataTableValidator.this.problemRequestor.acceptProblem(nodeForErrors, 5023, new String[]{content, DataTableValidator.this.canonicalStructureName, primTypeBinding.getPrimitive().getName(), Integer.toString(typeBindingLength), Integer.toString(totalContentLength)});
                return false;
            }
            return true;
        }

        private String trimZerosFromRight(String str) {
            return str.replaceFirst("0+$", "");
        }
    }

    private class ContentsAnnotationChecker
    extends DefaultASTVisitor {
        boolean foundContents = false;
        boolean foundSharedNo = false;
        boolean foundResidentYes = false;
        Column[] columns;

        public ContentsAnnotationChecker(Column[] columns) {
            this.columns = columns;
        }

        @Override
        public boolean visit(DataTable dataTable) {
            return true;
        }

        @Override
        public boolean visit(SettingsBlock settingsBlock) {
            return true;
        }

        @Override
        public boolean visit(Assignment assignment) {
            IBinding binding;
            if (assignment.getLeftHandSide().isName() && (binding = ((Name)assignment.getLeftHandSide()).resolveBinding()) != null && IBinding.NOT_FOUND_BINDING != binding && binding.isAnnotationBinding()) {
                IAnnotationBinding ann = (IAnnotationBinding)binding;
                if (InternUtil.intern((String)"contents") == binding.getName()) {
                    this.foundContents = true;
                    if (ann.getValue() != null) {
                        if (assignment.getRightHandSide() instanceof ArrayLiteral) {
                            assignment.getRightHandSide().accept(this);
                        } else {
                            DataTableValidator.this.problemRequestor.acceptProblem(assignment.getRightHandSide(), 5002);
                        }
                    }
                } else if (InternUtil.intern((String)"shared") == binding.getName()) {
                    if (ann.getValue() == Boolean.NO) {
                        this.foundSharedNo = true;
                        if (this.foundResidentYes) {
                            DataTableValidator.this.problemRequestor.acceptProblem(assignment.getRightHandSide(), 5007);
                        }
                    }
                } else if (InternUtil.intern((String)"resident") == binding.getName() && ann.getValue() == Boolean.YES) {
                    this.foundResidentYes = true;
                    if (this.foundSharedNo) {
                        DataTableValidator.this.problemRequestor.acceptProblem(assignment.getRightHandSide(), 5008);
                    }
                }
            }
            return false;
        }

        @Override
        public boolean visit(final ArrayLiteral arrayLiteral) {
            final boolean[] errorEncountered = new boolean[1];
            Iterator iter = arrayLiteral.getExpressions().iterator();
            while (iter.hasNext() && !errorEncountered[0]) {
                ((Node)iter.next()).accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public void endVisit(ArrayLiteral arrayLiteral2) {
                        arrayLiteral2.accept(new ContentsArrayChecker(ContentsAnnotationChecker.this.columns));
                    }

                    @Override
                    public void endVisitExpression(Expression expression) {
                        ((ContentsAnnotationChecker)ContentsAnnotationChecker.this).DataTableValidator.this.problemRequestor.acceptProblem(arrayLiteral, 5002);
                        errorEncountered[0] = true;
                    }
                });
            }
            return false;
        }
    }

    private class ContentsArrayChecker
    extends AbstractASTExpressionVisitor {
        boolean visitingTopLevel = true;
        boolean isNegative;
        Column[] columns;
        int elementsVisited = 0;

        public ContentsArrayChecker(Column[] columns) {
            this.columns = columns;
        }

        @Override
        public boolean visit(ArrayLiteral arrayLiteral) {
            if (this.visitingTopLevel) {
                this.visitingTopLevel = false;
                List expressions = arrayLiteral.getExpressions();
                if (expressions.size() != this.columns.length) {
                    DataTableValidator.this.problemRequestor.acceptProblem((Node)arrayLiteral, 5004, new String[]{DataTableValidator.this.canonicalStructureName, Integer.toString(this.columns.length), Integer.toString(expressions.size())});
                }
                Iterator iter = expressions.iterator();
                while (iter.hasNext()) {
                    this.isNegative = false;
                    ((Expression)iter.next()).accept(this);
                    ++this.elementsVisited;
                }
            } else {
                this.visitExpression(arrayLiteral);
            }
            return false;
        }

        private void checkStringLiteralAgainstColumn(String contentString, Node contentNode) {
            ContentToPrimitiveTypeChecker checker;
            if (this.elementsVisited < this.columns.length && (checker = DataTableValidator.this.getChecker(this.columns[this.elementsVisited].columnType.getPrimitive())) != null && checker.checkStringLiteralContent(contentString, this.columns[this.elementsVisited].columnType, contentNode)) {
                this.checkTypeCompatibility(contentNode);
            }
        }

        private void checkBooleanLiteralAgainstColumn(String contentString, Node contentNode) {
            ContentToPrimitiveTypeChecker checker;
            if (this.elementsVisited < this.columns.length && (checker = DataTableValidator.this.getChecker(this.columns[this.elementsVisited].columnType.getPrimitive())) != null && checker.checkBooleanLiteralContent(contentString, this.columns[this.elementsVisited].columnType, contentNode)) {
                this.checkTypeCompatibility(contentNode);
            }
        }

        private void checkNumericLiteralAgainstColumn(String contentString, Node contentNode) {
            ContentToPrimitiveTypeChecker checker;
            if (this.elementsVisited < this.columns.length && (checker = DataTableValidator.this.getChecker(this.columns[this.elementsVisited].columnType.getPrimitive())) != null && checker.checkNumericLiteralContent(contentString, this.columns[this.elementsVisited].columnType, contentNode)) {
                this.checkTypeCompatibility(contentNode);
            }
        }

        private void checkTypeCompatibility(Node contentNode) {
            Expression expression;
            ITypeBinding contentTypeBinding;
            if (contentNode instanceof Expression && Binding.isValidBinding(contentTypeBinding = (expression = (Expression)contentNode).resolveTypeBinding()) && !TypeCompatibilityUtil.isMoveCompatible(this.columns[this.elementsVisited].columnType, contentTypeBinding, null, DataTableValidator.this.compilerOptions)) {
                DataTableValidator.this.problemRequestor.acceptProblem(contentNode, 6653, new String[]{StatementValidator.getTypeString(contentTypeBinding), StatementValidator.getTypeString(this.columns[this.elementsVisited].columnType), String.valueOf(this.columns[this.elementsVisited].columnName) + " = " + expression.getCanonicalString()});
            }
        }

        private String getNumericString(String str) {
            return this.isNegative ? "-" + str : str;
        }

        @Override
        public boolean visit(UnaryExpression unaryExpression) {
            if (unaryExpression.getOperator() == UnaryExpression.Operator.MINUS) {
                this.isNegative = !this.isNegative;
            }
            return true;
        }

        @Override
        public boolean visit(IntegerLiteral integerLiteral) {
            this.checkNumericLiteralAgainstColumn(this.getNumericString(integerLiteral.getValue()), integerLiteral);
            return false;
        }

        @Override
        public boolean visit(FloatLiteral floatLiteral) {
            this.checkNumericLiteralAgainstColumn(this.getNumericString(floatLiteral.getValue()), floatLiteral);
            return false;
        }

        @Override
        public boolean visit(DecimalLiteral decimalLiteral) {
            this.checkNumericLiteralAgainstColumn(this.getNumericString(decimalLiteral.getValue()), decimalLiteral);
            return false;
        }

        @Override
        public boolean visit(StringLiteral stringLiteral) {
            this.checkStringLiteralAgainstColumn(stringLiteral.getValue(), stringLiteral);
            return false;
        }

        @Override
        public boolean visit(CharLiteral stringLiteral) {
            this.checkStringLiteralAgainstColumn(stringLiteral.getValue(), stringLiteral);
            return false;
        }

        @Override
        public boolean visit(DBCharLiteral stringLiteral) {
            this.checkStringLiteralAgainstColumn(stringLiteral.getValue(), stringLiteral);
            return false;
        }

        @Override
        public boolean visit(MBCharLiteral stringLiteral) {
            this.checkStringLiteralAgainstColumn(stringLiteral.getValue(), stringLiteral);
            return false;
        }

        @Override
        public boolean visit(HexLiteral stringLiteral) {
            this.checkStringLiteralAgainstColumn(stringLiteral.getValue(), stringLiteral);
            return false;
        }

        @Override
        public boolean visit(BinaryExpression binaryExpression) {
            if (new AnnotationTypeBinding.IsStringLiteralChecker().isStringLiteral(binaryExpression)) {
                this.checkStringLiteralAgainstColumn(this.getString(binaryExpression), binaryExpression);
            }
            return false;
        }

        @Override
        public boolean visit(BooleanLiteral booleanLiteral) {
            this.checkBooleanLiteralAgainstColumn(booleanLiteral.getCanonicalString(), booleanLiteral);
            return false;
        }

        private String getString(Expression expr) {
            final String[] result = new String[1];
            expr.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(StringLiteral stringLiteral) {
                    result[0] = stringLiteral.getValue();
                    return false;
                }

                @Override
                public boolean visit(CharLiteral stringLiteral) {
                    result[0] = stringLiteral.getValue();
                    return false;
                }

                @Override
                public boolean visit(DBCharLiteral stringLiteral) {
                    result[0] = stringLiteral.getValue();
                    return false;
                }

                @Override
                public boolean visit(MBCharLiteral stringLiteral) {
                    result[0] = stringLiteral.getValue();
                    return false;
                }

                @Override
                public boolean visit(HexLiteral stringLiteral) {
                    result[0] = stringLiteral.getValue();
                    return false;
                }

                @Override
                public boolean visit(BinaryExpression binaryExpression) {
                    result[0] = String.valueOf(ContentsArrayChecker.this.getString(binaryExpression.getFirstExpression())) + ContentsArrayChecker.this.getString(binaryExpression.getSecondExpression());
                    return false;
                }
            });
            return result[0];
        }

        @Override
        public boolean visitExpression(Expression expression) {
            DataTableValidator.this.problemRequestor.acceptProblem((Node)expression, 5026, new String[]{expression.getCanonicalString(), DataTableValidator.this.canonicalStructureName});
            return false;
        }
    }

    private class DefaultDataTableItemValidator
    extends FixedStructureValidator.DefaultStructureItemValidator {
        public DefaultDataTableItemValidator() {
            super(DataTableValidator.this);
        }

        @Override
        public void validate(FixedStructureValidator.StructureItemInfo sItemInfo) {
            super.validate(sItemInfo);
            if (sItemInfo.binding.hasOccurs()) {
                DataTableValidator.this.problemRequestor.acceptProblem(sItemInfo.nodeForErrors, 4180, new String[]{sItemInfo.canonicalName, DataTableValidator.this.canonicalStructureName});
            }
            if (sItemInfo.structureItemNode.hasInitializer()) {
                DataTableValidator.this.problemRequestor.acceptProblem(sItemInfo.structureItemNode.getInitializer(), 7752);
            }
        }
    }

    private class DefaultDataTableItemValidatorFactory
    extends FixedStructureValidator.StructureItemValidatorFactory {
        private DefaultDataTableItemValidatorFactory() {
            super(DataTableValidator.this);
        }

        @Override
        FixedStructureValidator.StructureItemValidator createStructureItemValidator() {
            return new DefaultDataTableItemValidator();
        }
    }
}

